(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10428,        351]
NotebookOptionsPosition[      8059,        273]
NotebookOutlinePosition[      9525,        318]
CellTagsIndexPosition[      9409,        312]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::lsopt", "ObjectName",
 CellID->27933],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"lsopt\"\>"}], ":", 
  " ", "\<\"The option `1` -> `2` should either be a single value or a list \
of length equal to the number of spatial independent variables, `3`.\"\>"}]], \
"Message", "MSG",
 CellID->349084709],

Cell["\<\
Generated when the value of the indicated option does not have one of the \
expected forms.\
\>", "Notes",
 CellID->18664]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->703640940],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->196148586],

Cell[TextData[{
 "An error occurs in this example because a list with one element is not a  \
valid value for the ",
 StyleBox["MinPoints", "MR"],
 " option when there are two spatial variables."
}], "ExampleText",
 CellID->52157095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", 
      "\[Equal]", " ", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "t"}], "]"}], ",", "x", ",", "x"}], 
        "]"}], " ", "+", " ", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "t"}], "]"}], ",", "y", ",", "y"}], 
        "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "y", ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "10"}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "y", ",", "t"}], "]"}], " ", "\[Equal]", " ",
       
      RowBox[{"Exp", "[", 
       RowBox[{"-", "10"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "1", ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"MinPoints", "\[Rule]", 
          RowBox[{"{", "10", "}"}]}]}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",\

 CellTags->"NDSolve::lsopt",
 CellLabel->"In[1]:=",
 CellID->32338],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"lsopt\"\>"}], ":", 
  " ", "\<\"The option \\!\\(\\\"MinPoints\\\"\\) -> \\!\\({10}\\) should \
either be a single value or a list of length equal to the number of spatial \
independent variables, \\!\\(2\\).\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::lsopt",
 CellID->13265722],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["u", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "t"}], "]"}], "+", 
       RowBox[{
        SuperscriptBox["u", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "t"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "y", ",", "t"}], "]"}], "\[Equal]", 
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", "10"]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "y", ",", "t"}], "]"}], "\[Equal]", 
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", "10"]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "1", ",", "t"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "t"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        SuperscriptBox["x", "2"]}]]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"MethodOfLines\"\>", ",", 
      RowBox[{"\<\"SpatialDiscretization\"\>", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\<\"TensorProductGrid\"\>", ",", 
         RowBox[{"MinPoints", "\[Rule]", 
          RowBox[{"{", "10", "}"}]}]}], "}"}]}]}], "}"}]}]}], "]"}]], "Output",\

 CellTags->"NDSolve::lsopt",
 CellLabel->"Out[1]=",
 CellID->50081743]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::lsopt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 34.9529732}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::lsopt", "synonyms" -> {}, "title" -> 
    "NDSolve::lsopt", "type" -> "Message", "uri" -> "ref/message/lsopt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1701, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->703640940]},
 "NDSolve::lsopt"->{
  Cell[2495, 97, 2459, 75, 70, "Input",
   CellTags->"NDSolve::lsopt",
   CellID->32338],
  Cell[4957, 174, 339, 7, 70, "Message",
   CellTags->"NDSolve::lsopt",
   CellID->13265722],
  Cell[5299, 183, 2694, 83, 70, "Output",
   CellTags->"NDSolve::lsopt",
   CellID->50081743]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8966, 295},
 {"NDSolve::lsopt", 9106, 299}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->27933],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 271, 6, 70, "Message",
 CellID->349084709],
Cell[1532, 57, 132, 4, 70, "Notes",
 CellID->18664]
}, Closed]],
Cell[CellGroupData[{
Cell[1701, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->703640940],
Cell[CellGroupData[{
Cell[2086, 80, 148, 5, 70, "ExampleSection",
 CellID->196148586],
Cell[2237, 87, 233, 6, 70, "ExampleText",
 CellID->52157095],
Cell[CellGroupData[{
Cell[2495, 97, 2459, 75, 70, "Input",
 CellTags->"NDSolve::lsopt",
 CellID->32338],
Cell[4957, 174, 339, 7, 70, "Message",
 CellTags->"NDSolve::lsopt",
 CellID->13265722],
Cell[5299, 183, 2694, 83, 70, "Output",
 CellTags->"NDSolve::lsopt",
 CellID->50081743]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8032, 271, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

