(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10914,        380]
NotebookOptionsPosition[      8085,        286]
NotebookOutlinePosition[      9738,        337]
CellTagsIndexPosition[      9622,        331]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::mmpts", "ObjectName",
 CellID->31007],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mmpts\"\>"}], ":", 
  " ", "\<\"Number of steps for independent variable `1` required by \
MaxStepSize -> `2` or MinPoints -> `3` is greater than the number of steps \
allowed by MinStepSize -> `4` and/or MaxPoints -> `5`.\"\>"}]], "Message", \
"MSG",
 CellID->275683122],

Cell["Generated by conflicting values of the indicated options.", "Notes",
 CellID->18742]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->116974551],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->145880170],

Cell[TextData[{
 "An error occurs in this example because there is no step size that can  \
satisfy both the specification given by the value of the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option and the specification given by the value of the ",
 Cell[BoxData[
  ButtonBox["MaxStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxStepSize"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->574537151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"MaxSteps", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"15", ",", " ", "Infinity"}], "}"}]}], ",", " ", 
   RowBox[{"MaxStepSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".001", ",", " ", "Infinity"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::mmpts",
 CellLabel->"In[1]:=",
 CellID->28884],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mmpts\"\>"}], ":", 
  " ", "\<\"Number of steps for independent variable \\!\\(x\\) required by \
MaxStepSize -> \\!\\(0.001`\\) or MinPoints -> \\!\\(Automatic\\) is greater \
than the number of steps allowed by MinStepSize -> \\!\\(Automatic\\) and/or \
MaxPoints -> \\!\\(15\\).\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::mmpts",
 CellID->16157294],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", 
   RowBox[{"MaxSteps", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"15", ",", "\[Infinity]"}], "}"}]}], ",", 
   RowBox[{"MaxStepSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.001`", ",", "\[Infinity]"}], "}"}]}]}], "]"}]], "Output",
 CellTags->"NDSolve::mmpts",
 CellLabel->"Out[1]=",
 CellID->222333875]
}, Open  ]],

Cell[TextData[{
 "One way to avoid the error in this example is by removing the setting of  \
the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->155641641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"MaxStepSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".001", ",", " ", "Infinity"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::mmpts",
 CellLabel->"In[2]:=",
 CellID->16788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::mmpts",
 CellLabel->"Out[2]=",
 CellID->80659419]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::mmpts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 42.5312922}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::mmpts", "synonyms" -> {}, "title" -> 
    "NDSolve::mmpts", "type" -> "Message", "uri" -> "ref/message/mmpts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1715, 64, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->116974551]},
 "NDSolve::mmpts"->{
  Cell[2783, 103, 1316, 41, 70, "Input",
   CellTags->"NDSolve::mmpts",
   CellID->28884],
  Cell[4102, 146, 412, 8, 70, "Message",
   CellTags->"NDSolve::mmpts",
   CellID->16157294],
  Cell[4517, 156, 1460, 48, 70, "Output",
   CellTags->"NDSolve::mmpts",
   CellID->222333875],
  Cell[6287, 220, 1200, 38, 70, "Input",
   CellTags->"NDSolve::mmpts",
   CellID->16788],
  Cell[7490, 260, 529, 19, 70, "Output",
   CellTags->"NDSolve::mmpts",
   CellID->80659419]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8992, 308},
 {"NDSolve::mmpts", 9132, 312}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->31007],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 327, 7, 70, "Message",
 CellID->275683122],
Cell[1588, 58, 90, 1, 70, "Notes",
 CellID->18742]
}, Closed]],
Cell[CellGroupData[{
Cell[1715, 64, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->116974551],
Cell[CellGroupData[{
Cell[2100, 78, 148, 5, 70, "ExampleSection",
 CellID->145880170],
Cell[2251, 85, 507, 14, 70, "ExampleText",
 CellID->574537151],
Cell[CellGroupData[{
Cell[2783, 103, 1316, 41, 70, "Input",
 CellTags->"NDSolve::mmpts",
 CellID->28884],
Cell[4102, 146, 412, 8, 70, "Message",
 CellTags->"NDSolve::mmpts",
 CellID->16157294],
Cell[4517, 156, 1460, 48, 70, "Output",
 CellTags->"NDSolve::mmpts",
 CellID->222333875]
}, Open  ]],
Cell[5992, 207, 270, 9, 70, "ExampleText",
 CellID->155641641],
Cell[CellGroupData[{
Cell[6287, 220, 1200, 38, 70, "Input",
 CellTags->"NDSolve::mmpts",
 CellID->16788],
Cell[7490, 260, 529, 19, 70, "Output",
 CellTags->"NDSolve::mmpts",
 CellID->80659419]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8058, 284, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

