(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6694,        241]
NotebookOptionsPosition[      4332,        163]
NotebookOutlinePosition[      5796,        208]
CellTagsIndexPosition[      5680,        202]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::mrsti", "ObjectName",
 CellID->28665],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mrsti\"\>"}], ":", 
  " ", "\<\"Number of steps `1` required by `2` -> `3` should be a \
machine-sized integer.\"\>"}]], "Message", "MSG",
 CellID->217992179],

Cell[TextData[{
 "Generated when the value of the ",
 StyleBox["MaxRelativeStepSize", "MR"],
 " option leads to an excessive number of steps."
}], "Notes",
 CellID->7524]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->554839611],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->4769773],

Cell[TextData[{
 "An error is generated in this example because of the excessively small  \
value of the ",
 StyleBox["MaxRelativeStepSize", "MR"],
 " option."
}], "ExampleText",
 CellID->76928294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
       RowBox[{"x", "[", "t", "]"}]}], " ", "==", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], 
    "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"MaxRelativeStepSize", "\[Rule]", 
    RowBox[{"2", "^", 
     RowBox[{"-", "32"}]}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::mrsti",
 CellLabel->"In[1]:=",
 CellID->7781],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mrsti\"\>"}], ":", 
  " ", "\<\"Number of steps \\!\\(4294967296\\) required by \
\\!\\(MaxStepFraction\\) -> \\!\\(1\\/10\\) should be a machine-sized \
integer.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::mrsti",
 CellID->306526258],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "+", 
       RowBox[{
        SuperscriptBox["x", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}],
    ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"MaxRelativeStepSize", "\[Rule]", 
    FractionBox["1", "4294967296"]}]}], "]"}]], "Output",
 CellTags->"NDSolve::mrsti",
 CellLabel->"Out[1]=",
 CellID->14845646]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::mrsti - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 42.8750510}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::mrsti", "synonyms" -> {}, "title" -> 
    "NDSolve::mrsti", "type" -> "Message", "uri" -> "ref/message/mrsti"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1682, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->554839611]},
 "NDSolve::mrsti"->{
  Cell[2438, 97, 741, 23, 70, "Input",
   CellTags->"NDSolve::mrsti",
   CellID->7781],
  Cell[3182, 122, 294, 7, 70, "Message",
   CellTags->"NDSolve::mrsti",
   CellID->306526258],
  Cell[3479, 131, 787, 25, 70, "Output",
   CellTags->"NDSolve::mrsti",
   CellID->14845646]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5239, 185},
 {"NDSolve::mrsti", 5379, 189}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->28665],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 214, 5, 70, "Message",
 CellID->217992179],
Cell[1475, 56, 170, 5, 70, "Notes",
 CellID->7524]
}, Closed]],
Cell[CellGroupData[{
Cell[1682, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->554839611],
Cell[CellGroupData[{
Cell[2067, 80, 146, 5, 70, "ExampleSection",
 CellID->4769773],
Cell[2216, 87, 197, 6, 70, "ExampleText",
 CellID->76928294],
Cell[CellGroupData[{
Cell[2438, 97, 741, 23, 70, "Input",
 CellTags->"NDSolve::mrsti",
 CellID->7781],
Cell[3182, 122, 294, 7, 70, "Message",
 CellTags->"NDSolve::mrsti",
 CellID->306526258],
Cell[3479, 131, 787, 25, 70, "Output",
 CellTags->"NDSolve::mrsti",
 CellID->14845646]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4305, 161, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

