(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8437,        295]
NotebookOptionsPosition[      6080,        217]
NotebookOutlinePosition[      7537,        262]
CellTagsIndexPosition[      7422,        256]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::msti", "ObjectName",
 CellID->4765],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"msti\"\>"}], ":", 
  " ", "\<\"Number of steps `1` required by MaxStepSize -> `2` for \
independent variable `3` should be a machine-sized integer.\"\>"}]], "Message",\
 "MSG",
 CellID->302550507],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["MaxStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxStepSize"]], "InlineFormula"],
 " option leads to an excessive number of steps."
}], "Notes",
 CellID->16419]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474507852],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->186572999],

Cell[TextData[{
 "An error is generated in this example because of the excessively small  \
value of the ",
 Cell[BoxData[
  ButtonBox["MaxStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxStepSize"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->238818008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", 
         RowBox[{"MaxStepSize", "\[Rule]", 
          RowBox[{"2", "^", 
           RowBox[{"-", "32"}]}]}]}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::msti",
 CellLabel->"In[1]:=",
 CellID->13904],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"msti\"\>"}], ":", 
  " ", "\<\"Number of steps \\!\\(8589934592\\) required by MaxStepSize -> \
\\!\\(2.3283064365386963`*^-10\\) for independent variable \\!\\(x\\) should \
be a machine-sized integer.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::msti",
 CellID->505176611],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"MethodOfLines\"\>", ",", 
      RowBox[{"\<\"SpatialDiscretization\"\>", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\<\"TensorProductGrid\"\>", ",", 
         RowBox[{"MaxStepSize", "\[Rule]", 
          FractionBox["1", "4294967296"]}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Output",
 CellTags->"NDSolve::msti",
 CellLabel->"Out[1]=",
 CellID->889775]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::msti - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 43.0156796}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::msti", "synonyms" -> {}, "title" -> 
    "NDSolve::msti", "type" -> "Message", "uri" -> "ref/message/msti"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1804, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->474507852]},
 "NDSolve::msti"->{
  Cell[2648, 104, 1451, 44, 70, "Input",
   CellTags->"NDSolve::msti",
   CellID->13904],
  Cell[4102, 150, 333, 7, 70, "Message",
   CellTags->"NDSolve::msti",
   CellID->505176611],
  Cell[4438, 159, 1576, 51, 70, "Output",
   CellTags->"NDSolve::msti",
   CellID->889775]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6983, 239},
 {"NDSolve::msti", 7122, 243}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->4765],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 252, 6, 70, "Message",
 CellID->302550507],
Cell[1511, 57, 256, 8, 70, "Notes",
 CellID->16419]
}, Closed]],
Cell[CellGroupData[{
Cell[1804, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474507852],
Cell[CellGroupData[{
Cell[2189, 84, 148, 5, 70, "ExampleSection",
 CellID->186572999],
Cell[2340, 91, 283, 9, 70, "ExampleText",
 CellID->238818008],
Cell[CellGroupData[{
Cell[2648, 104, 1451, 44, 70, "Input",
 CellTags->"NDSolve::msti",
 CellID->13904],
Cell[4102, 150, 333, 7, 70, "Message",
 CellTags->"NDSolve::msti",
 CellID->505176611],
Cell[4438, 159, 1576, 51, 70, "Output",
 CellTags->"NDSolve::msti",
 CellID->889775]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6053, 215, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

