(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77334,       1561]
NotebookOptionsPosition[     72804,       1407]
NotebookOutlinePosition[     75093,       1479]
CellTagsIndexPosition[     74974,       1473]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::mxst", "ObjectName",
 CellID->18928],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxst\"\>"}], ":", 
  " ", "\<\"Maximum number of `1` steps reached at the point `2` == \
`3`.\"\>"}]], "Message", "MSG",
 CellID->511025633],

Cell[TextData[{
 "Generated when the number of steps used in solving a   differential \
equation exceeds the value specified by the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->3240],

Cell["\<\
This message can be generated if the   solution has many features or \
oscillations that must be resolved, or if the   solution has a sharp or \
singular feature that can be represented only with   very fine resolution.\
\>", "Notes",
 CellID->14037],

Cell[TextData[{
 "Difficulties associated with this   error can usually be resolved by \
increasing the value of the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option, or by lowering the values of the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " options."
}], "Notes",
 CellID->29155]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88077530],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->634920446],

Cell["\<\
A large number of steps is needed to construct a solution through all of the \
oscillations in this example.\
\>", "ExampleText",
 CellID->416045378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "'"}], "[", "x", "]"}], "+", 
       RowBox[{"f", "[", "x", "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "f", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
   RowBox[{"MaxSteps", "->", "100"}]}], "]"}]], "Input",
 CellTags->"NDSolve::mxst",
 CellLabel->"In[1]:=",
 CellID->13426],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxst\"\>"}], ":", 
  " ", "\<\"Maximum number of \\!\\(100\\) steps reached at the point \\!\\(x\
\\) == \\!\\(9.907632257379454`\\).\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::mxst",
 CellID->15788431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "9.907632257379454`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::mxst",
 CellLabel->"Out[1]=",
 CellID->76876349]
}, Open  ]],

Cell["This error can be avoided by increasing the number of steps.", \
"ExampleText",
 CellID->302461595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"f", "'"}], "'"}], "[", "x", "]"}], "+", 
        RowBox[{"f", "[", "x", "]"}]}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "'"}], "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "f", 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
    RowBox[{"MaxSteps", "->", "500"}]}], "]"}]}]], "Input",
 CellTags->"NDSolve::mxst",
 CellLabel->"In[2]:=",
 CellID->5633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::mxst",
 CellLabel->"Out[2]=",
 CellID->695682695]
}, Open  ]],

Cell["\<\
This shows a plot of the solution.  The exact solution is a sine function.\
\>", "ExampleText",
 CellID->505355399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "/.", "sol"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::mxst",
 CellLabel->"In[3]:=",
 CellID->15339],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwkmXc81d//wCXJqmyyszeXa7vOyyeFhpZKSVKSkcooySxkJCQhhUoD7URR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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 50}, {-1.000000548461634, 0.9999984001213422}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->"NDSolve::mxst",
 CellLabel->"Out[3]=",
 CellID->642003382]
}, Open  ]],

Cell["\<\
This error can also be avoided by lowering the error tolerances.  With this \
change, the solution will be computed in fewer steps, but the solution will \
not be as accurate.\
\>", "ExampleText",
 CellID->431055197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"f", "'"}], "'"}], "[", "x", "]"}], "+", 
        RowBox[{"f", "[", "x", "]"}]}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "'"}], "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "f", 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
    RowBox[{"MaxSteps", "->", "100"}], ",", 
    RowBox[{"AccuracyGoal", "->", "2"}]}], "]"}]}]], "Input",
 CellTags->"NDSolve::mxst",
 CellLabel->"In[4]:=",
 CellID->10685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::mxst",
 CellLabel->"Out[4]=",
 CellID->505471411]
}, Open  ]],

Cell["\<\
A plot of the solution shows the effect of using low error tolerances.\
\>", "ExampleText",
 CellID->935671292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "/.", "sol"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::mxst",
 CellLabel->"In[5]:=",
 CellID->9806],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwkV3c8lu/3JyqKskf23uPhscd1lApJfYqSBjKLhIxIJZGSJEkoJA2atlK5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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 50}, {-1.6297989937879325`, 1.5787028502363227`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->"NDSolve::mxst",
 CellLabel->"Out[5]=",
 CellID->210566519]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["sol", "MR"],
 "."
}], "ExampleText",
 CellID->729062388],

Cell[BoxData[
 RowBox[{"Clear", "[", "sol", "]"}]], "Input",
 CellTags->"NDSolve::mxst",
 CellLabel->"In[6]:=",
 CellID->24654]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::mxst - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 43.3281876}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::mxst", "synonyms" -> {}, "title" -> 
    "NDSolve::mxst", "type" -> "Message", "uri" -> "ref/message/mxst"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2644, 98, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->88077530]},
 "NDSolve::mxst"->{
  Cell[3363, 127, 637, 22, 70, "Input",
   CellTags->"NDSolve::mxst",
   CellID->13426],
  Cell[4003, 151, 263, 6, 70, "Message",
   CellTags->"NDSolve::mxst",
   CellID->15788431],
  Cell[4269, 159, 421, 15, 70, "Output",
   CellTags->"NDSolve::mxst",
   CellID->76876349],
  Cell[4835, 183, 679, 23, 70, "Input",
   CellTags->"NDSolve::mxst",
   CellID->5633],
  Cell[5517, 208, 407, 15, 70, "Output",
   CellTags->"NDSolve::mxst",
   CellID->695682695],
  Cell[6089, 233, 302, 10, 70, "Input",
   CellTags->"NDSolve::mxst",
   CellID->15339],
  Cell[6394, 245, 32328, 537, 70, "Output",
   CellTags->"NDSolve::mxst",
   CellID->642003382],
  Cell[38988, 794, 727, 24, 70, "Input",
   CellTags->"NDSolve::mxst",
   CellID->10685],
  Cell[39718, 820, 407, 15, 70, "Output",
   CellTags->"NDSolve::mxst",
   CellID->505471411],
  Cell[40286, 845, 301, 10, 70, "Input",
   CellTags->"NDSolve::mxst",
   CellID->9806],
  Cell[40590, 857, 31908, 530, 70, "Output",
   CellTags->"NDSolve::mxst",
   CellID->210566519],
  Cell[72623, 1397, 127, 4, 70, "Input",
   CellTags->"NDSolve::mxst",
   CellID->24654]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 73707, 1429},
 {"NDSolve::mxst", 73845, 1433}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->18928],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 196, 5, 70, "Message",
 CellID->511025633],
Cell[1456, 56, 293, 9, 70, "Notes",
 CellID->3240],
Cell[1752, 67, 260, 5, 70, "Notes",
 CellID->14037],
Cell[2015, 74, 592, 19, 70, "Notes",
 CellID->29155]
}, Closed]],
Cell[CellGroupData[{
Cell[2644, 98, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88077530],
Cell[CellGroupData[{
Cell[3028, 112, 148, 5, 70, "ExampleSection",
 CellID->634920446],
Cell[3179, 119, 159, 4, 70, "ExampleText",
 CellID->416045378],
Cell[CellGroupData[{
Cell[3363, 127, 637, 22, 70, "Input",
 CellTags->"NDSolve::mxst",
 CellID->13426],
Cell[4003, 151, 263, 6, 70, "Message",
 CellTags->"NDSolve::mxst",
 CellID->15788431],
Cell[4269, 159, 421, 15, 70, "Output",
 CellTags->"NDSolve::mxst",
 CellID->76876349]
}, Open  ]],
Cell[4705, 177, 105, 2, 70, "ExampleText",
 CellID->302461595],
Cell[CellGroupData[{
Cell[4835, 183, 679, 23, 70, "Input",
 CellTags->"NDSolve::mxst",
 CellID->5633],
Cell[5517, 208, 407, 15, 70, "Output",
 CellTags->"NDSolve::mxst",
 CellID->695682695]
}, Open  ]],
Cell[5939, 226, 125, 3, 70, "ExampleText",
 CellID->505355399],
Cell[CellGroupData[{
Cell[6089, 233, 302, 10, 70, "Input",
 CellTags->"NDSolve::mxst",
 CellID->15339],
Cell[6394, 245, 32328, 537, 70, "Output",
 CellTags->"NDSolve::mxst",
 CellID->642003382]
}, Open  ]],
Cell[38737, 785, 226, 5, 70, "ExampleText",
 CellID->431055197],
Cell[CellGroupData[{
Cell[38988, 794, 727, 24, 70, "Input",
 CellTags->"NDSolve::mxst",
 CellID->10685],
Cell[39718, 820, 407, 15, 70, "Output",
 CellTags->"NDSolve::mxst",
 CellID->505471411]
}, Open  ]],
Cell[40140, 838, 121, 3, 70, "ExampleText",
 CellID->935671292],
Cell[CellGroupData[{
Cell[40286, 845, 301, 10, 70, "Input",
 CellTags->"NDSolve::mxst",
 CellID->9806],
Cell[40590, 857, 31908, 530, 70, "Output",
 CellTags->"NDSolve::mxst",
 CellID->210566519]
}, Open  ]],
Cell[72513, 1390, 107, 5, 70, "ExampleText",
 CellID->729062388],
Cell[72623, 1397, 127, 4, 70, "Input",
 CellTags->"NDSolve::mxst",
 CellID->24654]
}, Open  ]]
}, Open  ]],
Cell[72777, 1405, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

