(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6776,        240]
NotebookOptionsPosition[      4395,        162]
NotebookOutlinePosition[      5870,        207]
CellTagsIndexPosition[      5753,        201]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ndfdmc", "ObjectName",
 CellID->27806],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndfdmc\"\>"}], ":", 
  " ", "\<\"Computed derivatives do not have dimensionality consistent with \
the initial conditions.\"\>"}]], "Message", "MSG",
 CellID->47638357],

Cell["\<\
Generated when the equations for the derivatives give values with list \
structures that are not equivalent to the lists used in specifying the \
initial conditions.\
\>", "Notes",
 CellID->27705]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189896350],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->138077852],

Cell["\<\
An error occurs in this example because the initial conditions are specified \
using lists and the equation for the derivatives gives scalar values for the \
derivatives.\
\>", "ExampleText",
 CellID->361984656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], ".", 
        RowBox[{"x", "[", "t", "]"}]}]}], " ", "==", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"{", "0", "}"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"{", "1", "}"}]}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndfdmc",
 CellLabel->"In[1]:=",
 CellID->16050],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndfdmc\"\>"}], ":", 
  " ", "\<\"Computed derivatives do not have dimensionality consistent with \
the initial conditions.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ndfdmc",
 CellID->240314413],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], ".", 
        RowBox[{"x", "[", "t", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["x", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
      RowBox[{"{", "1", "}"}]}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ndfdmc",
 CellLabel->"Out[1]=",
 CellID->338893899]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ndfdmc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 50.5627478}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ndfdmc", "synonyms" -> {}, "title" -> 
    "NDSolve::ndfdmc", "type" -> "Message", "uri" -> "ref/message/ndfdmc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1729, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->189896350]},
 "NDSolve::ndfdmc"->{
  Cell[2511, 96, 745, 23, 70, "Input",
   CellTags->"NDSolve::ndfdmc",
   CellID->16050],
  Cell[3259, 121, 255, 6, 70, "Message",
   CellTags->"NDSolve::ndfdmc",
   CellID->240314413],
  Cell[3517, 129, 812, 26, 70, "Output",
   CellTags->"NDSolve::ndfdmc",
   CellID->338893899]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5306, 184},
 {"NDSolve::ndfdmc", 5447, 188}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->27806],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 224, 5, 70, "Message",
 CellID->47638357],
Cell[1486, 56, 206, 5, 70, "Notes",
 CellID->27705]
}, Closed]],
Cell[CellGroupData[{
Cell[1729, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189896350],
Cell[CellGroupData[{
Cell[2114, 80, 148, 5, 70, "ExampleSection",
 CellID->138077852],
Cell[2265, 87, 221, 5, 70, "ExampleText",
 CellID->361984656],
Cell[CellGroupData[{
Cell[2511, 96, 745, 23, 70, "Input",
 CellTags->"NDSolve::ndfdmc",
 CellID->16050],
Cell[3259, 121, 255, 6, 70, "Message",
 CellTags->"NDSolve::ndfdmc",
 CellID->240314413],
Cell[3517, 129, 812, 26, 70, "Output",
 CellTags->"NDSolve::ndfdmc",
 CellID->338893899]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4368, 160, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

