(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7346,        247]
NotebookOptionsPosition[      4260,        157]
NotebookOutlinePosition[      6337,        214]
CellTagsIndexPosition[      6174,        207]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NDSolve::ndincd
NDSolve`Reinitialize::ndincd\
\>", "ObjectName",
 CellID->21957],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"ndincd\"\>"}], ":", 
  " ", "\<\"Initial conditions for derivatives of the function `1` do not \
have consistent dimensions.\"\>"}]], "Message", "MSG",
 CellID->124580173],

Cell["\<\
Generated when inequivalent lists are used in specifying initial conditions.\
\>", "Notes",
 CellID->29844]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->833892690],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->439312751],

Cell["\<\
An error is generated in this example because one of the two initial \
conditions is specified using a list and the other is not.\
\>", "ExampleText",
 CellID->345279866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
       RowBox[{"x", "[", "t", "]"}]}], " ", "==", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"{", "1", "}"}]}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
 CellLabel->"In[1]:=",
 CellID->28483],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndincd\"\>"}], ":", 
  " ", "\<\"Initial conditions for derivatives of the function \\!\\(x[t]\\) \
do not have consistent dimensions.\"\>"}]], "Message", "MSG",
 CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
 CellID->817558179],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "+", 
       RowBox[{
        SuperscriptBox["x", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
      RowBox[{"{", "1", "}"}]}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
 CellLabel->"Out[1]=",
 CellID->159702861]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ndincd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 50.7190018}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ndincd NDSolve`Reinitialize::ndincd", 
    "synonyms" -> {}, "title" -> "NDSolve::ndincd", "type" -> "Message", 
    "uri" -> "ref/message/ndincd"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1701, 68, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->833892690]},
 "NDSolve::ndincd"->{
  Cell[2442, 97, 689, 20, 70, "Input",
   CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
   CellID->28483],
  Cell[3134, 119, 301, 6, 70, "Message",
   CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
   CellID->817558179],
  Cell[3438, 127, 756, 23, 70, "Output",
   CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
   CellID->159702861]},
 "NDSolve`Reinitialize::ndincd"->{
  Cell[2442, 97, 689, 20, 70, "Input",
   CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
   CellID->28483],
  Cell[3134, 119, 301, 6, 70, "Message",
   CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
   CellID->817558179],
  Cell[3438, 127, 756, 23, 70, "Output",
   CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
   CellID->159702861]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5205, 180},
 {"NDSolve::ndincd", 5346, 184},
 {"NDSolve`Reinitialize::ndincd", 5766, 194}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 90, 4, 70, "ObjectName",
 CellID->21957],
Cell[CellGroupData[{
Cell[818, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1296, 52, 248, 6, 70, "Message",
 CellID->124580173],
Cell[1547, 60, 117, 3, 70, "Notes",
 CellID->29844]
}, Closed]],
Cell[CellGroupData[{
Cell[1701, 68, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->833892690],
Cell[CellGroupData[{
Cell[2086, 82, 148, 5, 70, "ExampleSection",
 CellID->439312751],
Cell[2237, 89, 180, 4, 70, "ExampleText",
 CellID->345279866],
Cell[CellGroupData[{
Cell[2442, 97, 689, 20, 70, "Input",
 CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
 CellID->28483],
Cell[3134, 119, 301, 6, 70, "Message",
 CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
 CellID->817558179],
Cell[3438, 127, 756, 23, 70, "Output",
 CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"},
 CellID->159702861]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4233, 155, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

