(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    109472,       2149]
NotebookOptionsPosition[    103980,       1963]
NotebookOutlinePosition[    106660,       2047]
CellTagsIndexPosition[    106538,       2041]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ndnum", "ObjectName",
 CellID->636],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndnum\"\>"}], ":", 
  " ", "\<\"Encountered non-numerical value for a derivative at `1` == `2`.\"\
\>"}]], "Message", "MSG",
 CellID->495655313],

Cell["\<\
Generated when non-numerical expressions are   encountered in a differential \
equation.\
\>", "Notes",
 CellID->5749],

Cell[TextData[{
 "The cause of   this error can usually be determined by checking the form of \
the first   argument in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " and verifying that numerical values have been assigned to all symbolic   \
parameters."
}], "Notes",
 CellID->12911],

Cell["\<\
Non-numerical expressions can often be   found by replacing the variable, the \
solution, and all of the derivatives in   the input with random or typical \
values and looking for non-numerical   expressions in the result.\
\>", "Notes",
 CellID->23391],

Cell["\<\
If you are unable to   determine the cause of this message, please send your \
example to Technical   Support.\
\>", "Notes",
 CellID->16362]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->144357420],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->308034389],

Cell["\<\
An error occurs in this example because the input contains a symbolic \
parameter that does not have a numerical value.\
\>", "ExampleText",
 CellID->486189692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"c", " ", 
       RowBox[{"f", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndnum",
 CellLabel->"In[1]:=",
 CellID->22523],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndnum\"\>"}], ":", 
  " ", "\<\"Encountered non-numerical value for a derivative at \\!\\(x\\) == \
\\!\\(1.`\\).\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ndnum",
 CellID->333041250],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"c", " ", 
       RowBox[{"f", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ndnum",
 CellLabel->"Out[1]=",
 CellID->315756931]
}, Open  ]],

Cell["\<\
The calculation is successful after a numerical value is assigned for the \
parameter.\
\>", "ExampleText",
 CellID->227776287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", " ", "=", " ", "1.7"}], "}"}], ",", 
   RowBox[{"sol", "=", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
         RowBox[{"c", " ", 
          RowBox[{"f", "[", "x", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellTags->"NDSolve::ndnum",
 CellLabel->"In[2]:=",
 CellID->360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ndnum",
 CellLabel->"Out[2]=",
 CellID->378247636]
}, Open  ]],

Cell["Evaluation of this input will give a plot of the solution.", \
"ExampleText",
 CellID->206280580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndnum",
 CellLabel->"In[3]:=",
 CellID->26845],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV038803kcwPFtNrY1GprOdQqlG91RUXeo3h+lRY9+LCnLw+msS3lcp4Qo
cce4lFC66io/TjmxK04e0i9lXVRD1uPuMdwVMss8WvnObLPZj/v0x/vxejz/
eb//ensJD0btpZBIpC14Pjbo0DEaiUTAUh8+42NryIaKMDIBAe51am8KAXPO
pa4U4R6qaGXzqARoWw7ss6cRQHhEBxXTCbg1E/+cxSTAYM0bn++M95xYV+w+
h4D5X7Bd+d4ELKlkcQK5BESuzbg+Hk6Ad3flokQ+AclrAq0zpwjoYmYXlF4n
oCxhpdKyWAPG2aMhk9MESJzl/P42DbgqS9Y8iNBA54Tw9ZOdk6Aq14oiqzSQ
XbNufxZFC2vnvfFgExqQ2Xdf3VunhZjjhcZLGyah5Jbfvl+FU7DrZurCoopJ
WJ4mj3L31MFwzVh1y/tJcCpSfMPu04H3jxzhtXAtOP8s35FRo4fxBd1HpOe1
cGpiU5z99wYoP9M5IFBqQVK/XbAhaBqYo8dyxKFTsLNJaox0M4LF0pqx4vQU
RJA9Bi4TRvjD1HBLpJiC3yf53BqlCXhPx0ODg3WQdaK/yDI4A3tjb7pzT+qg
52T/BXGvGZDML/jfIR08PZoxpHhtgSrWspsdS/UgHTQ10hVWuLdEI0wr1EPn
P8U6JpWEJJ/qEk8N6iFm2QON/yUS2izLfTTgb4BX3LR7gb5k9Mv+Z7vUBQbY
qlzcPCglo2+fXoz4us8AY7JClv8+CvpELy54t3gaOMYtI1U0O1TkkEkVZk9D
i5rvcrrVDomGevqcX0xDQfREUsoeKvrq8mt1vo8RRq/WZsYtoqG+Rcv4u7OM
8CK/TdakoiFzuiM9tcsI8e99jofW2qNX9dfIG71NsNJv8AYtywGF1TzeGpuK
rfaQNUfQUVmyj/rlYxOkl/TSfN0ZqHLeWinLfQbG7na0rrdjooDSMfNPSTOQ
FIs8v1MyUZaSl3KnfQay2uI8lytmoU2UgBBfFzM4lpe1V/ezEHMidhtZaAY2
b0HP4ZeOSPQQicvvmMF3N4vyt8oJ5UY3xqQwLKBmP1n4XD8bhfT08RgJFtDQ
0lcPlbHRECc8n95qgTxf6X3ml86I4RPsFuZgBZGsZfuYxBl9cFONr4q3Ql5n
WAc1yQUJehe4HG60gt/GnLZzTFfUGHOl0MlmBQu3ShPd4Iokj2UoeYcNiIuM
u8GJc5BgqmSzQ60NLntL6wfncpCY7lC+x2KDypS/DuDjqJOS65iMPZJ/v0mA
rTCbcjKxs0Uv9IewP9N8SCjG5q5bn1uNXTIg/7wV+3hv+kXKMAcdFtc2M602
iFuhePYEO3QTr6sJ2wX/cuQIBwl47aseYFNvry9MwE5DIQ2d2G9jb8uOYjcE
+Z/9D9uQokoQY3t6uMXQbDaI7y8tmKXgIOoH5YgA+0LVu5c92J6q3dF7sH2j
iHlvsVePDHT8gJ2jm51oxT4i76nLw5Y7/WbyH+Ug1cOW5BvYmaV2PmewqXcD
hm9jB3QNHazD9mqu3ybBLp2W32vHjr1eESTHbua6bdNgH6meWzuM3bQkvpyh
5KBzV87OfYfd7SkZ88L+8/yskzpsDzoEhmB3lxaYbNiP3vTlRGH/D7+TdAc=

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 1.},
  PlotRange->{{1, 2}, {1.0000000346938798`, 5.4739475077880675`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->"NDSolve::ndnum",
 CellLabel->"Out[3]=",
 CellID->499254238]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["sol", "MR"],
 "."
}], "ExampleText",
 CellID->280558918],

Cell[BoxData[
 RowBox[{"Clear", "[", "sol", "]"}]], "Input",
 CellTags->"NDSolve::ndnum",
 CellLabel->"In[4]:=",
 CellID->32117],

Cell["\<\
This example generates an error because the initial condition depends on the \
wrong variable.\
\>", "ExampleText",
 CellID->229518949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"t", 
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndnum",
 CellLabel->"In[5]:=",
 CellID->12794],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndnum\"\>"}], ":", 
  " ", "\<\"Encountered non-numerical value for a derivative at \\!\\(t\\) == \
\\!\\(0.`\\).\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ndnum",
 CellID->11256435],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], " ", "t"}]}]}], "}"}], ",", "f", ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ndnum",
 CellLabel->"Out[5]=",
 CellID->36450278]
}, Open  ]],

Cell["\<\
This example shows a calculation with a valid initial condition.\
\>", "ExampleText",
 CellID->8287936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "0"}], "]"}], "==", 
       RowBox[{"x", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"NDSolve::ndnum",
 CellLabel->"In[6]:=",
 CellID->3088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ndnum",
 CellLabel->"Out[6]=",
 CellID->24154533]
}, Open  ]],

Cell["Evaluation of this input will give a plot of the solution.", \
"ExampleText",
 CellID->452802500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "t"}], "]"}], " ", "/.", " ", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndnum",
 CellLabel->"In[7]:=",
 CellID->10078],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nQlcjF8Xx0Oy72uW+msha9lFOrJUQrZ/tixR9kq2LNmyJELEH9lLlihG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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmnf8l9P7x9/nfe4jI1RkRoqQNKxKae8lSmlQVpI9y95Fg4YRDWSEzLKy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         "]], Polygon3DBox[CompressedData["
1:eJw1mnngF9P3xufeuaMoVCikzZIlZd9JoYRQWZKUJEkIibKXnSiSPVH27RuR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         "]], Polygon3DBox[CompressedData["
1:eJwt13f81fMeB/DzO7/faZGrNBShtEX3itxrZbSuktVANH7todISWijjNsho
3FLRllJZaQ+jbpGQphAtVyQaMrrP9/2eP96P83k/v6/v+Z3zPd/P5/P9lc/v
eXuPdCqV2qgyanBuKlU3L5XqCJ/ISaUuZpc4sJyX1l/mtaxqzL6XGyk3j89X
g/iNrAN7XF/DuQPZDaw9G84uYmPZfjaULWDN2HusOZvNWnvvd/Xj1UH2KFsk
10LuYXY9a8eGsersGDvTOdtZYTU/vo/MBnXIuIHjDdUqmU1eP1K5xq/J9jO+
Vu4e40Her6L8Iv3tano6+b7xvTP6ks45yMqoFXJj2DPqZuNZMiVkV8p86HWj
ShvPl+1rfI1cS+OBchfKX+zYEl5KX8trGbWcrfe6Ljf5MV6V72l8lXObG/eX
LefQVY59yeKHe5o9o3rJXc1asAH68+RWyG3g/1E5xvMcG2d8QO4R44VyzeUe
YNexVmwIq8y6s7+zO1gvVpbdyaqya+I3Yoap19kxgxfZh6w3G8bqs+5sVNwz
7DFWj3VjI+M7s6WZ5HeP3/qUY3Mcy/Nagh8wPlstl1uiXyuzRv2ZvUfuM/6H
cVPj3t7vHLke7ErWLK45O5f1Z3XYvWwwq8SGswbsPjaaXc5q+xs7WWs2lD2i
psr9lz3F3tG3luvILmONWX785mw/687eZ/vZaPYl68CWs91sGNvB8tnbbBsb
wnaz9mwZ+4I9xvLZ31jDuD/ZGexr1omtZF+xx1kbVpPVZ/ez09le1pW9y/ay
kWwf68beY/vYKNaKXczqxrVkRdhO1o4tZtvZUNbZdSmo3mE72E41S+6w3Bi2
Wt9R7m5WndVh7VgB1oHVYo1YG3YWa8v+yhqwPqwouyjuTV5Sf2nMN9VaXSJX
L+YAP01uD+vMVrGv2ROsuXOPsolsGVuupssdYqNjnurbyX3AWmTvsTbOeV8/
U/0Yc5itkusg92Z2XRuVTt4r3nOG3A/sabZS317uBbaPDWGvsabsK9aRrWBf
suFsO2vL3mJb2WB2D6vBrmedWCH2Rsw/9TqrHesBX+D1FzaBrdf3lFvNmrKZ
7F6fdVVuMjeasVmsVSaZJ1PUd+xJtti5rZx7qWNb2Q2sC+uqPpW7hy1gHR3/
RL/Q6142OJ2s67G+H+fF+A5WJL6z97uLVZO7Vt82J9k/NrOWecna2gF8rJ+t
fmLPsjVyneTmsyNsHPuA3ZdK1s278pJ1ql0mWUO3qHvZwrhW7DP9Dq9/UdtY
IVUwPg//WW688Trv1yOVrH135iXraH4mWQdbqovYdfH55ArKvcJuZc+xN9jd
qWSfuDsvWb/bZ5I9Y5tqw95kn8d+J/dvdjN7jE1nN7G3s/fkJLaRbVBH5Hqz
T9kv+olyi+VW8hXq9+xv+pvxA8ZfGP8Z97Lc72wA281Oxf3IztVf4PycWCvi
3mJl2XnslL6m2sJOOt6f79L/4dxpsRbLVFB5jlXildU5MufHDxjzM75frBv6
MupYNhPZM+TOZkeMK8S1luuiL6LW6Q/6G9+pAd5nl2xbNkZfW+5CfWW5wrF2
x7rIDhqfFr+N/qTclLDs58s4dnnsweoC517ICrDa+p1y1TLJWhnrY9F4Vd+q
LrJrZcobj3CsuL6s7HFWJZ0865RnFWNtk7mC7WIVWCVWKPa+WI/Zg8Zf8Hz9
sz7fFayivkp859hvYq6zadn9o0062Y9jXy6nL8/TcpfGmi9Xgp3LftVXUx+x
kqwcO6mvrjaxs9g57IS+auyt7Hvv04Nv1B/y/s+xQ6wn+5D9wJ6PvTs7P7ay
E+zXeEaIayP3IJujv0Wuj8xZal92DsVc+kGul9xHxj/KvSBXPZOsJ7GGPMFL
Gh9V/eQ+1x+Xm+xYjUwyr2Muj439O9Yv1Vdui/6Y3IuO/cz6sM/YUTaJDWW7
WRc2gdVhOfF51TfxXKDmxjON/vRYV/SpuDayuexhtVdfQM1zaLm+kNxq/U8y
VdT58dyjcv2tinyD3Ev6wrFm6o/IjGdns6Hqd1ZOrWXL9AXkFun3xDOS2py9
79enk2sc13qG3BmxjrK0mh17D1unCsZzGasbz4b6h9S3+ox6VW66vqhzN+tz
1Ky43rJf8/v1Lzm/PluTSdbtWKszmWRt3Bp7ptwbxucZD5R7Wr807mnnzYz9
lxfVl3bOTzE/Yu2Ve5435gP1L8rVZSPYP1lf9gK7io3Sj4z13ng8Kx7zS78k
5pJ+nCoW8y/mFLvFuZ1ZafmF+tvUtHTyvBvPvTdm95lBbHLM/Xhecewm1o+N
1V/t3H+xhqwPe55dyX5k97NN7DAbG98j1nDVMvZxViqeF2K9YE1ifwuLY+wE
mxJzjfVlb7Ff2VT2MevHJrImbBibwRrFPs2Os8kxd1kfdooV9132sOKx38Ye
wE7KvaTfLNc/1nv2G3uZfcIeYJ1ijWM3xz7DSsa1jedBvlSNMz4R64vxLcYj
4l6RuyOeCbPzdz8rrUqpdzLJM0I8F/yRfSZ4zrhRzBHjSXHd4zkik+zVsT/n
ZZL9/4Pss96SdLKGx1peOO4L9T0rql53bgvnVGFX6xvl/n/LSI3OPlvcyLo7
r5uqmkn2pNiH/uSnxd6SSe7BuO8Ox/xl6/U71F36p5xX07En+R7Wm73MGrDH
2VesF5vK6rG52f+FeqaT+yfuoyJxT6lDsV/Fni73R+yTstd5rZObzK0CMqXY
dzJl1UrW1bHt/Hb9o7FusFmxN+cl58S8rCQzRz87L5nfMc8rs7n6V9Rb7MzY
a1iteE5ht6aTaxLXZnjsT/Ec5vg1aq/8gVg347rIHYj9I94jnsHUz6yEWsoe
yu7JR7O/d/zuE7J/47Z08n9L/P9STD9E/RLrtVoW64G/8Q0bEOuSTBP2P66U
CyU=
         "]], 
        Polygon3DBox[{{959, 1107, 677, 795, 1327, 958}}]}]}, {}, {}, {}}, {
     Line3DBox[{306, 1, 304, 234, 854, 16, 321, 867, 31, 328, 881, 46, 895, 
      61, 910, 76, 925, 91, 940, 106, 955, 956, 121, 982, 136, 995, 151, 1008,
       166, 1222, 310, 181, 1229, 323, 196, 1198, 267, 308, 211, 305, 266, 
      557, 212, 558, 213, 559, 214, 560, 215, 561, 216, 562, 217, 563, 218, 
      564, 565, 219, 566, 220, 567, 221, 568, 222, 569, 223, 570, 224, 812, 
      269, 317, 225, 315, 290, 1062, 210, 1048, 195, 1034, 180, 1020, 165, 
      1007, 150, 994, 135, 981, 980, 120, 953, 105, 938, 90, 923, 75, 908, 60,
       894, 45, 880, 30, 1160, 236, 316, 15, 314, 270, 375, 14, 373, 13, 371, 
      12, 369, 11, 367, 10, 365, 9, 362, 361, 8, 359, 7, 357, 6, 355, 5, 353, 
      4, 351, 3, 853, 345, 2, 780, 232, 306}], {
      Line3DBox[{854, 1217, 1218, 1159, 1232, 571, 1231, 1230, 1238, 1537, 
       1063, 855, 1417, 1064, 856, 1418, 1065, 857, 1419, 1066, 858, 1420, 
       1067, 859, 1421, 1068, 860, 1422, 1239, 1330, 861, 1423, 1069, 862, 
       1424, 1070, 863, 1425, 1071, 864, 1426, 1072, 865, 1427, 1073, 866, 
       1321, 1515, 1074, 1160}], 
      Line3DBox[{867, 327, 1200, 339, 1538, 1234, 1233, 1235, 586, 868, 1428, 
       1075, 869, 1429, 1076, 870, 1430, 1077, 871, 1431, 1078, 872, 1432, 
       1079, 873, 1433, 1240, 1331, 874, 1241, 1332, 875, 1434, 1080, 876, 
       1435, 1081, 877, 1436, 1082, 878, 1437, 1083, 879, 1438, 1084, 880}], 
      Line3DBox[{881, 1236, 1237, 1161, 1209, 1227, 1228, 1536, 1226, 1225, 
       1242, 1333, 882, 602, 883, 1439, 1085, 884, 1440, 1086, 885, 1441, 
       1087, 886, 1442, 1088, 887, 1443, 1243, 1334, 888, 1244, 1335, 889, 
       1245, 1336, 890, 1444, 1089, 891, 1445, 1090, 892, 1446, 1091, 893, 
       1447, 1092, 894}], 
      Line3DBox[{895, 238, 813, 272, 239, 1337, 896, 1246, 1338, 897, 618, 
       898, 1448, 1093, 899, 1449, 1094, 900, 1450, 1095, 901, 1451, 1247, 
       1339, 902, 1248, 1340, 903, 1249, 1341, 904, 1250, 1342, 905, 1452, 
       1096, 906, 1453, 1097, 907, 1454, 1098, 908}], 
      Line3DBox[{910, 1162, 1210, 1163, 1343, 909, 1164, 1165, 1344, 911, 
       1251, 1345, 912, 1252, 1346, 913, 634, 914, 1455, 1099, 915, 1456, 
       1100, 916, 1457, 1253, 1347, 917, 1254, 1348, 918, 1255, 1349, 919, 
       1256, 1350, 920, 1257, 1351, 921, 1458, 1101, 922, 1459, 1102, 923}], 
      Line3DBox[{925, 1166, 1211, 1167, 1352, 924, 1168, 1169, 1353, 926, 
       1170, 1516, 1322, 927, 1258, 1354, 928, 1259, 1355, 929, 650, 930, 
       1460, 1103, 931, 1461, 1260, 1356, 932, 1261, 1357, 933, 1262, 1358, 
       934, 1263, 1359, 935, 1264, 1360, 936, 1265, 1361, 937, 1462, 1104, 
       938}], Line3DBox[{940, 1171, 1172, 1362, 939, 1173, 1517, 1323, 941, 
       1174, 1518, 1324, 942, 1266, 1363, 943, 1267, 1364, 944, 1268, 1365, 
       945, 666, 946, 1463, 1269, 1366, 947, 1270, 1367, 948, 1271, 1368, 949,
        1272, 1369, 950, 1273, 1370, 951, 1274, 1371, 952, 1275, 1372, 953}], 
      Line3DBox[{956, 1176, 1520, 1105, 1201, 1178, 1522, 1106, 1202, 1180, 
       1524, 1107, 959, 1464, 1108, 961, 1465, 1109, 963, 1466, 1110, 965, 
       1467, 1111, 967, 1468, 683, 969, 1469, 1112, 971, 1470, 1113, 973, 
       1471, 1114, 975, 1472, 1115, 977, 1473, 1116, 979, 1474, 1117, 981}], 
      Line3DBox[{980, 1383, 1285, 978, 1382, 1284, 976, 1381, 1283, 974, 1380,
        1282, 972, 1379, 1281, 970, 1378, 1280, 968, 1377, 682, 966, 1376, 
       1279, 964, 1375, 1278, 962, 1374, 1277, 960, 1373, 1276, 958, 1327, 
       1523, 1179, 957, 1326, 1521, 1177, 954, 1325, 1519, 1175, 955}], 
      Line3DBox[{982, 1181, 1212, 1286, 1529, 1203, 1182, 1525, 1118, 1204, 
       1183, 1526, 1119, 983, 1475, 1120, 984, 1476, 1121, 985, 1477, 1122, 
       986, 1478, 1123, 987, 1479, 1287, 1384, 988, 699, 989, 1480, 1124, 990,
        1481, 1125, 991, 1482, 1126, 992, 1483, 1127, 993, 1484, 1128, 994}], 
      Line3DBox[{995, 1184, 1213, 1288, 1530, 1205, 1185, 1289, 1531, 1206, 
       1186, 1527, 1129, 996, 1485, 1130, 997, 1486, 1131, 998, 1487, 1132, 
       999, 1488, 1133, 1000, 1489, 1290, 1385, 1001, 1291, 1386, 1002, 715, 
       1003, 1490, 1134, 1004, 1491, 1135, 1005, 1492, 1136, 1006, 1493, 1137,
        1007}], 
      Line3DBox[{1008, 1187, 1214, 1292, 1532, 1207, 1188, 1293, 1533, 1208, 
       1189, 1294, 1387, 1009, 1494, 1138, 1010, 1495, 1139, 1011, 1496, 1140,
        1012, 1497, 1141, 1013, 1498, 1295, 1388, 1014, 1296, 1389, 1015, 
       1297, 1390, 1016, 731, 1017, 1499, 1142, 1018, 1500, 1143, 1019, 1501, 
       1144, 1020}], 
      Line3DBox[{1034, 1149, 1507, 1033, 1148, 1506, 1032, 747, 1031, 1398, 
       1302, 1030, 1397, 1301, 1029, 1396, 1300, 1028, 1395, 1299, 1505, 1027,
        1147, 1504, 1026, 1146, 1503, 1025, 1145, 1502, 1024, 1394, 1298, 
       1023, 1393, 1193, 1192, 1022, 1392, 1191, 1190, 1021, 1329, 1391, 1155,
        1215, 1154, 1222}], 
      Line3DBox[{1048, 1152, 1511, 1047, 763, 1046, 1406, 1309, 1045, 1405, 
       1308, 1044, 1404, 1307, 1043, 1403, 1306, 1042, 1402, 1305, 1510, 1041,
        1151, 1509, 1040, 1150, 1508, 1039, 1401, 1304, 1038, 1400, 1303, 
       1037, 1328, 1528, 1197, 1036, 1399, 1195, 1194, 1035, 1534, 1219, 1157,
        1216, 1156, 1229}], 
      Line3DBox[{1062, 1199, 810, 1061, 1416, 1319, 1060, 1415, 1318, 1059, 
       1414, 1317, 1058, 1413, 1316, 1057, 1412, 1315, 1056, 1411, 1314, 1513,
        1055, 1153, 1512, 1054, 1410, 1313, 1053, 1409, 1312, 1052, 1408, 
       1311, 1051, 1407, 1310, 1050, 1320, 1514, 1158, 1049, 1535, 1223, 1224,
        1196, 1221, 1220, 1198}]}, {
      Line3DBox[{351, 573, 1417, 352, 587, 1428, 379, 602, 394, 1338, 617, 
       409, 1345, 632, 424, 1516, 789, 647, 439, 1518, 792, 662, 454, 1523, 
       795, 677, 1524, 469, 798, 692, 1526, 484, 801, 707, 1527, 499, 804, 
       1387, 722, 514, 806, 1393, 737, 529, 1528, 808, 752, 544, 1407, 767, 
       559}], Line3DBox[{353, 574, 1418, 354, 588, 1429, 380, 603, 1439, 395, 
       618, 410, 1346, 633, 425, 1354, 648, 440, 1363, 663, 455, 1373, 678, 
       1464, 470, 693, 1475, 485, 708, 1485, 500, 723, 1494, 515, 1394, 738, 
       530, 1400, 753, 545, 1408, 768, 560}], 
      Line3DBox[{355, 575, 1419, 356, 589, 1430, 381, 604, 1440, 396, 619, 
       1448, 411, 634, 426, 1355, 649, 441, 1364, 664, 456, 1374, 679, 1465, 
       471, 694, 1476, 486, 709, 1486, 501, 724, 1495, 516, 739, 1502, 531, 
       1401, 754, 546, 1409, 769, 561}], 
      Line3DBox[{357, 576, 1420, 358, 590, 1431, 382, 605, 1441, 397, 620, 
       1449, 412, 635, 1455, 427, 650, 442, 1365, 665, 457, 1375, 680, 1466, 
       472, 695, 1477, 487, 710, 1487, 502, 725, 1496, 517, 740, 1503, 532, 
       755, 1508, 547, 1410, 770, 562}], 
      Line3DBox[{359, 577, 1421, 360, 591, 1432, 383, 606, 1442, 398, 621, 
       1450, 413, 636, 1456, 428, 651, 1460, 443, 666, 458, 1376, 681, 1467, 
       473, 696, 1478, 488, 711, 1488, 503, 726, 1497, 518, 741, 1504, 533, 
       756, 1509, 548, 771, 1512, 563}], 
      Line3DBox[{361, 578, 1422, 363, 592, 1433, 384, 607, 1443, 399, 622, 
       1451, 414, 637, 1457, 429, 652, 1461, 444, 667, 1463, 459, 682, 1468, 
       474, 697, 1479, 489, 712, 1489, 504, 727, 1498, 519, 742, 1505, 534, 
       757, 1510, 549, 772, 1513, 564}], 
      Line3DBox[{365, 580, 1423, 366, 1332, 594, 386, 1335, 609, 401, 1340, 
       624, 416, 1348, 639, 431, 1357, 654, 446, 1367, 669, 461, 1378, 684, 
       1469, 476, 699, 491, 1386, 714, 506, 1389, 729, 521, 1396, 744, 536, 
       1403, 759, 551, 1412, 774, 566}], 
      Line3DBox[{367, 581, 1424, 368, 595, 1434, 387, 1336, 610, 402, 1341, 
       625, 417, 1349, 640, 432, 1358, 655, 447, 1368, 670, 462, 1379, 685, 
       1470, 477, 700, 1480, 492, 715, 507, 1390, 730, 522, 1397, 745, 537, 
       1404, 760, 552, 1413, 775, 567}], 
      Line3DBox[{369, 582, 1425, 370, 596, 1435, 388, 611, 1444, 403, 1342, 
       626, 418, 1350, 641, 433, 1359, 656, 448, 1369, 671, 463, 1380, 686, 
       1471, 478, 701, 1481, 493, 716, 1490, 508, 731, 523, 1398, 746, 538, 
       1405, 761, 553, 1414, 776, 568}], 
      Line3DBox[{371, 583, 1426, 372, 597, 1436, 389, 612, 1445, 404, 627, 
       1452, 419, 1351, 642, 434, 1360, 657, 449, 1370, 672, 464, 1381, 687, 
       1472, 479, 702, 1482, 494, 717, 1491, 509, 732, 1499, 524, 747, 539, 
       1406, 762, 554, 1415, 777, 569}], 
      Line3DBox[{373, 584, 1427, 374, 598, 1437, 390, 613, 1446, 405, 628, 
       1453, 420, 643, 1458, 435, 1361, 658, 450, 1371, 673, 465, 1382, 688, 
       1473, 480, 703, 1483, 495, 718, 1492, 510, 733, 1500, 525, 748, 1506, 
       540, 763, 555, 1416, 778, 570}], 
      Line3DBox[{375, 781, 782, 1515, 376, 599, 1438, 391, 614, 1447, 406, 
       629, 1454, 421, 644, 1459, 436, 659, 1462, 451, 1372, 674, 466, 1383, 
       689, 1474, 481, 704, 1484, 496, 719, 1493, 511, 734, 1501, 526, 749, 
       1507, 541, 764, 1511, 556, 810, 811, 812}], 
      Line3DBox[{557, 765, 809, 837, 1535, 836, 542, 750, 835, 829, 834, 1534,
        833, 527, 735, 827, 1391, 832, 831, 512, 720, 1532, 825, 802, 497, 
       705, 1530, 823, 799, 482, 690, 1529, 821, 796, 467, 1520, 675, 819, 
       793, 1519, 452, 660, 817, 1362, 790, 437, 645, 815, 1352, 787, 422, 
       630, 814, 1343, 785, 407, 615, 813, 783, 392, 600, 1536, 840, 839, 842,
        841, 377, 585, 1538, 850, 847, 849, 848, 349, 571, 845, 844, 852, 851,
        780}], Line3DBox[{558, 766, 779, 1514, 543, 751, 830, 1399, 807, 528, 
       736, 828, 1392, 805, 513, 721, 1533, 826, 803, 498, 706, 1531, 824, 
       800, 483, 1525, 691, 822, 797, 468, 1522, 676, 820, 794, 1521, 453, 
       661, 818, 791, 1517, 438, 646, 816, 1353, 788, 423, 631, 1344, 786, 
       408, 616, 1337, 784, 393, 601, 1333, 838, 378, 586, 846, 350, 1537, 
       572, 843, 853}], 
      Line3DBox[{565, 773, 1411, 550, 758, 1402, 535, 743, 1395, 520, 728, 
       1388, 505, 713, 1385, 490, 698, 1384, 475, 683, 1377, 460, 668, 1366, 
       445, 653, 1356, 430, 638, 1347, 415, 623, 1339, 400, 608, 1334, 385, 
       593, 1331, 364, 579, 1330, 362}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0fHc8V+//vrSplNK0txRZDfF6Knsle6SibCkRkpKM9rSLbBHJ3nHbe28Z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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 CellTags->"NDSolve::ndnum",
 CellLabel->"Out[7]=",
 CellID->692048683]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["sol", "MR"],
 "."
}], "ExampleText",
 CellID->985304200],

Cell[BoxData[
 RowBox[{"Clear", "[", "sol", "]"}]], "Input",
 CellTags->"NDSolve::ndnum",
 CellLabel->"In[8]:=",
 CellID->27859]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ndnum - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 58.6879558}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ndnum", "synonyms" -> {}, "title" -> 
    "NDSolve::ndnum", "type" -> "Message", "uri" -> "ref/message/ndnum"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2406, 90, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->144357420]},
 "NDSolve::ndnum"->{
  Cell[3137, 119, 470, 16, 70, "Input",
   CellTags->"NDSolve::ndnum",
   CellID->22523],
  Cell[3610, 137, 245, 6, 70, "Message",
   CellTags->"NDSolve::ndnum",
   CellID->333041250],
  Cell[3858, 145, 537, 18, 70, "Output",
   CellTags->"NDSolve::ndnum",
   CellID->315756931],
  Cell[4572, 174, 649, 22, 70, "Input",
   CellTags->"NDSolve::ndnum",
   CellID->360],
  Cell[5224, 198, 407, 15, 70, "Output",
   CellTags->"NDSolve::ndnum",
   CellID->378247636],
  Cell[5774, 222, 360, 12, 70, "Input",
   CellTags->"NDSolve::ndnum",
   CellID->26845],
  Cell[6137, 236, 2085, 42, 70, "Output",
   CellTags->"NDSolve::ndnum",
   CellID->499254238],
  Cell[8347, 288, 128, 4, 70, "Input",
   CellTags->"NDSolve::ndnum",
   CellID->32117],
  Cell[8648, 302, 1057, 34, 70, "Input",
   CellTags->"NDSolve::ndnum",
   CellID->12794],
  Cell[9708, 338, 244, 6, 70, "Message",
   CellTags->"NDSolve::ndnum",
   CellID->11256435],
  Cell[9955, 346, 1204, 41, 70, "Output",
   CellTags->"NDSolve::ndnum",
   CellID->36450278],
  Cell[11312, 397, 1116, 35, 70, "Input",
   CellTags->"NDSolve::ndnum",
   CellID->3088],
  Cell[12431, 434, 502, 18, 70, "Output",
   CellTags->"NDSolve::ndnum",
   CellID->24154533],
  Cell[13076, 461, 513, 16, 70, "Input",
   CellTags->"NDSolve::ndnum",
   CellID->10078],
  Cell[13592, 479, 90081, 1464, 70, "Output",
   CellTags->"NDSolve::ndnum",
   CellID->692048683],
  Cell[103798, 1953, 128, 4, 70, "Input",
   CellTags->"NDSolve::ndnum",
   CellID->27859]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 104887, 1985},
 {"NDSolve::ndnum", 105027, 1989}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->636],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 200, 5, 70, "Message",
 CellID->495655313],
Cell[1459, 56, 128, 4, 70, "Notes",
 CellID->5749],
Cell[1590, 62, 359, 10, 70, "Notes",
 CellID->12911],
Cell[1952, 74, 263, 5, 70, "Notes",
 CellID->23391],
Cell[2218, 81, 151, 4, 70, "Notes",
 CellID->16362]
}, Closed]],
Cell[CellGroupData[{
Cell[2406, 90, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->144357420],
Cell[CellGroupData[{
Cell[2791, 104, 148, 5, 70, "ExampleSection",
 CellID->308034389],
Cell[2942, 111, 170, 4, 70, "ExampleText",
 CellID->486189692],
Cell[CellGroupData[{
Cell[3137, 119, 470, 16, 70, "Input",
 CellTags->"NDSolve::ndnum",
 CellID->22523],
Cell[3610, 137, 245, 6, 70, "Message",
 CellTags->"NDSolve::ndnum",
 CellID->333041250],
Cell[3858, 145, 537, 18, 70, "Output",
 CellTags->"NDSolve::ndnum",
 CellID->315756931]
}, Open  ]],
Cell[4410, 166, 137, 4, 70, "ExampleText",
 CellID->227776287],
Cell[CellGroupData[{
Cell[4572, 174, 649, 22, 70, "Input",
 CellTags->"NDSolve::ndnum",
 CellID->360],
Cell[5224, 198, 407, 15, 70, "Output",
 CellTags->"NDSolve::ndnum",
 CellID->378247636]
}, Open  ]],
Cell[5646, 216, 103, 2, 70, "ExampleText",
 CellID->206280580],
Cell[CellGroupData[{
Cell[5774, 222, 360, 12, 70, "Input",
 CellTags->"NDSolve::ndnum",
 CellID->26845],
Cell[6137, 236, 2085, 42, 70, "Output",
 CellTags->"NDSolve::ndnum",
 CellID->499254238]
}, Open  ]],
Cell[8237, 281, 107, 5, 70, "ExampleText",
 CellID->280558918],
Cell[8347, 288, 128, 4, 70, "Input",
 CellTags->"NDSolve::ndnum",
 CellID->32117],
Cell[8478, 294, 145, 4, 70, "ExampleText",
 CellID->229518949],
Cell[CellGroupData[{
Cell[8648, 302, 1057, 34, 70, "Input",
 CellTags->"NDSolve::ndnum",
 CellID->12794],
Cell[9708, 338, 244, 6, 70, "Message",
 CellTags->"NDSolve::ndnum",
 CellID->11256435],
Cell[9955, 346, 1204, 41, 70, "Output",
 CellTags->"NDSolve::ndnum",
 CellID->36450278]
}, Open  ]],
Cell[11174, 390, 113, 3, 70, "ExampleText",
 CellID->8287936],
Cell[CellGroupData[{
Cell[11312, 397, 1116, 35, 70, "Input",
 CellTags->"NDSolve::ndnum",
 CellID->3088],
Cell[12431, 434, 502, 18, 70, "Output",
 CellTags->"NDSolve::ndnum",
 CellID->24154533]
}, Open  ]],
Cell[12948, 455, 103, 2, 70, "ExampleText",
 CellID->452802500],
Cell[CellGroupData[{
Cell[13076, 461, 513, 16, 70, "Input",
 CellTags->"NDSolve::ndnum",
 CellID->10078],
Cell[13592, 479, 90081, 1464, 70, "Output",
 CellTags->"NDSolve::ndnum",
 CellID->692048683]
}, Open  ]],
Cell[103688, 1946, 107, 5, 70, "ExampleText",
 CellID->985304200],
Cell[103798, 1953, 128, 4, 70, "Input",
 CellTags->"NDSolve::ndnum",
 CellID->27859]
}, Open  ]]
}, Open  ]],
Cell[103953, 1961, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

