(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7945,        295]
NotebookOptionsPosition[      5128,        201]
NotebookOutlinePosition[      6776,        252]
CellTagsIndexPosition[      6660,        246]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ndsss", "ObjectName",
 CellID->21002],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsss\"\>"}], ":", 
  " ", "\<\"Value of StartingStepSize -> `1` is not a positive real number or \
Automatic.\"\>"}]], "Message", "MSG",
 CellID->51258321],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["StartingStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartingStepSize"]], "InlineFormula"],
 " option does not have the expected form."
}], "Notes",
 CellID->9325]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->22898527],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->441623506],

Cell[TextData[{
 "The value of the ",
 Cell[BoxData[
  ButtonBox["StartingStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartingStepSize"]], "InlineFormula"],
 " option cannot be a symbol."
}], "ExampleText",
 CellID->621981624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"StartingStepSize", "->", "x"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndsss",
 CellLabel->"In[1]:=",
 CellID->16559],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsss\"\>"}], ":", 
  " ", "\<\"Value of StartingStepSize -> \\!\\(x\\) is not a positive real \
number or Automatic.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ndsss",
 CellID->72450963],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"StartingStepSize", "\[Rule]", "x"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ndsss",
 CellLabel->"Out[1]=",
 CellID->118975792]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData[
  ButtonBox["StartingStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartingStepSize"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->58082159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"StartingStepSize", "->", "0.1"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndsss",
 CellLabel->"In[2]:=",
 CellID->27933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ndsss",
 CellLabel->"Out[2]=",
 CellID->39506233]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ndsss - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 6.2819002}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ndsss", "synonyms" -> {}, "title" -> 
    "NDSolve::ndsss", "type" -> "Message", "uri" -> "ref/message/ndsss"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1769, 69, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->22898527]},
 "NDSolve::ndsss"->{
  Cell[2571, 102, 492, 16, 70, "Input",
   CellTags->"NDSolve::ndsss",
   CellID->16559],
  Cell[3066, 120, 248, 6, 70, "Message",
   CellTags->"NDSolve::ndsss",
   CellID->72450963],
  Cell[3317, 128, 564, 18, 70, "Output",
   CellTags->"NDSolve::ndsss",
   CellID->118975792],
  Cell[4159, 161, 494, 16, 70, "Input",
   CellTags->"NDSolve::ndsss",
   CellID->27933],
  Cell[4656, 179, 406, 15, 70, "Output",
   CellTags->"NDSolve::ndsss",
   CellID->39506233]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6034, 223},
 {"NDSolve::ndsss", 6173, 227}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->21002],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 212, 5, 70, "Message",
 CellID->51258321],
Cell[1473, 56, 259, 8, 70, "Notes",
 CellID->9325]
}, Closed]],
Cell[CellGroupData[{
Cell[1769, 69, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->22898527],
Cell[CellGroupData[{
Cell[2153, 83, 148, 5, 70, "ExampleSection",
 CellID->441623506],
Cell[2304, 90, 242, 8, 70, "ExampleText",
 CellID->621981624],
Cell[CellGroupData[{
Cell[2571, 102, 492, 16, 70, "Input",
 CellTags->"NDSolve::ndsss",
 CellID->16559],
Cell[3066, 120, 248, 6, 70, "Message",
 CellTags->"NDSolve::ndsss",
 CellID->72450963],
Cell[3317, 128, 564, 18, 70, "Output",
 CellTags->"NDSolve::ndsss",
 CellID->118975792]
}, Open  ]],
Cell[3896, 149, 238, 8, 70, "ExampleText",
 CellID->58082159],
Cell[CellGroupData[{
Cell[4159, 161, 494, 16, 70, "Input",
 CellTags->"NDSolve::ndsss",
 CellID->27933],
Cell[4656, 179, 406, 15, 70, "Output",
 CellTags->"NDSolve::ndsss",
 CellID->39506233]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5101, 199, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

