(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6174,        228]
NotebookOptionsPosition[      3823,        150]
NotebookOutlinePosition[      5277,        195]
CellTagsIndexPosition[      5162,        189]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ndsz", "ObjectName",
 CellID->16934],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsz\"\>"}], ":", 
  " ", "\<\"At `1` == `2`, step size is effectively zero; singularity or \
stiff system suspected.\"\>"}]], "Message", "MSG",
 CellID->357712732],

Cell[TextData[{
 "Generated when the adaptive algorithm used by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " requires a step size that is too small for numerically reliable  \
calculations."
}], "Notes",
 CellID->4509]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->208064920],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->59863109],

Cell["\<\
An error occurs in this example because the solution is singular.\
\>", "ExampleText",
 CellID->263809780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "-", 
         RowBox[{"f", "[", "x", "]"}]}], ")"}], 
       RowBox[{
        RowBox[{"f", "'"}], "[", "x", "]"}]}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndsz",
 CellLabel->"In[1]:=",
 CellID->6196],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsz\"\>"}], ":", 
  " ", "\<\"At \\!\\(x\\) == \\!\\(0.38629402687577696`\\), step size is \
effectively zero; singularity or stiff system suspected.\"\>"}]], "Message", \
"MSG",
 CellTags->"NDSolve::ndsz",
 CellID->535140516],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "0.38629402687577696`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ndsz",
 CellLabel->"Out[1]=",
 CellID->86380283]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ndsz - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 6.6100336}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ndsz", "synonyms" -> {}, "title" -> 
    "NDSolve::ndsz", "type" -> "Message", "uri" -> "ref/message/ndsz"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1813, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->208064920]},
 "NDSolve::ndsz"->{
  Cell[2489, 98, 556, 19, 70, "Input",
   CellTags->"NDSolve::ndsz",
   CellID->6196],
  Cell[3048, 119, 283, 7, 70, "Message",
   CellTags->"NDSolve::ndsz",
   CellID->535140516],
  Cell[3334, 128, 423, 15, 70, "Output",
   CellTags->"NDSolve::ndsz",
   CellID->86380283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4725, 172},
 {"NDSolve::ndsz", 4864, 176}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->16934],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 220, 5, 70, "Message",
 CellID->357712732],
Cell[1480, 56, 296, 9, 70, "Notes",
 CellID->4509]
}, Closed]],
Cell[CellGroupData[{
Cell[1813, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->208064920],
Cell[CellGroupData[{
Cell[2198, 84, 147, 5, 70, "ExampleSection",
 CellID->59863109],
Cell[2348, 91, 116, 3, 70, "ExampleText",
 CellID->263809780],
Cell[CellGroupData[{
Cell[2489, 98, 556, 19, 70, "Input",
 CellTags->"NDSolve::ndsz",
 CellID->6196],
Cell[3048, 119, 283, 7, 70, "Message",
 CellTags->"NDSolve::ndsz",
 CellID->535140516],
Cell[3334, 128, 423, 15, 70, "Output",
 CellTags->"NDSolve::ndsz",
 CellID->86380283]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3796, 148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

