(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8122,        293]
NotebookOptionsPosition[      5303,        199]
NotebookOutlinePosition[      6951,        250]
CellTagsIndexPosition[      6835,        244]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ndtol", "ObjectName",
 CellID->28336],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndtol\"\>"}], ":", 
  " ", "\<\"Tolerances requested by the AccuracyGoal and PrecisionGoal \
options could not be achieved at `1` == `2`.\"\>"}]], "Message", "MSG",
 CellID->565962296],

Cell["\<\
This message is generated by a specific type of failure within the algorithms \
that are used for computing numerical solutions of ordinary differential \
equations.\
\>", "Notes",
 CellID->7403]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31256583],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->287228832],

Cell["\<\
A warning message is generated in this example because the requested \
precision and accuracy are too high to be achieved using the default options.\
\
\>", "ExampleText",
 CellID->185315381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"x", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], "}"}], ",",
    "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"AccuracyGoal", "\[Rule]", "30"}], ",", " ", 
   RowBox[{"PrecisionGoal", "\[Rule]", "30"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndtol",
 CellLabel->"In[1]:=",
 CellID->29424],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndtol\"\>"}], ":", 
  " ", "\<\"Tolerances requested by the AccuracyGoal and PrecisionGoal \
options could not be achieved at \\!\\(t\\) == \\!\\(0.`\\).\"\>"}]], \
"Message", "MSG",
 CellTags->"NDSolve::ndtol",
 CellID->343947862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "0.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ndtol",
 CellLabel->"Out[1]=",
 CellID->208581459]
}, Open  ]],

Cell[TextData[{
 "The accuracy and precision goals specified in this example can be achieved  \
by including a sufficiently high value for the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->197011702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"x", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], "}"}], ",",
    "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"AccuracyGoal", "\[Rule]", "30"}], ",", " ", 
   RowBox[{"PrecisionGoal", "\[Rule]", "30"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndtol",
 CellLabel->"In[2]:=",
 CellID->12606],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.`50."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ndtol",
 CellLabel->"Out[2]=",
 CellID->19920711]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ndtol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 6.7506622}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ndtol", "synonyms" -> {}, "title" -> 
    "NDSolve::ndtol", "type" -> "Message", "uri" -> "ref/message/ndtol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1743, 66, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->31256583]},
 "NDSolve::ndtol"->{
  Cell[2504, 96, 598, 18, 70, "Input",
   CellTags->"NDSolve::ndtol",
   CellID->29424],
  Cell[3105, 116, 287, 7, 70, "Message",
   CellTags->"NDSolve::ndtol",
   CellID->343947862],
  Cell[3395, 125, 407, 15, 70, "Output",
   CellTags->"NDSolve::ndtol",
   CellID->208581459],
  Cell[4173, 156, 654, 19, 70, "Input",
   CellTags->"NDSolve::ndtol",
   CellID->12606],
  Cell[4830, 177, 407, 15, 70, "Output",
   CellTags->"NDSolve::ndtol",
   CellID->19920711]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6209, 221},
 {"NDSolve::ndtol", 6348, 225}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->28336],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 240, 5, 70, "Message",
 CellID->565962296],
Cell[1501, 56, 205, 5, 70, "Notes",
 CellID->7403]
}, Closed]],
Cell[CellGroupData[{
Cell[1743, 66, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31256583],
Cell[CellGroupData[{
Cell[2127, 80, 148, 5, 70, "ExampleSection",
 CellID->287228832],
Cell[2278, 87, 201, 5, 70, "ExampleText",
 CellID->185315381],
Cell[CellGroupData[{
Cell[2504, 96, 598, 18, 70, "Input",
 CellTags->"NDSolve::ndtol",
 CellID->29424],
Cell[3105, 116, 287, 7, 70, "Message",
 CellTags->"NDSolve::ndtol",
 CellID->343947862],
Cell[3395, 125, 407, 15, 70, "Output",
 CellTags->"NDSolve::ndtol",
 CellID->208581459]
}, Open  ]],
Cell[3817, 143, 331, 9, 70, "ExampleText",
 CellID->197011702],
Cell[CellGroupData[{
Cell[4173, 156, 654, 19, 70, "Input",
 CellTags->"NDSolve::ndtol",
 CellID->12606],
Cell[4830, 177, 407, 15, 70, "Output",
 CellTags->"NDSolve::ndtol",
 CellID->19920711]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5276, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

