(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9957,        351]
NotebookOptionsPosition[      7114,        257]
NotebookOutlinePosition[      8777,        308]
CellTagsIndexPosition[      8660,        302]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::nerres", "ObjectName",
 CellID->21291],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"nerres\"\>"}], ":", 
  " ", "\<\"The maximum number of spatial points (`1`) for independent \
variable `2` allowed by MaxPoints -> `3` or MinStepSize -> `4` is too few to \
compute a spatial error estimate.\"\>"}]], "Message", "MSG",
 CellID->221154357],

Cell["\<\
Generated by numerical failure in solving a partial differential equation.\
\>", "Notes",
 CellID->4980]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19145196],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->28293477],

Cell[TextData[{
 "A warning is generated in this example because the specified value of the   \
",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option may not be sufficient to compute a solution within the default   \
tolerances."
}], "ExampleText",
 CellID->105351572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "Pi", " ", "x"}], "]"}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"MaxSteps", "->", 
    RowBox[{"{", 
     RowBox[{"10", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::nerres",
 CellLabel->"In[1]:=",
 CellID->10520],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"nerres\"\>"}], ":", 
  " ", "\<\"The maximum number of spatial points (\\!\\(10\\)) for \
independent variable \\!\\(x\\) allowed by MaxPoints -> \\!\\(10\\) or \
MinStepSize -> \\!\\(Automatic\\) is too few to compute a spatial error \
estimate.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::nerres",
 CellID->321518658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::nerres",
 CellLabel->"Out[1]=",
 CellID->235305899]
}, Open  ]],

Cell[TextData[{
 "A solution is computed without difficulty if a larger value is used for   \
the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->632838119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "Pi", " ", "x"}], "]"}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"MaxSteps", "->", 
    RowBox[{"{", 
     RowBox[{"100", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::nerres",
 CellLabel->"In[2]:=",
 CellID->14290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::nerres",
 CellLabel->"Out[2]=",
 CellID->218281695]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::nerres - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 6.8912908}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::nerres", "synonyms" -> {}, "title" -> 
    "NDSolve::nerres", "type" -> "Message", "uri" -> "ref/message/nerres"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1722, 65, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19145196]},
 "NDSolve::nerres"->{
  Cell[2627, 100, 1357, 42, 70, "Input",
   CellTags->"NDSolve::nerres",
   CellID->10520],
  Cell[3987, 144, 379, 8, 70, "Message",
   CellTags->"NDSolve::nerres",
   CellID->321518658],
  Cell[4369, 154, 504, 18, 70, "Output",
   CellTags->"NDSolve::nerres",
   CellID->235305899],
  Cell[5183, 188, 1358, 42, 70, "Input",
   CellTags->"NDSolve::nerres",
   CellID->14290],
  Cell[6544, 232, 504, 18, 70, "Output",
   CellTags->"NDSolve::nerres",
   CellID->218281695]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8024, 279},
 {"NDSolve::nerres", 8164, 283}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->21291],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 309, 6, 70, "Message",
 CellID->221154357],
Cell[1571, 57, 114, 3, 70, "Notes",
 CellID->4980]
}, Closed]],
Cell[CellGroupData[{
Cell[1722, 65, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19145196],
Cell[CellGroupData[{
Cell[2106, 79, 147, 5, 70, "ExampleSection",
 CellID->28293477],
Cell[2256, 86, 346, 10, 70, "ExampleText",
 CellID->105351572],
Cell[CellGroupData[{
Cell[2627, 100, 1357, 42, 70, "Input",
 CellTags->"NDSolve::nerres",
 CellID->10520],
Cell[3987, 144, 379, 8, 70, "Message",
 CellTags->"NDSolve::nerres",
 CellID->321518658],
Cell[4369, 154, 504, 18, 70, "Output",
 CellTags->"NDSolve::nerres",
 CellID->235305899]
}, Open  ]],
Cell[4888, 175, 270, 9, 70, "ExampleText",
 CellID->632838119],
Cell[CellGroupData[{
Cell[5183, 188, 1358, 42, 70, "Input",
 CellTags->"NDSolve::nerres",
 CellID->14290],
Cell[6544, 232, 504, 18, 70, "Output",
 CellTags->"NDSolve::nerres",
 CellID->218281695]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7087, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

