(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7165,        257]
NotebookOptionsPosition[      4615,        173]
NotebookOutlinePosition[      6175,        221]
CellTagsIndexPosition[      6059,        215]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::nfnan", "ObjectName",
 CellID->21032],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"nfnan\"\>"}], ":", 
  " ", "\<\"The value of the option NormFunction -> `1` applied to the \
current scaled error vector was `2`, which is not a number.\"\>"}]], "Message",\
 "MSG",
 CellID->60925936],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["NormFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NormFunction"]], "InlineFormula"],
 " option does not have the expected form."
}], "Notes",
 CellID->5180]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531873746],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->9558350],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " is not a valid value for the ",
 Cell[BoxData[
  ButtonBox["NormFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NormFunction"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->667074441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], " ", 
        RowBox[{"x", "[", "t", "]"}]}]}], " ", "==", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"{", "0", "}"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"{", "1", "}"}]}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"NormFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellTags->"NDSolve::nfnan",
 CellLabel->"In[1]:=",
 CellID->30399],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"nfnan\"\>"}], ":", 
  " ", "\<\"The value of the option NormFunction -> \\!\\(None\\) applied to \
the current scaled error vector was \\!\\(None[\\(\\({9.490626562425165`*^7, \
0.`}\\)\\)]\\), which is not a number.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::nfnan",
 CellID->379103174],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"nderr\"\>"}], ":", 
  " ", "\<\"Error test failure at \\!\\(t\\) == \\!\\(0.`\\); unable to \
continue.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::nfnan",
 CellID->98177945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "0.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::nfnan",
 CellLabel->"Out[1]=",
 CellID->302836793]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::nfnan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 7.0319194}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::nfnan", "synonyms" -> {}, "title" -> 
    "NDSolve::nfnan", "type" -> "Message", "uri" -> "ref/message/nfnan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1805, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->531873746]},
 "NDSolve::nfnan"->{
  Cell[2748, 108, 803, 24, 70, "Input",
   CellTags->"NDSolve::nfnan",
   CellID->30399],
  Cell[3554, 134, 348, 7, 70, "Message",
   CellTags->"NDSolve::nfnan",
   CellID->379103174],
  Cell[3905, 143, 234, 6, 70, "Message",
   CellTags->"NDSolve::nfnan",
   CellID->98177945],
  Cell[4142, 151, 407, 15, 70, "Output",
   CellTags->"NDSolve::nfnan",
   CellID->302836793]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5521, 195},
 {"NDSolve::nfnan", 5661, 199}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->21032],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 256, 6, 70, "Message",
 CellID->60925936],
Cell[1517, 57, 251, 8, 70, "Notes",
 CellID->5180]
}, Closed]],
Cell[CellGroupData[{
Cell[1805, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531873746],
Cell[CellGroupData[{
Cell[2190, 84, 146, 5, 70, "ExampleSection",
 CellID->9558350],
Cell[2339, 91, 384, 13, 70, "ExampleText",
 CellID->667074441],
Cell[CellGroupData[{
Cell[2748, 108, 803, 24, 70, "Input",
 CellTags->"NDSolve::nfnan",
 CellID->30399],
Cell[3554, 134, 348, 7, 70, "Message",
 CellTags->"NDSolve::nfnan",
 CellID->379103174],
Cell[3905, 143, 234, 6, 70, "Message",
 CellTags->"NDSolve::nfnan",
 CellID->98177945],
Cell[4142, 151, 407, 15, 70, "Output",
 CellTags->"NDSolve::nfnan",
 CellID->302836793]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4588, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

