(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8942,        329]
NotebookOptionsPosition[      6085,        233]
NotebookOutlinePosition[      7724,        284]
CellTagsIndexPosition[      7609,        278]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ntcs", "ObjectName",
 CellID->17281],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ntcs\"\>"}], ":", 
  " ", "\<\"Cannot solve constraint equations for initial \
conditions.\"\>"}]], "Message", "MSG",
 CellID->255222700],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is unable to compute the initial conditions for the solution of a   \
differential equation."
}], "Notes",
 CellID->5955],

Cell["\<\
This error can occur if the   specified initial conditions are inconsistent, \
or if the equations that give   the initial values for the solution cannot be \
solved for the initial   conditions by algebraic methods.\
\>", "Notes",
 CellID->10165]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44328717],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->384704167],

Cell["\<\
An error occurs in this example because the initial conditions are \
inconsistent.\
\>", "ExampleText",
 CellID->86209953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"g", "[", "x", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ntcs",
 CellLabel->"In[1]:=",
 CellID->17411],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ntcs\"\>"}], ":", 
  " ", "\<\"Cannot solve constraint equations for initial \
conditions.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ntcs",
 CellID->527282240],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"g", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["g", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ntcs",
 CellLabel->"Out[1]=",
 CellID->98916192]
}, Open  ]],

Cell["\<\
This shows a valid specification for a solution of this pair of differential \
equations.\
\>", "ExampleText",
 CellID->96802651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"g", "[", "x", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"g", "[", "1", "]"}], "==", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ntcs",
 CellLabel->"In[2]:=",
 CellID->11836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"1.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"g", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"1.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ntcs",
 CellLabel->"Out[2]=",
 CellID->452014030]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ntcs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 14.6727400}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ntcs", "synonyms" -> {}, "title" -> 
    "NDSolve::ntcs", "type" -> "Message", "uri" -> "ref/message/ntcs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2027, 77, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->44328717]},
 "NDSolve::ntcs"->{
  Cell[2719, 106, 688, 23, 70, "Input",
   CellTags->"NDSolve::ntcs",
   CellID->17411],
  Cell[3410, 131, 221, 6, 70, "Message",
   CellTags->"NDSolve::ntcs",
   CellID->527282240],
  Cell[3634, 139, 803, 25, 70, "Output",
   CellTags->"NDSolve::ntcs",
   CellID->98916192],
  Cell[4616, 175, 688, 23, 70, "Input",
   CellTags->"NDSolve::ntcs",
   CellID->11836],
  Cell[5307, 200, 712, 26, 70, "Output",
   CellTags->"NDSolve::ntcs",
   CellID->452014030]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6988, 255},
 {"NDSolve::ntcs", 7126, 259}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->17281],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 193, 5, 70, "Message",
 CellID->255222700],
Cell[1453, 56, 277, 9, 70, "Notes",
 CellID->5955],
Cell[1733, 67, 257, 5, 70, "Notes",
 CellID->10165]
}, Closed]],
Cell[CellGroupData[{
Cell[2027, 77, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44328717],
Cell[CellGroupData[{
Cell[2411, 91, 148, 5, 70, "ExampleSection",
 CellID->384704167],
Cell[2562, 98, 132, 4, 70, "ExampleText",
 CellID->86209953],
Cell[CellGroupData[{
Cell[2719, 106, 688, 23, 70, "Input",
 CellTags->"NDSolve::ntcs",
 CellID->17411],
Cell[3410, 131, 221, 6, 70, "Message",
 CellTags->"NDSolve::ntcs",
 CellID->527282240],
Cell[3634, 139, 803, 25, 70, "Output",
 CellTags->"NDSolve::ntcs",
 CellID->98916192]
}, Open  ]],
Cell[4452, 167, 139, 4, 70, "ExampleText",
 CellID->96802651],
Cell[CellGroupData[{
Cell[4616, 175, 688, 23, 70, "Input",
 CellTags->"NDSolve::ntcs",
 CellID->11836],
Cell[5307, 200, 712, 26, 70, "Output",
 CellTags->"NDSolve::ntcs",
 CellID->452014030]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6058, 231, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

