(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7058,        255]
NotebookOptionsPosition[      4454,        169]
NotebookOutlinePosition[      6014,        217]
CellTagsIndexPosition[      5898,        211]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::otype", "ObjectName",
 CellID->3270],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"otype\"\>"}], ":", 
  " ", "\<\"The value of the option `1` -> `2` should be ModifiedGramSchmidt \
or ClassicalGramSchmidt.\"\>"}]], "Message", "MSG",
 CellID->726563866],

Cell[TextData[{
 "Generated when the value of the ",
 StyleBox["OrthogonalizationType", "MR"],
 " option is not among the indicated forms."
}], "Notes",
 CellID->29510],

Cell["This  message applies to the BDF and IDA methods.", "Notes",
 CellID->13817]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->171213021],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->457913732],

Cell[TextData[{
 "A warning is generated in this example because ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " is not a valid value of the ",
 StyleBox["OrthogonalizationType", "MR"],
 " option."
}], "ExampleText",
 CellID->814513965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"x", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], "}"}], ",",
    "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<IDA\>\"", ",", " ", 
      RowBox[{"\"\<ImplicitSolver\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<GMRES\>\"", ",", " ", 
         RowBox[{"\"\<OrthogonalizationType\>\"", "\[Rule]", "None"}]}], 
        "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::otype",
 CellLabel->"In[1]:=",
 CellID->954],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"otype\"\>"}], ":", 
  " ", "\<\"The value of the option \\!\\(\\\"OrthogonalizationType\\\"\\) -> \
\\!\\(None\\) should be ModifiedGramSchmidt or ClassicalGramSchmidt.\"\>"}]], \
"Message", "MSG",
 CellTags->"NDSolve::otype",
 CellID->407549597],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"initf\"\>"}], ":", 
  " ", "\<\"The initialization of the method \\!\\(NDSolve`IDA\\) \
failed.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::otype",
 CellID->653308044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "0.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::otype",
 CellLabel->"Out[1]=",
 CellID->185413434]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::otype - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 22.4854400}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::otype", "synonyms" -> {}, "title" -> 
    "NDSolve::otype", "type" -> "Message", "uri" -> "ref/message/otype"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1776, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->171213021]},
 "NDSolve::otype"->{
  Cell[2642, 104, 801, 24, 70, "Input",
   CellTags->"NDSolve::otype",
   CellID->954],
  Cell[3446, 130, 302, 7, 70, "Message",
   CellTags->"NDSolve::otype",
   CellID->407549597],
  Cell[3751, 139, 227, 6, 70, "Message",
   CellTags->"NDSolve::otype",
   CellID->653308044],
  Cell[3981, 147, 407, 15, 70, "Output",
   CellTags->"NDSolve::otype",
   CellID->185413434]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5361, 191},
 {"NDSolve::otype", 5501, 195}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->3270],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 226, 5, 70, "Message",
 CellID->726563866],
Cell[1486, 56, 168, 5, 70, "Notes",
 CellID->29510],
Cell[1657, 63, 82, 1, 70, "Notes",
 CellID->13817]
}, Closed]],
Cell[CellGroupData[{
Cell[1776, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->171213021],
Cell[CellGroupData[{
Cell[2161, 83, 148, 5, 70, "ExampleSection",
 CellID->457913732],
Cell[2312, 90, 305, 10, 70, "ExampleText",
 CellID->814513965],
Cell[CellGroupData[{
Cell[2642, 104, 801, 24, 70, "Input",
 CellTags->"NDSolve::otype",
 CellID->954],
Cell[3446, 130, 302, 7, 70, "Message",
 CellTags->"NDSolve::otype",
 CellID->407549597],
Cell[3751, 139, 227, 6, 70, "Message",
 CellTags->"NDSolve::otype",
 CellID->653308044],
Cell[3981, 147, 407, 15, 70, "Output",
 CellTags->"NDSolve::otype",
 CellID->185413434]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4427, 167, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

