(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7383,        256]
NotebookOptionsPosition[      5010,        178]
NotebookOutlinePosition[      6481,        223]
CellTagsIndexPosition[      6364,        217]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::stpmax", "ObjectName",
 CellID->31758],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"stpmax\"\>"}], ":", 
  " ", "\<\"The starting number of points determined by StartingStepSize -> \
`3` and StartingPoints -> `4` is `1`, which is greater than the maximum \
number of `2` grid points. `2` will be used instead.\"\>"}]], "Message", \
"MSG",
 CellID->36911509],

Cell["\<\
Generated when the indicated options impose incompatible restrictions on the \
number of steps.\
\>", "Notes",
 CellID->23252]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158785070],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->327203645],

Cell["\<\
A warning message is generated in this example because there is no choice for \
the number of steps that will satisfy all of the indicated options.\
\>", "ExampleText",
 CellID->831473730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"MaxPoints", "\[Rule]", "1000"}], ",", "  ", 
         RowBox[{"StartingPoints", "\[Rule]", "1200"}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::stpmax",
 CellLabel->"In[1]:=",
 CellID->375],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"stpmax\"\>"}], ":", 
  " ", "\<\"The starting number of points determined by StartingStepSize -> \
\\!\\(Automatic\\) and StartingPoints -> \\!\\(1200\\) is \\!\\(1200\\), \
which is greater than the maximum number of \\!\\(1000\\) grid points. \
\\!\\(1000\\) will be used instead.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::stpmax",
 CellID->8551666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::stpmax",
 CellLabel->"Out[1]=",
 CellID->80116300]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::stpmax - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 30.3450162}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::stpmax", "synonyms" -> {}, "title" -> 
    "NDSolve::stpmax", "type" -> "Message", "uri" -> "ref/message/stpmax"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1764, 67, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->158785070]},
 "NDSolve::stpmax"->{
  Cell[2523, 96, 1472, 44, 70, "Input",
   CellTags->"NDSolve::stpmax",
   CellID->375],
  Cell[3998, 142, 413, 8, 70, "Message",
   CellTags->"NDSolve::stpmax",
   CellID->8551666],
  Cell[4414, 152, 530, 19, 70, "Output",
   CellTags->"NDSolve::stpmax",
   CellID->80116300]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5921, 200},
 {"NDSolve::stpmax", 6062, 204}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->31758],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 329, 7, 70, "Message",
 CellID->36911509],
Cell[1591, 58, 136, 4, 70, "Notes",
 CellID->23252]
}, Closed]],
Cell[CellGroupData[{
Cell[1764, 67, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158785070],
Cell[CellGroupData[{
Cell[2149, 81, 148, 5, 70, "ExampleSection",
 CellID->327203645],
Cell[2300, 88, 198, 4, 70, "ExampleText",
 CellID->831473730],
Cell[CellGroupData[{
Cell[2523, 96, 1472, 44, 70, "Input",
 CellTags->"NDSolve::stpmax",
 CellID->375],
Cell[3998, 142, 413, 8, 70, "Message",
 CellTags->"NDSolve::stpmax",
 CellID->8551666],
Cell[4414, 152, 530, 19, 70, "Output",
 CellTags->"NDSolve::stpmax",
 CellID->80116300]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4983, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

