(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7373,        255]
NotebookOptionsPosition[      4991,        177]
NotebookOutlinePosition[      6467,        222]
CellTagsIndexPosition[      6350,        216]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::stpmin", "ObjectName",
 CellID->15023],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"stpmin\"\>"}], ":", 
  " ", "\<\"The starting number of points determined by StartingStepSize -> \
`3` and StartingPoints -> `4` is `1`, which is less than the minimum number \
of `2` grid points. `2` will be used instead.\"\>"}]], "Message", "MSG",
 CellID->162490484],

Cell["\<\
Generated when the indicated options impose incompatible restrictions on the \
number of steps.\
\>", "Notes",
 CellID->4391]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->705442445],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->135103804],

Cell["\<\
A warning message is generated in this example because there is no choice for \
the number of steps that will satisfy all of the indicated options.\
\>", "ExampleText",
 CellID->76874964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"MinPoints", "\[Rule]", "50"}], ",", "  ", 
         RowBox[{"StartingPoints", "\[Rule]", "10"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NDSolve::stpmin",
 CellLabel->"In[1]:=",
 CellID->10450],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"stpmin\"\>"}], ":", 
  " ", "\<\"The starting number of points determined by StartingStepSize -> \
\\!\\(Automatic\\) and StartingPoints -> \\!\\(10\\) is \\!\\(10\\), which is \
less than the minimum number of \\!\\(50\\) grid points. \\!\\(50\\) will be \
used instead.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::stpmin",
 CellID->445258373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::stpmin",
 CellLabel->"Out[1]=",
 CellID->691173298]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::stpmin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 38.2670940}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::stpmin", "synonyms" -> {}, "title" -> 
    "NDSolve::stpmin", "type" -> "Message", "uri" -> "ref/message/stpmin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1759, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->705442445]},
 "NDSolve::stpmin"->{
  Cell[2517, 95, 1467, 44, 70, "Input",
   CellTags->"NDSolve::stpmin",
   CellID->10450],
  Cell[3987, 141, 404, 8, 70, "Message",
   CellTags->"NDSolve::stpmin",
   CellID->445258373],
  Cell[4394, 151, 531, 19, 70, "Output",
   CellTags->"NDSolve::stpmin",
   CellID->691173298]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5902, 199},
 {"NDSolve::stpmin", 6043, 203}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->15023],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 325, 6, 70, "Message",
 CellID->162490484],
Cell[1587, 57, 135, 4, 70, "Notes",
 CellID->4391]
}, Closed]],
Cell[CellGroupData[{
Cell[1759, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->705442445],
Cell[CellGroupData[{
Cell[2144, 80, 148, 5, 70, "ExampleSection",
 CellID->135103804],
Cell[2295, 87, 197, 4, 70, "ExampleText",
 CellID->76874964],
Cell[CellGroupData[{
Cell[2517, 95, 1467, 44, 70, "Input",
 CellTags->"NDSolve::stpmin",
 CellID->10450],
Cell[3987, 141, 404, 8, 70, "Message",
 CellTags->"NDSolve::stpmin",
 CellID->445258373],
Cell[4394, 151, 531, 19, 70, "Output",
 CellTags->"NDSolve::stpmin",
 CellID->691173298]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4964, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

