(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7806,        276]
NotebookOptionsPosition[      5386,        196]
NotebookOutlinePosition[      6848,        241]
CellTagsIndexPosition[      6733,        235]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::stps", "ObjectName",
 CellID->7051],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"stps\"\>"}], ":", 
  " ", "\<\"Only one of StartingPoints and StartingStepSize should be \
specified at a time.  StartingPoints -> `1` will be used and StartingStepSize \
-> `2` will be disregarded.\"\>"}]], "Message", "MSG",
 CellID->285377482],

Cell[TextData[{
 "Generated when the input includes values for both the  ",
 Cell[BoxData[
  ButtonBox["StartingStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartingStepSize"]], "InlineFormula"],
 " and ",
 StyleBox["StartingPoints", "MR"],
 " options."
}], "Notes",
 CellID->30281],

Cell["\<\
Since these options specify the same  quantity, it is only necessary to \
provide a value for one of these options.\
\>", "Notes",
 CellID->3331]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->293360950],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->661002932],

Cell[TextData[{
 "A warning message is generated by this example because the input includes  \
values for both the ",
 Cell[BoxData[
  ButtonBox["StartingStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartingStepSize"]], "InlineFormula"],
 " and ",
 StyleBox["StartingPoints", "MR"],
 " options."
}], "ExampleText",
 CellID->10443039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", 
         RowBox[{"StartingStepSize", "\[Rule]", "1"}], ",", "  ", 
         RowBox[{"StartingPoints", "\[Rule]", "1200"}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::stps",
 CellLabel->"In[1]:=",
 CellID->71850243],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"stps\"\>"}], ":", 
  " ", "\<\"Only one of StartingPoints and StartingStepSize should be \
specified at a time.  StartingPoints -> \\!\\(1200\\) will be used and \
StartingStepSize -> \\!\\(1.`\\) will be disregarded.\"\>"}]], "Message", \
"MSG",
 CellTags->"NDSolve::stps",
 CellID->180855155],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::stps",
 CellLabel->"Out[1]=",
 CellID->487066445]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::stps - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 38.4545988}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::stps", "synonyms" -> {}, "title" -> 
    "NDSolve::stps", "type" -> "Message", "uri" -> "ref/message/stps"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2052, 78, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->293360950]},
 "NDSolve::stps"->{
  Cell[2961, 114, 1474, 44, 70, "Input",
   CellTags->"NDSolve::stps",
   CellID->71850243],
  Cell[4438, 160, 350, 8, 70, "Message",
   CellTags->"NDSolve::stps",
   CellID->180855155],
  Cell[4791, 170, 529, 19, 70, "Output",
   CellTags->"NDSolve::stps",
   CellID->487066445]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6289, 218},
 {"NDSolve::stps", 6428, 222}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->7051],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 301, 6, 70, "Message",
 CellID->285377482],
Cell[1560, 57, 297, 10, 70, "Notes",
 CellID->30281],
Cell[1860, 69, 155, 4, 70, "Notes",
 CellID->3331]
}, Closed]],
Cell[CellGroupData[{
Cell[2052, 78, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->293360950],
Cell[CellGroupData[{
Cell[2437, 92, 148, 5, 70, "ExampleSection",
 CellID->661002932],
Cell[2588, 99, 348, 11, 70, "ExampleText",
 CellID->10443039],
Cell[CellGroupData[{
Cell[2961, 114, 1474, 44, 70, "Input",
 CellTags->"NDSolve::stps",
 CellID->71850243],
Cell[4438, 160, 350, 8, 70, "Message",
 CellTags->"NDSolve::stps",
 CellID->180855155],
Cell[4791, 170, 529, 19, 70, "Output",
 CellTags->"NDSolve::stps",
 CellID->487066445]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5359, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

