(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7937,        282]
NotebookOptionsPosition[      5554,        204]
NotebookOutlinePosition[      7030,        249]
CellTagsIndexPosition[      6913,        243]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::tponly", "ObjectName",
 CellID->25229],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"tponly\"\>"}], ":", 
  " ", "\<\"Currently the only discretization method implemented is \
SpatialDiscretization -> TensorProductGrid.\"\>"}]], "Message", "MSG",
 CellID->438014216],

Cell[TextData[{
 "Generated by an invalid value for the ",
 StyleBox["SpatialDiscretization", "MR"],
 " option."
}], "Notes",
 CellID->10170]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194289658],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->186703115],

Cell[TextData[{
 "An error occurs in this example because ",
 StyleBox["Triangularization", "MR"],
 " is not a valid value for the ",
 StyleBox["SpatialDiscretization", "MR"],
 " option."
}], "ExampleText",
 CellID->24947567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{
      "\"\<SpatialDiscretization\>\"", "\[Rule]", 
       "\"\<Triangularization\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::tponly",
 CellLabel->"In[1]:=",
 CellID->5878],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"tponly\"\>"}], ":", 
  " ", "\<\"Currently the only discretization method implemented is \
SpatialDiscretization -> TensorProductGrid.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::tponly",
 CellID->241197903],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"MethodOfLines\"\>", ",", 
      RowBox[{"\<\"SpatialDiscretization\"\>", 
       "\[Rule]", "\<\"Triangularization\"\>"}]}], "}"}]}]}], "]"}]], "Output",\

 CellTags->"NDSolve::tponly",
 CellLabel->"Out[1]=",
 CellID->278423106]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::tponly - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 38.7827322}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::tponly", "synonyms" -> {}, "title" -> 
    "NDSolve::tponly", "type" -> "Message", "uri" -> "ref/message/tponly"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1677, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->194289658]},
 "NDSolve::tponly"->{
  Cell[2463, 98, 1305, 41, 70, "Input",
   CellTags->"NDSolve::tponly",
   CellID->5878],
  Cell[3771, 141, 267, 6, 70, "Message",
   CellTags->"NDSolve::tponly",
   CellID->241197903],
  Cell[4041, 149, 1447, 48, 70, "Output",
   CellTags->"NDSolve::tponly",
   CellID->278423106]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6465, 226},
 {"NDSolve::tponly", 6606, 230}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->25229],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 237, 5, 70, "Message",
 CellID->438014216],
Cell[1499, 56, 141, 5, 70, "Notes",
 CellID->10170]
}, Closed]],
Cell[CellGroupData[{
Cell[1677, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194289658],
Cell[CellGroupData[{
Cell[2062, 80, 148, 5, 70, "ExampleSection",
 CellID->186703115],
Cell[2213, 87, 225, 7, 70, "ExampleText",
 CellID->24947567],
Cell[CellGroupData[{
Cell[2463, 98, 1305, 41, 70, "Input",
 CellTags->"NDSolve::tponly",
 CellID->5878],
Cell[3771, 141, 267, 6, 70, "Message",
 CellTags->"NDSolve::tponly",
 CellID->241197903],
Cell[4041, 149, 1447, 48, 70, "Output",
 CellTags->"NDSolve::tponly",
 CellID->278423106]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5527, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

