(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7777,        279]
NotebookOptionsPosition[      5424,        201]
NotebookOutlinePosition[      6879,        246]
CellTagsIndexPosition[      6764,        240]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::tvar", "ObjectName",
 CellID->12838],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"tvar\"\>"}], ":", 
  " ", "\<\"Value of option `1` -> `2` is not one of the independent \
variables `3`.\"\>"}]], "Message", "MSG",
 CellID->360116626],

Cell["\<\
Generated when the value of the indicated option does not have an expected \
form.\
\>", "Notes",
 CellID->28064]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81936912],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->240931333],

Cell[TextData[{
 "An error occurs in this example because the value of the ",
 StyleBox["TemporalVariable", "MR"],
 " option is the dependent variable rather than one of the two independent  \
variables."
}], "ExampleText",
 CellID->51540701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"MethodOfLines", ",", " ", 
      RowBox[{"TemporalVariable", "\[Rule]", "u"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NDSolve::tvar",
 CellLabel->"In[1]:=",
 CellID->6473],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"tvar\"\>"}], ":", 
  " ", "\<\"Value of option \\!\\(\\\"TemporalVariable\\\"\\) -> \\!\\(u\\) \
is not one of the independent variables \\!\\({x, t}\\).\"\>"}]], "Message", \
"MSG",
 CellTags->"NDSolve::tvar",
 CellID->85453454],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"MethodOfLines", ",", 
      RowBox[{"TemporalVariable", "\[Rule]", "u"}]}], "}"}]}]}], 
  "]"}]], "Output",
 CellTags->"NDSolve::tvar",
 CellLabel->"Out[1]=",
 CellID->75598505]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::tvar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 38.9546116}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::tvar", "synonyms" -> {}, "title" -> 
    "NDSolve::tvar", "type" -> "Message", "uri" -> "ref/message/tvar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1627, 65, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->81936912]},
 "NDSolve::tvar"->{
  Cell[2429, 96, 1246, 40, 70, "Input",
   CellTags->"NDSolve::tvar",
   CellID->6473],
  Cell[3678, 138, 285, 7, 70, "Message",
   CellTags->"NDSolve::tvar",
   CellID->85453454],
  Cell[3966, 147, 1392, 47, 70, "Output",
   CellTags->"NDSolve::tvar",
   CellID->75598505]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6327, 223},
 {"NDSolve::tvar", 6465, 227}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->12838],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 207, 5, 70, "Message",
 CellID->360116626],
Cell[1467, 56, 123, 4, 70, "Notes",
 CellID->28064]
}, Closed]],
Cell[CellGroupData[{
Cell[1627, 65, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81936912],
Cell[CellGroupData[{
Cell[2011, 79, 148, 5, 70, "ExampleSection",
 CellID->240931333],
Cell[2162, 86, 242, 6, 70, "ExampleText",
 CellID->51540701],
Cell[CellGroupData[{
Cell[2429, 96, 1246, 40, 70, "Input",
 CellTags->"NDSolve::tvar",
 CellID->6473],
Cell[3678, 138, 285, 7, 70, "Message",
 CellTags->"NDSolve::tvar",
 CellID->85453454],
Cell[3966, 147, 1392, 47, 70, "Output",
 CellTags->"NDSolve::tvar",
 CellID->75598505]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5397, 199, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

