(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7661,        269]
NotebookOptionsPosition[      5302,        191]
NotebookOutlinePosition[      6760,        236]
CellTagsIndexPosition[      6645,        230]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::tvic", "ObjectName",
 CellID->17324],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"tvic\"\>"}], ":", 
  " ", "\<\"`1` cannot be used as the temporal independent variable because \
the conditions `2` for that dimension do not constitute sufficient initial \
conditions given at only one value of `1`.\"\>"}]], "Message", "MSG",
 CellID->211550908],

Cell["\<\
Generated when the value of the indicated option is a variable that cannot be \
used as the temporal variable.\
\>", "Notes",
 CellID->14176]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->537505280],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->230907125],

Cell[TextData[{
 "An error occurs in this example because the equations are such that the  \
variable specified as the value of the ",
 StyleBox["TemporalVariable", "MR"],
 " option cannot be used as the temporal variable."
}], "ExampleText",
 CellID->80190840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"MethodOfLines", ",", " ", 
      RowBox[{"TemporalVariable", "\[Rule]", "x"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NDSolve::tvic",
 CellLabel->"In[1]:=",
 CellID->32558],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"tvic\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) cannot be used as the temporal independent variable \
because the conditions \\!\\({}\\) for that dimension do not constitute \
sufficient initial conditions given at only one value of \\!\\(x\\).\"\>"}]], \
"Message", "MSG",
 CellTags->"NDSolve::tvic",
 CellID->146123417],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        SuperscriptBox["x", "2"]}]]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"MethodOfLines", ",", 
      RowBox[{"TemporalVariable", "\[Rule]", "x"}]}], "}"}]}]}], 
  "]"}]], "Output",
 CellTags->"NDSolve::tvic",
 CellLabel->"Out[1]=",
 CellID->88647007]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::tvic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 39.0952402}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::tvic", "synonyms" -> {}, "title" -> 
    "NDSolve::tvic", "type" -> "Message", "uri" -> "ref/message/tvic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1767, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->537505280]},
 "NDSolve::tvic"->{
  Cell[2589, 97, 1055, 34, 70, "Input",
   CellTags->"NDSolve::tvic",
   CellID->32558],
  Cell[3647, 133, 371, 8, 70, "Message",
   CellTags->"NDSolve::tvic",
   CellID->146123417],
  Cell[4021, 143, 1215, 41, 70, "Output",
   CellTags->"NDSolve::tvic",
   CellID->88647007]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6205, 213},
 {"NDSolve::tvic", 6344, 217}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->17324],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 319, 6, 70, "Message",
 CellID->211550908],
Cell[1579, 57, 151, 4, 70, "Notes",
 CellID->14176]
}, Closed]],
Cell[CellGroupData[{
Cell[1767, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->537505280],
Cell[CellGroupData[{
Cell[2152, 80, 148, 5, 70, "ExampleSection",
 CellID->230907125],
Cell[2303, 87, 261, 6, 70, "ExampleText",
 CellID->80190840],
Cell[CellGroupData[{
Cell[2589, 97, 1055, 34, 70, "Input",
 CellTags->"NDSolve::tvic",
 CellID->32558],
Cell[3647, 133, 371, 8, 70, "Message",
 CellTags->"NDSolve::tvic",
 CellID->146123417],
Cell[4021, 143, 1215, 41, 70, "Output",
 CellTags->"NDSolve::tvic",
 CellID->88647007]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5275, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

