(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7583,        262]
NotebookOptionsPosition[      5212,        184]
NotebookOutlinePosition[      6679,        229]
CellTagsIndexPosition[      6563,        223]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::uniss", "ObjectName",
 CellID->24016],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"uniss\"\>"}], ":", 
  " ", "\<\"The spacing specified by MinStepSize -> `1` and MaxStepSize -> \
`2` for independent variable `3` cannot be used to construct a uniform grid \
on an interval of length `4`.  Using spacing `5` instead.\"\>"}]], "Message", \
"MSG",
 CellID->57678424],

Cell["\<\
Generated when the indicated option values restrict the step size in a way \
that is not commensurate with the interval for the corresponding variable.\
\>", "Notes",
 CellID->10172]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14425905],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->174733326],

Cell[TextData[{
 "A warning message is generated in this example because ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " did not use a step size that satisfied the restrictions indicated by the  \
options."
}], "ExampleText",
 CellID->129398709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"MaxStepSize", "\[Rule]", ".003"}], ",", " ", 
         RowBox[{"MinStepSize", "\[Rule]", ".003"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NDSolve::uniss",
 CellLabel->"In[1]:=",
 CellID->29950],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"uniss\"\>"}], ":", 
  " ", "\<\"The spacing specified by MinStepSize -> \\!\\(0.003`\\) and \
MaxStepSize -> \\!\\(0.003`\\) for independent variable \\!\\(x\\) cannot be \
used to construct a uniform grid on an interval of length \\!\\(2.`\\).  \
Using spacing \\!\\(0.0029985007496251873`\\) instead.\"\>"}]], "Message", \
"MSG",
 CellTags->"NDSolve::uniss",
 CellID->142027546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::uniss",
 CellLabel->"Out[1]=",
 CellID->157303019]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::uniss - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 39.2358688}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::uniss", "synonyms" -> {}, "title" -> 
    "NDSolve::uniss", "type" -> "Message", "uri" -> "ref/message/uniss"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1826, 67, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14425905]},
 "NDSolve::uniss"->{
  Cell[2706, 101, 1468, 44, 70, "Input",
   CellTags->"NDSolve::uniss",
   CellID->29950],
  Cell[4177, 147, 436, 9, 70, "Message",
   CellTags->"NDSolve::uniss",
   CellID->142027546],
  Cell[4616, 158, 530, 19, 70, "Output",
   CellTags->"NDSolve::uniss",
   CellID->157303019]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6119, 206},
 {"NDSolve::uniss", 6258, 210}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->24016],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 336, 7, 70, "Message",
 CellID->57678424],
Cell[1597, 58, 192, 4, 70, "Notes",
 CellID->10172]
}, Closed]],
Cell[CellGroupData[{
Cell[1826, 67, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14425905],
Cell[CellGroupData[{
Cell[2210, 81, 148, 5, 70, "ExampleSection",
 CellID->174733326],
Cell[2361, 88, 320, 9, 70, "ExampleText",
 CellID->129398709],
Cell[CellGroupData[{
Cell[2706, 101, 1468, 44, 70, "Input",
 CellTags->"NDSolve::uniss",
 CellID->29950],
Cell[4177, 147, 436, 9, 70, "Message",
 CellTags->"NDSolve::uniss",
 CellID->142027546],
Cell[4616, 158, 530, 19, 70, "Output",
 CellTags->"NDSolve::uniss",
 CellID->157303019]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5185, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

