(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9064,        323]
NotebookOptionsPosition[      6463,        236]
NotebookOutlinePosition[      7618,        271]
CellTagsIndexPosition[      7534,        266]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::cartdim", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"cartdim\"\>"}], ":", 
  " ", "\<\"The number of specified one-dimensional rules is larger than the \
dimension of the integral.\"\>"}]], "Message", "MSG",
 CellID->238643170],

Cell["\<\
Generated if the number of one dimensional rules specified for a Cartesian \
product integration rule does not correspond to the dimension of the \
integral.\
\>", "Notes",
 CellID->836491052]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128141280],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->212369006],

Cell["\<\
In this example the message is generated since the number of rules for the \
Cartesian product rule is larger than the dimension of the integral:\
\>", "ExampleText",
 CellID->95454697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"x", "+", "y", "+", "z"}]]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<GaussKronrodRule\>\"", ",", "\"\<ClenshawCurtisRule\>\"", ",", 
      "\"\<ClenshawCurtisRule\>\"", ",", "\"\<GaussKronrodRule\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1783568222],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"cartdim\"\>"}], ":", 
  " ", "\<\"The number of specified one-dimensional rules is larger than the \
dimension of the integral.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->1770863015],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"nsr\"\>"}], ":", 
  " ", "\<\"\\!\\({NIntegrate`CartesianRule, \\(\\(Method \[Rule] \
\\(\\({\\\"GaussKronrodRule\\\", \\\"ClenshawCurtisRule\\\", \
\\\"ClenshawCurtisRule\\\", \\\"GaussKronrodRule\\\"}\\)\\)\\)\\)}\\) is not \
a valid specification of an integration strategy or rule.\"\>"}]], "Message", \
"MSG",
 ShowCellLabel->True,
 CellID->575887568],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"x", "+", "y", "+", "z"}]]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"GaussKronrodRule\"\>", ",", "\<\"ClenshawCurtisRule\"\>", 
      ",", "\<\"ClenshawCurtisRule\"\>", ",", "\<\"GaussKronrodRule\"\>"}], 
     "}"}]}]}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->404340571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleText",
 CellID->2049580709],

Cell["These are correct specifications:", "ExampleText",
 CellID->1134684080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"x", "+", "y", "+", "z"}]]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<LobattoKronrodRule\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->123839270],

Cell[BoxData["0.8628770446397137`"], "Output",
 CellLabel->"Out[2]=",
 CellID->1582096216]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"x", "+", "y", "+", "z"}]]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<GaussKronrodRule\>\"", ",", "\"\<ClenshawCurtisRule\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31521415],

Cell[BoxData["0.8628770732335557`"], "Output",
 CellLabel->"Out[3]=",
 CellID->1347275418]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[StyleBox[ButtonBox["NIntegrate",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/NIntegrate"],
 FontFamily->"Verdana"]], "RelatedLinks",
 CellID->1703463674]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::cartdim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 54.2831290}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::cartdim", "synonyms" -> {}, "title" -> 
    "NIntegrate::cartdim", "type" -> "Message", "uri" -> 
    "ref/message/cartdim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1722, 65, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->128141280]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7392, 259}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 41, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[769, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1247, 48, 233, 5, 70, "Message",
 CellID->238643170],
Cell[1483, 55, 202, 5, 70, "Notes",
 CellID->836491052]
}, Closed]],
Cell[CellGroupData[{
Cell[1722, 65, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128141280],
Cell[CellGroupData[{
Cell[2107, 79, 148, 5, 70, "ExampleSection",
 CellID->212369006],
Cell[2258, 86, 195, 4, 70, "ExampleText",
 CellID->95454697],
Cell[CellGroupData[{
Cell[2478, 94, 630, 19, 70, "Input",
 CellID->1783568222],
Cell[3111, 115, 256, 6, 70, "Message",
 CellID->1770863015],
Cell[3370, 123, 415, 9, 70, "Message",
 CellID->575887568],
Cell[3788, 134, 624, 18, 70, "Output",
 CellID->404340571]
}, Open  ]],
Cell[4427, 155, 121, 3, 70, "ExampleText",
 CellID->2049580709],
Cell[4551, 160, 77, 1, 70, "ExampleText",
 CellID->1134684080],
Cell[CellGroupData[{
Cell[4653, 165, 471, 15, 70, "Input",
 CellID->123839270],
Cell[5127, 182, 90, 2, 70, "Output",
 CellID->1582096216]
}, Open  ]],
Cell[CellGroupData[{
Cell[5254, 189, 547, 17, 70, "Input",
 CellID->31521415],
Cell[5804, 208, 90, 2, 70, "Output",
 CellID->1347275418]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5955, 217, 295, 8, 70, "SeeAlsoSection"],
Cell[6253, 227, 168, 4, 70, "RelatedLinks",
 CellID->1703463674]
}, Open  ]],
Cell[6436, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

