(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7234,        252]
NotebookOptionsPosition[      5072,        181]
NotebookOutlinePosition[      6227,        216]
CellTagsIndexPosition[      6143,        211]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::deoncon", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deoncon\"\>"}], ":", 
  " ", "\<\"DoubleExponentialOscillatory has failed to converge for the \
integrand `1` over `2`. DoubleExponentialOscillatory obtained `3` and `4` for \
the integral and error estimates.\"\>"}]], "Message", "MSG",
 CellID->305043859],

Cell[TextData[{
 "Generated when the final (fourth) attempt to compute the integral by the \
method \"",
 Cell[BoxData["DoubleExponentialOscillatory"], "InlineFormula"],
 "\" gives an error estimate that does not satisfy the precision goal."
}], "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->518972616],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->257513229],

Cell[TextData[{
 "Example of integral for which \"",
 Cell[BoxData["DoubleExponentialOscillatory"], "InlineFormula"],
 "\" does not reach the precision goal:"
}], "ExampleText",
 CellID->1267734607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"18", "x"}], "]"}], 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"12", "x"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DoubleExponentialOscillatory\>\"", ",", 
      RowBox[{"\"\<Method\>\"", "\[Rule]", "None"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105147579],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deoncon\"\>"}], ":", 
  " ", "\<\"DoubleExponentialOscillatory has failed to converge for the \
integrand \\!\\(\\(\\(\\(Cos[\\(\\(12\\\\ x\\)\\)]\\)\\)\\\\ \
\\(\\(Sin[\\(\\(18\\\\ x\\)\\)]\\)\\)\\)\\/\\(1 + x\\)\\) over \\!\\({0, \
\[Infinity]}\\). DoubleExponentialOscillatory obtained \
\\!\\(0.09628289182454644`\\) and \\!\\(1.4949875111778352`*^-6\\) for the \
integral and error estimates.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->499059724],

Cell[BoxData["0.09628289182454644"], "Output",
 CellLabel->"Out[1]=",
 CellID->1064411603]
}, Open  ]],

Cell[TextData[{
 "Increasing the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " or the ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " gives a more correct result:"
}], "ExampleText",
 CellID->94209370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"18", "x"}], "]"}], 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"12", "x"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DoubleExponentialOscillatory\>\"", ",", 
      RowBox[{"\"\<Method\>\"", "\[Rule]", "None"}]}], "}"}]}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1903796782],

Cell[BoxData["0.0962828847184245210503505566260716224`20."], "Output",
 CellLabel->"Out[2]=",
 CellID->1971438951]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::deoncon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 54.7831418}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::deoncon", "synonyms" -> {}, "title" -> 
    "NIntegrate::deoncon", "type" -> "Message", "uri" -> 
    "ref/message/deoncon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1856, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->518972616]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6001, 204}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 41, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[769, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1247, 48, 315, 6, 70, "Message",
 CellID->305043859],
Cell[1565, 56, 254, 5, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[1856, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->518972616],
Cell[CellGroupData[{
Cell[2241, 80, 148, 5, 70, "ExampleSection",
 CellID->257513229],
Cell[2392, 87, 198, 5, 70, "ExampleText",
 CellID->1267734607],
Cell[CellGroupData[{
Cell[2615, 96, 588, 19, 70, "Input",
 CellID->105147579],
Cell[3206, 117, 525, 10, 70, "Message",
 CellID->499059724],
Cell[3734, 129, 90, 2, 70, "Output",
 CellID->1064411603]
}, Open  ]],
Cell[3839, 134, 383, 13, 70, "ExampleText",
 CellID->94209370],
Cell[CellGroupData[{
Cell[4247, 151, 642, 19, 70, "Input",
 CellID->1903796782],
Cell[4892, 172, 114, 2, 70, "Output",
 CellID->1971438951]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5045, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

