(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10085,        314]
NotebookOptionsPosition[      7805,        240]
NotebookOutlinePosition[      8946,        274]
CellTagsIndexPosition[      8862,        269]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[BoxData[GridBox[{
   {Cell["NIntegrate::eincr", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"eincr\"\>"}], ":", 
  " ", "\<\"The global error of the strategy GlobalAdaptive has increased \
more than `1` times. The global error is expected to decrease monotonically \
after a number of integrand evaluations. Suspect one of the following: the \
difference between the values of PrecisionGoal and WorkingPrecision is too \
small; the integrand is highly oscillatory or it is not a (piecewise) smooth \
function; or the true value of the integral is 0. Increasing the value of the \
GlobalAdaptive option MaxErrorIncreases might lead to a convergent numerical \
integration. NIntegrate obtained `2` and `3` for the integral and error \
estimates.\"\>"}]], "Message", "MSG",
 CellID->524564955],

Cell[TextData[{
 "Generated by the method \"",
 Cell[BoxData["GlobalAdaptive"], "InlineFormula"],
 "\" before it stops the integration in the cases when the global error \
estimate oscillates too much. The global error is expected to decrease \
monotonically after a certain number of integration steps. The message is \
given after ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"], "::", "slwcon"}]], 
  "InlineFormula"],
 "."
}], "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8398209],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->163443747],

Cell["\<\
Example of highly oscillatory integral that makes the global error estimate \
oscillate:\
\>", "ExampleText",
 CellID->1267734607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"3", "x"}]}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "300"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "20"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<GlobalAdaptive\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1652149372],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->721171811],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"eincr\"\>"}], ":", 
  " ", "\<\"The global error of the strategy GlobalAdaptive has increased \
more than \\!\\(400\\) times. The global error is expected to decrease \
monotonically after a number of integrand evaluations. Suspect one of the \
following: the difference between the values of PrecisionGoal and \
WorkingPrecision is too small; the integrand is highly oscillatory or it is \
not a (piecewise) smooth function; or the true value of the integral is 0. \
Increasing the value of the GlobalAdaptive option MaxErrorIncreases might \
lead to a convergent numerical integration. NIntegrate obtained \
\\!\\(0.3227490081031798`\\) and \\!\\(1.2476866936974969`\\) for the \
integral and error estimates.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->2134905624],

Cell[BoxData["0``-0.09610554345474367"], "Output",
 CellLabel->"Out[1]=",
 CellID->331086689]
}, Open  ]],

Cell["\<\
A correct result can be obtained with larger maximum number of error \
increases:\
\>", "ExampleText",
 CellID->94209370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"3", "x"}]}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "300"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "20"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"GlobalAdaptive", ",", 
      RowBox[{"MaxErrorIncreases", "\[Rule]", "10000"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1733999318],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->1823238533],

Cell[BoxData["0.6573232885058052`"], "Output",
 CellLabel->"Out[2]=",
 CellID->1952132436]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::eincr - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 55.2519038}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::eincr", "synonyms" -> {}, "title" -> 
    "NIntegrate::eincr", "type" -> "Message", "uri" -> "ref/message/eincr"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4095, 118, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->8398209]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8721, 262}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 1582, 37, 70, "ObjectNameGrid"],
Cell[CellGroupData[{
Cell[2310, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2788, 85, 756, 12, 70, "Message",
 CellID->524564955],
Cell[3547, 99, 511, 14, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[4095, 118, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8398209],
Cell[CellGroupData[{
Cell[4478, 132, 148, 5, 70, "ExampleSection",
 CellID->163443747],
Cell[4629, 139, 140, 4, 70, "ExampleText",
 CellID->1267734607],
Cell[CellGroupData[{
Cell[4794, 147, 475, 15, 70, "Input",
 CellID->1652149372],
Cell[5272, 164, 344, 7, 70, "Message",
 CellID->721171811],
Cell[5619, 173, 840, 14, 70, "Message",
 CellID->2134905624],
Cell[6462, 189, 93, 2, 70, "Output",
 CellID->331086689]
}, Open  ]],
Cell[6570, 194, 131, 4, 70, "ExampleText",
 CellID->94209370],
Cell[CellGroupData[{
Cell[6726, 202, 572, 18, 70, "Input",
 CellID->1733999318],
Cell[7301, 222, 345, 7, 70, "Message",
 CellID->1823238533],
Cell[7649, 231, 90, 2, 70, "Output",
 CellID->1952132436]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7778, 238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

