(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7179,        253]
NotebookOptionsPosition[      4691,        171]
NotebookOutlinePosition[      6167,        216]
CellTagsIndexPosition[      6049,        210]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::ncvi", "ObjectName",
 CellID->4209],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvi\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after `1` \
iterated refinements in `2` in the region `3`. NIntegrate obtained `4` and \
`5` for the integral and error estimates.\"\>"}]], "Message", "MSG",
 CellID->160617727],

Cell["\<\
Generated when the indicated number of refinements of  the range of \
integration is not sufficient to achieve the requested accuracy. \
\>", "Notes",
 CellID->13274],

Cell[TextData[{
 "This message can be generated when ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " is used with ",
 StyleBox["Method\[Rule]DoubleExponential", "MR"],
 " or ",
 StyleBox["Method\[Rule]Trapezoidal", "MR"],
 "."
}], "Notes",
 CellID->24140],

Cell[TextData[{
 "Difficulties with convergence of a numerical  integral can sometimes be \
addressed by using a different value of the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option, decreasing the value of the ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " option, increasing the value of the ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " option, or transforming the integral to a form that can be handled more  \
easily."
}], "Notes",
 CellID->25648]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47311635],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->78833329],

Cell["\<\
This integrand has an awkward singularity that cannot easily be integrated \
numerically.\
\>", "ExampleText",
 CellID->2318383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", "x"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "->", "DoubleExponential"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::ncvi",
 CellLabel->"In[1]:=",
 CellID->6497],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvi\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) iterated refinements in \\!\\(x\\) in the region \\!\\({\\({0.`, \
1.`}\\)}\\). NIntegrate obtained \\!\\(-0.12044940438536152`\\) and \
\\!\\(0.00406586120679607`\\) for the integral and error estimates.\"\>"}]], \
"Message", "MSG",
 CellTags->"NIntegrate::ncvi",
 CellID->4099749],

Cell[BoxData[
 RowBox[{"-", "0.12044940438536152`"}]], "Output",
 CellTags->"NIntegrate::ncvi",
 CellLabel->"Out[1]=",
 CellID->24324092]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::ncvi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 3.0021022}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::ncvi", "synonyms" -> {}, "title" -> 
    "NIntegrate::ncvi", "type" -> "Message", "uri" -> "ref/message/ncvi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2982, 107, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->47311635]},
 "NIntegrate::ncvi"->{
  Cell[3679, 136, 359, 11, 70, "Input",
   CellTags->"NIntegrate::ncvi",
   CellID->6497],
  Cell[4041, 149, 444, 9, 70, "Message",
   CellTags->"NIntegrate::ncvi",
   CellID->4099749],
  Cell[4488, 160, 137, 4, 70, "Output",
   CellTags->"NIntegrate::ncvi",
   CellID->24324092]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5602, 193},
 {"NIntegrate::ncvi", 5744, 197}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->4209],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 320, 6, 70, "Message",
 CellID->160617727],
Cell[1582, 57, 176, 4, 70, "Notes",
 CellID->13274],
Cell[1761, 63, 336, 12, 70, "Notes",
 CellID->24140],
Cell[2100, 77, 845, 25, 70, "Notes",
 CellID->25648]
}, Closed]],
Cell[CellGroupData[{
Cell[2982, 107, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47311635],
Cell[CellGroupData[{
Cell[3366, 121, 147, 5, 70, "ExampleSection",
 CellID->78833329],
Cell[3516, 128, 138, 4, 70, "ExampleText",
 CellID->2318383],
Cell[CellGroupData[{
Cell[3679, 136, 359, 11, 70, "Input",
 CellTags->"NIntegrate::ncvi",
 CellID->6497],
Cell[4041, 149, 444, 9, 70, "Message",
 CellTags->"NIntegrate::ncvi",
 CellID->4099749],
Cell[4488, 160, 137, 4, 70, "Output",
 CellTags->"NIntegrate::ncvi",
 CellID->24324092]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4664, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

