(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15216,        475]
NotebookOptionsPosition[     11520,        358]
NotebookOutlinePosition[     13478,        412]
CellTagsIndexPosition[     13356,        406]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[BoxData[GridBox[{
   {Cell["NIntegrate::slwcon", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"\>"}]], "Message", "MSG",
 CellID->144884131],

Cell["\<\
Generated when the integration algorithm does not appear to be converging as \
quick as expected.\
\>", "Notes",
 CellID->19272]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->811391409],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->64966647],

Cell["\<\
A warning message is generated in this example because the integral has a \
singularity inside the integration region:\
\>", "Text",
 CellID->30437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"1", "/", "3"}]}], ")"}], "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "12"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "40"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::slwcon",
 CellLabel->"In[1]:=",
 CellID->27943],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->256276716],

Cell[BoxData[
 RowBox[{"-", "3.273028336589596`"}]], "Output",
 CellTags->"NIntegrate::slwcon",
 CellLabel->"Out[1]=",
 CellID->337591942]
}, Open  ]],

Cell["\<\
The integral above is computed without issuing the message if the singular \
point is specified in the integration range:\
\>", "Text",
 CellID->17063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"1", "/", "3"}]}], ")"}], "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"1", "/", "3"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "12"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::slwcon",
 CellLabel->"In[2]:=",
 CellID->777763005],

Cell[BoxData[
 RowBox[{"-", "3.273028336589628`"}]], "Output",
 CellTags->"NIntegrate::slwcon",
 CellLabel->"Out[2]=",
 CellID->1081190284]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->812435003],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " returns faster a more precise result if the singular point is specified in \
the singular range:"
}], "Text",
 CellID->2073722223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"1", "/", "3"}]}], ")"}], "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PrecisionGoal", "\[Rule]", "12"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "40"}]}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"2", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}]}]}], ")"}], "/", "9"}], "]"}]}], 
    ")"}]}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->579915043],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.02199700000000002`", ",", "2.9753977059954195`*^-14"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->2138084032]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"1", "/", "3"}]}], ")"}], "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"1", "/", "3"}], ",", "1"}], "}"}], ",", 
     RowBox[{"PrecisionGoal", "\[Rule]", "12"}]}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"2", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}]}]}], ")"}], "/", "9"}], "]"}]}], 
    ")"}]}], "//", "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1964699296],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.011998`", ",", 
   RowBox[{"-", "2.6645352591003757`*^-15"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1744215968]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32735],

Cell[TextData[StyleBox[ButtonBox["NIntegrate",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/NIntegrate"],
 FontFamily->"Verdana"]], "RelatedLinks",
 CellID->120663668]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::slwcon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 18.4556228}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "NIntegrate::slwconA warning message is generated in this example because \
the integral has a singularity inside the integration region:The integral \
above is computed without issuing the message if the singular point is \
specified in the integration range:NIntegrate returns faster a more precise \
result if the singular point is specified in the singular range:", 
    "synonyms" -> {}, "title" -> "NIntegrate::slwcon", "type" -> "Message", 
    "uri" -> "ref/message/slwcon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5908, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->811391409]},
 "NIntegrate::slwcon"->{
  Cell[6626, 177, 459, 14, 70, "Input",
   CellTags->"NIntegrate::slwcon",
   CellID->27943],
  Cell[7635, 205, 138, 4, 70, "Output",
   CellTags->"NIntegrate::slwcon",
   CellID->337591942],
  Cell[7974, 220, 447, 14, 70, "Input",
   CellTags->"NIntegrate::slwcon",
   CellID->777763005],
  Cell[8424, 236, 139, 4, 70, "Output",
   CellTags->"NIntegrate::slwcon",
   CellID->1081190284]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12798, 386},
 {"NIntegrate::slwcon", 12943, 390}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 4202, 83, 70, "ObjectNameGrid"],
Cell[CellGroupData[{
Cell[4930, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5408, 131, 322, 6, 70, "Message",
 CellID->144884131],
Cell[5733, 139, 138, 4, 70, "Notes",
 CellID->19272]
}, Closed]],
Cell[CellGroupData[{
Cell[5908, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->811391409],
Cell[CellGroupData[{
Cell[6293, 162, 147, 5, 70, "ExampleSection",
 CellID->64966647],
Cell[6443, 169, 158, 4, 70, "Text",
 CellID->30437],
Cell[CellGroupData[{
Cell[6626, 177, 459, 14, 70, "Input",
 CellTags->"NIntegrate::slwcon",
 CellID->27943],
Cell[7088, 193, 544, 10, 70, "Message",
 CellID->256276716],
Cell[7635, 205, 138, 4, 70, "Output",
 CellTags->"NIntegrate::slwcon",
 CellID->337591942]
}, Open  ]],
Cell[7788, 212, 161, 4, 70, "Text",
 CellID->17063],
Cell[CellGroupData[{
Cell[7974, 220, 447, 14, 70, "Input",
 CellTags->"NIntegrate::slwcon",
 CellID->777763005],
Cell[8424, 236, 139, 4, 70, "Output",
 CellTags->"NIntegrate::slwcon",
 CellID->1081190284]
}, Open  ]],
Cell[8578, 243, 125, 3, 70, "ExampleDelimiter",
 CellID->812435003],
Cell[8706, 248, 272, 8, 70, "Text",
 CellID->2073722223],
Cell[CellGroupData[{
Cell[9003, 260, 788, 26, 70, "Input",
 CellID->579915043],
Cell[9794, 288, 162, 5, 70, "Output",
 CellID->2138084032]
}, Open  ]],
Cell[CellGroupData[{
Cell[9993, 298, 773, 26, 70, "Input",
 CellID->1964699296],
Cell[10769, 326, 167, 5, 70, "Output",
 CellID->1744215968]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10997, 338, 311, 9, 70, "SeeAlsoSection",
 CellID->32735],
Cell[11311, 349, 167, 4, 70, "RelatedLinks",
 CellID->120663668]
}, Open  ]],
Cell[11493, 356, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

