(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11459,        392]
NotebookOptionsPosition[      6540,        247]
NotebookOutlinePosition[      9682,        334]
CellTagsIndexPosition[      9530,        327]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NMinimize::bcons
NMaximize::bcons\
\>", "ObjectName",
 CellID->4867],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"bcons\"\>"}], ":", 
  " ", "\<\"The following constraints are not valid: `1`. Constraints should \
be equalities, inequalities, or domain specifications involving the \
variables.\"\>"}]], "Message", "MSG",
 CellID->148361706],

Cell[TextData[{
 "Generated when the indicated elements within the first  argument of ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " do not have the indicated form."
}], "Notes",
 CellID->32233],

Cell[TextData[{
 "If first argument in  ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " is a list, the first element in that list is expected to be a numerical  \
expression, and the remaining elements are expected to be constraints."
}], "Notes",
 CellID->12430]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31413402],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->241008961],

Cell[TextData[{
 "This message can be generated if the constraints are not given in a valid  \
form. In this example, you could use ",
 StyleBox["Element[x,Reals]", "MR"],
 " to indicate that ",
 StyleBox["x", "MR"],
 " is real."
}], "ExampleText",
 CellID->430408161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"Real", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellLabel->"In[1]:=",
 CellID->19892],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"bcons\"\>"}], ":", 
  " ", "\<\"The following constraints are not valid: \
\\!\\({\\(Real[x]\\)}\\). Constraints should be equalities, inequalities, or \
domain specifications involving the variables.\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->219375199],

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", 
     RowBox[{"Real", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Output",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellLabel->"Out[1]=",
 CellID->737418500]
}, Open  ]],

Cell[TextData[{
 "This message can also be generated if the function to minimize is not the  \
first element in the first argument of ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->236288938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[GreaterEqual]", "1"}], ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellLabel->"In[2]:=",
 CellID->4225],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"bcons\"\>"}], ":", 
  " ", "\<\"The following constraints are not valid: \\!\\({x\\^2}\\). \
Constraints should be equalities, inequalities, or domain specifications \
involving the variables.\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->61387925],

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[GreaterEqual]", "1"}], ",", 
     SuperscriptBox["x", "2"]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Output",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellLabel->"Out[2]=",
 CellID->70221306]
}, Open  ]],

Cell[TextData[{
 "This shows a correct use of ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " with a constraint."
}], "ExampleText",
 CellID->212965562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "\[GreaterEqual]", "3"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellLabel->"In[3]:=",
 CellID->10266],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3.`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellLabel->"Out[3]=",
 CellID->627493947]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NMinimize::bcons - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 26.4245768}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NMinimize::bcons NMaximize::bcons", "synonyms" -> {}, 
    "title" -> "NMinimize::bcons", "type" -> "Message", "uri" -> 
    "ref/message/bcons"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2506, 95, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->31413402]},
 "NMinimize::bcons"->{
  Cell[3334, 128, 310, 10, 70, "Input",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->19892],
  Cell[3647, 140, 358, 7, 70, "Message",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->219375199],
  Cell[4008, 149, 316, 10, 70, "Output",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->737418500],
  Cell[4665, 175, 315, 10, 70, "Input",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->4225],
  Cell[4983, 187, 349, 7, 70, "Message",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->61387925],
  Cell[5335, 196, 321, 10, 70, "Output",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->70221306],
  Cell[5927, 221, 316, 10, 70, "Input",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->10266],
  Cell[6246, 233, 228, 7, 70, "Output",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->627493947]},
 "NMaximize::bcons"->{
  Cell[3334, 128, 310, 10, 70, "Input",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->19892],
  Cell[3647, 140, 358, 7, 70, "Message",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->219375199],
  Cell[4008, 149, 316, 10, 70, "Output",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->737418500],
  Cell[4665, 175, 315, 10, 70, "Input",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->4225],
  Cell[4983, 187, 349, 7, 70, "Message",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->61387925],
  Cell[5335, 196, 321, 10, 70, "Output",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->70221306],
  Cell[5927, 221, 316, 10, 70, "Input",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->10266],
  Cell[6246, 233, 228, 7, 70, "Output",
   CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
   CellID->627493947]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7475, 270},
 {"NMinimize::bcons", 7616, 274},
 {"NMaximize::bcons", 8573, 299}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 78, 4, 70, "ObjectName",
 CellID->4867],
Cell[CellGroupData[{
Cell[806, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1284, 52, 303, 7, 70, "Message",
 CellID->148361706],
Cell[1590, 61, 404, 13, 70, "Notes",
 CellID->32233],
Cell[1997, 76, 472, 14, 70, "Notes",
 CellID->12430]
}, Closed]],
Cell[CellGroupData[{
Cell[2506, 95, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31413402],
Cell[CellGroupData[{
Cell[2890, 109, 148, 5, 70, "ExampleSection",
 CellID->241008961],
Cell[3041, 116, 268, 8, 70, "ExampleText",
 CellID->430408161],
Cell[CellGroupData[{
Cell[3334, 128, 310, 10, 70, "Input",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->19892],
Cell[3647, 140, 358, 7, 70, "Message",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->219375199],
Cell[4008, 149, 316, 10, 70, "Output",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->737418500]
}, Open  ]],
Cell[4339, 162, 301, 9, 70, "ExampleText",
 CellID->236288938],
Cell[CellGroupData[{
Cell[4665, 175, 315, 10, 70, "Input",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->4225],
Cell[4983, 187, 349, 7, 70, "Message",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->61387925],
Cell[5335, 196, 321, 10, 70, "Output",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->70221306]
}, Open  ]],
Cell[5671, 209, 231, 8, 70, "ExampleText",
 CellID->212965562],
Cell[CellGroupData[{
Cell[5927, 221, 316, 10, 70, "Input",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->10266],
Cell[6246, 233, 228, 7, 70, "Output",
 CellTags->{"NMinimize::bcons", "NMaximize::bcons"},
 CellID->627493947]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6513, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

