(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9189,        319]
NotebookOptionsPosition[      5388,        204]
NotebookOutlinePosition[      7798,        272]
CellTagsIndexPosition[      7648,        265]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NMinimize::lvar
NMaximize::lvar\
\>", "ObjectName",
 CellID->31378],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"lvar\"\>"}], ":", 
  " ", "\<\"Variables `1` should be a list of variables, with each element \
being a variable, or a list containing a variable and lower and upper bounds \
for the starting region for that variable.\"\>"}]], "Message", "MSG",
 CellID->407748693],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " is not a list of valid variables or a list of valid variables with upper  \
and lower bounds for each variable."
}], "Notes",
 CellID->29365],

Cell["\<\
Symbols and  expressions that do not have some other meaning are usually \
valid variables.  Numbers, strings, lists, inequalities, sums, powers, and \
products are not  valid variables.\
\>", "Notes",
 CellID->2641],

Cell[TextData[{
 "Upper and lower bounds for a variable  are specified using a list, such as \
",
 StyleBox["{x,1,2}", "MR"],
 "."
}], "Notes",
 CellID->18963]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80596590],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->115475325],

Cell[TextData[{
 "An error message will be generated if constraints are entered in the second \
 argument of ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ". The second argument in ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " is treated as the specification of the variables. An inequality is not a  \
valid variable."
}], "ExampleText",
 CellID->240790907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[GreaterEqual]", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellLabel->"In[1]:=",
 CellID->80438380],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"lvar\"\>"}], ":", 
  " ", "\<\"Variables \\!\\({x \[GreaterEqual] 3}\\) should be a list of \
variables, with each element being a variable, or a list containing a \
variable and lower and upper bounds for the starting region for that \
variable.\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellID->373799664],

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[GreaterEqual]", "3"}], "}"}]}], "]"}]], "Output",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellLabel->"Out[1]=",
 CellID->67018219]
}, Open  ]],

Cell[TextData[{
 "This shows a correct use of ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->69828665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "\[GreaterEqual]", "3"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellLabel->"In[2]:=",
 CellID->19124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3.`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellLabel->"Out[2]=",
 CellID->197716581]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NMinimize::lvar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 34.2685276}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NMinimize::lvar NMaximize::lvar", "synonyms" -> {}, "title" -> 
    "NMinimize::lvar", "type" -> "Message", "uri" -> "ref/message/lvar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2509, 95, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->80596590]},
 "NMinimize::lvar"->{
  Cell[3587, 135, 265, 8, 70, "Input",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->80438380],
  Cell[3855, 145, 402, 8, 70, "Message",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->373799664],
  Cell[4260, 155, 267, 8, 70, "Output",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->67018219],
  Cell[4779, 178, 314, 10, 70, "Input",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->19124],
  Cell[5096, 190, 226, 7, 70, "Output",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->197716581]},
 "NMaximize::lvar"->{
  Cell[3587, 135, 265, 8, 70, "Input",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->80438380],
  Cell[3855, 145, 402, 8, 70, "Message",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->373799664],
  Cell[4260, 155, 267, 8, 70, "Output",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->67018219],
  Cell[4779, 178, 314, 10, 70, "Input",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->19124],
  Cell[5096, 190, 226, 7, 70, "Output",
   CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
   CellID->197716581]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6313, 226},
 {"NMinimize::lvar", 6453, 230},
 {"NMaximize::lvar", 7050, 246}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 77, 4, 70, "ObjectName",
 CellID->31378],
Cell[CellGroupData[{
Cell[805, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1283, 52, 341, 7, 70, "Message",
 CellID->407748693],
Cell[1627, 61, 454, 14, 70, "Notes",
 CellID->29365],
Cell[2084, 77, 226, 5, 70, "Notes",
 CellID->2641],
Cell[2313, 84, 159, 6, 70, "Notes",
 CellID->18963]
}, Closed]],
Cell[CellGroupData[{
Cell[2509, 95, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80596590],
Cell[CellGroupData[{
Cell[2893, 109, 148, 5, 70, "ExampleSection",
 CellID->115475325],
Cell[3044, 116, 518, 15, 70, "ExampleText",
 CellID->240790907],
Cell[CellGroupData[{
Cell[3587, 135, 265, 8, 70, "Input",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellID->80438380],
Cell[3855, 145, 402, 8, 70, "Message",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellID->373799664],
Cell[4260, 155, 267, 8, 70, "Output",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellID->67018219]
}, Open  ]],
Cell[4542, 166, 212, 8, 70, "ExampleText",
 CellID->69828665],
Cell[CellGroupData[{
Cell[4779, 178, 314, 10, 70, "Input",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellID->19124],
Cell[5096, 190, 226, 7, 70, "Output",
 CellTags->{"NMinimize::lvar", "NMaximize::lvar"},
 CellID->197716581]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5361, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

