(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13514,        432]
NotebookOptionsPosition[      7570,        260]
NotebookOutlinePosition[     11411,        365]
CellTagsIndexPosition[     11259,        358]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NMinimize::nosat
NMaximize::nosat\
\>", "ObjectName",
 CellID->3408],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"nosat\"\>"}], ":", 
  " ", "\<\"Obtained solution does not satisfy the following constraints \
within Tolerance -> `2`: `1`.\"\>"}]], "Message", "MSG",
 CellID->87316821],

Cell["\<\
Generated when the indicated constraints are not satisfied by the result.\
\>", "Notes",
 CellID->20414],

Cell["\<\
This message will normally occur only if the constraints are inconsistent.\
\>", "Notes",
 CellID->19064]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->514446347],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->467974539],

Cell["\<\
A warning is generated in this example because the result does not satisfy \
the indicated equality constraint.\
\>", "ExampleText",
 CellID->27106302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "\[Equal]", "5"}], "&&", 
      RowBox[{
       RowBox[{"-", "2"}], "\[LessEqual]", "x", "\[LessEqual]", "2"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellLabel->"In[1]:=",
 CellID->29507],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"nosat\"\>"}], ":", 
  " ", "\<\"Obtained solution does not satisfy the following constraints \
within Tolerance -> \\!\\(0.001`\\): \\!\\({\\(\\(5 - x\\^2\\)\\) \[Equal] 0}\
\\).\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->103534846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2.`"}]}], "}"}]}], "}"}]], "Output",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellLabel->"Out[1]=",
 CellID->2407973]
}, Open  ]],

Cell["\<\
A warning is generated in this example because the result does not satisfy \
the indicated inequality constraint.\
\>", "ExampleText",
 CellID->197626797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "\[GreaterEqual]", "3"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"-", "2"}], "\[LessEqual]", 
       SuperscriptBox["x", "2"], "\[LessEqual]", "2"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellLabel->"In[2]:=",
 CellID->7833],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"incst\"\>"}], ":", 
  " ", "\<\"\\!\\(NMinimize\\) was unable to generate any initial points \
satisfying the inequality constraints \\!\\({\\(\\(\\(\\(\\(\\(-2\\)\\) - \
x\\^2\\)\\) \[LessEqual] 0\\)\\), \\(\\(\\(\\(3 - x\\^2\\)\\) \[LessEqual] \
0\\)\\), \\(\\(\\(\\(\\(\\(-2\\)\\) + x\\^2\\)\\) \[LessEqual] 0\\)\\)}\\). \
The initial region specified may not contain any feasible points. Changing \
the initial region or specifying explicit initial points may provide a better \
solution.\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->64826],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"incst\"\>"}], ":", 
  " ", "\<\"\\!\\(NMinimize\\) was unable to generate any initial points \
satisfying the inequality constraints \\!\\({\\(\\(\\(\\(\\(\\(-2\\)\\) - \
x\\^2\\)\\) \[LessEqual] 0\\)\\), \\(\\(\\(\\(3 - x\\^2\\)\\) \[LessEqual] \
0\\)\\), \\(\\(\\(\\(\\(\\(-2\\)\\) + x\\^2\\)\\) \[LessEqual] 0\\)\\)}\\). \
The initial region specified may not contain any feasible points. Changing \
the initial region or specifying explicit initial points may provide a better \
solution.\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->2577650],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"nosat\"\>"}], ":", 
  " ", "\<\"Obtained solution does not satisfy the following constraints \
within Tolerance -> \\!\\(0.001`\\): \\!\\({\\(\\(\\(\\(3 - x\\^2\\)\\) \
\[LessEqual] 0\\)\\), \\(\\(\\(\\(\\(\\(-2\\)\\) + x\\^2\\)\\) \[LessEqual] 0\
\\)\\)}\\).\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->3981308],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.499999999998181`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.5811388300836144`"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellLabel->"Out[2]=",
 CellID->795132497]
}, Open  ]],

Cell["\<\
A warning message is generated in this example because the constraints are \
inconsistent.\
\>", "ExampleText",
 CellID->264807625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "\[Equal]", "5"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"-", "2"}], "\[LessEqual]", "x", "\[LessEqual]", "2"}]}]}], 
    "}"}], ",", " ", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
 CellLabel->"In[3]:=",
 CellID->28874],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"nosat\"\>"}], ":", 
  " ", "\<\"Obtained solution does not satisfy the following constraints \
within Tolerance -> \\!\\(0.001`\\): \\!\\({\\(\\(5 - x\\^2\\)\\) \[Equal] 0}\
\\).\"\>"}]], "Message", "MSG",
 CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
 CellID->119755925],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2.`"}]}], "}"}]}], "}"}]], "Output",
 CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
 CellLabel->"Out[3]=",
 CellID->307104504]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NMinimize::nosat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 34.5654102}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NMinimize::nosat NMaximize::nosat", "synonyms" -> {}, 
    "title" -> "NMinimize::nosat", "type" -> "Message", "uri" -> 
    "ref/message/nosat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1803, 73, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->514446347]},
 "NMinimize::nosat"->{
  Cell[2525, 102, 454, 15, 70, "Input",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->29507],
  Cell[2982, 119, 336, 7, 70, "Message",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->103534846],
  Cell[3321, 128, 247, 8, 70, "Output",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->2407973],
  Cell[3772, 147, 504, 15, 70, "Input",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->7833],
  Cell[4279, 164, 646, 11, 70, "Message",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->64826],
  Cell[4928, 177, 648, 11, 70, "Message",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->2577650],
  Cell[5579, 190, 415, 8, 70, "Message",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->3981308],
  Cell[5997, 200, 261, 8, 70, "Output",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->795132497],
  Cell[6439, 219, 474, 15, 70, "Input",
   CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
   CellID->28874],
  Cell[6916, 236, 336, 7, 70, "Message",
   CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
   CellID->119755925],
  Cell[7255, 245, 249, 8, 70, "Output",
   CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
   CellID->307104504]},
 "NMaximize::nosat"->{
  Cell[2525, 102, 454, 15, 70, "Input",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->29507],
  Cell[2982, 119, 336, 7, 70, "Message",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->103534846],
  Cell[3321, 128, 247, 8, 70, "Output",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->2407973],
  Cell[3772, 147, 504, 15, 70, "Input",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->7833],
  Cell[4279, 164, 646, 11, 70, "Message",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->64826],
  Cell[4928, 177, 648, 11, 70, "Message",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->2577650],
  Cell[5579, 190, 415, 8, 70, "Message",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->3981308],
  Cell[5997, 200, 261, 8, 70, "Output",
   CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
   CellID->795132497],
  Cell[6439, 219, 474, 15, 70, "Input",
   CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
   CellID->28874],
  Cell[6916, 236, 336, 7, 70, "Message",
   CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
   CellID->119755925],
  Cell[7255, 245, 249, 8, 70, "Output",
   CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
   CellID->307104504]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8505, 283},
 {"NMinimize::nosat", 8647, 287},
 {"NMaximize::nosat", 9953, 321}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 78, 4, 70, "ObjectName",
 CellID->3408],
Cell[CellGroupData[{
Cell[806, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1284, 52, 247, 6, 70, "Message",
 CellID->87316821],
Cell[1534, 60, 114, 3, 70, "Notes",
 CellID->20414],
Cell[1651, 65, 115, 3, 70, "Notes",
 CellID->19064]
}, Closed]],
Cell[CellGroupData[{
Cell[1803, 73, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->514446347],
Cell[CellGroupData[{
Cell[2188, 87, 148, 5, 70, "ExampleSection",
 CellID->467974539],
Cell[2339, 94, 161, 4, 70, "ExampleText",
 CellID->27106302],
Cell[CellGroupData[{
Cell[2525, 102, 454, 15, 70, "Input",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->29507],
Cell[2982, 119, 336, 7, 70, "Message",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->103534846],
Cell[3321, 128, 247, 8, 70, "Output",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->2407973]
}, Open  ]],
Cell[3583, 139, 164, 4, 70, "ExampleText",
 CellID->197626797],
Cell[CellGroupData[{
Cell[3772, 147, 504, 15, 70, "Input",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->7833],
Cell[4279, 164, 646, 11, 70, "Message",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->64826],
Cell[4928, 177, 648, 11, 70, "Message",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->2577650],
Cell[5579, 190, 415, 8, 70, "Message",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->3981308],
Cell[5997, 200, 261, 8, 70, "Output",
 CellTags->{"NMinimize::nosat", "NMaximize::nosat"},
 CellID->795132497]
}, Open  ]],
Cell[6273, 211, 141, 4, 70, "ExampleText",
 CellID->264807625],
Cell[CellGroupData[{
Cell[6439, 219, 474, 15, 70, "Input",
 CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
 CellID->28874],
Cell[6916, 236, 336, 7, 70, "Message",
 CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
 CellID->119755925],
Cell[7255, 245, 249, 8, 70, "Output",
 CellTags->{"NMaximize::nosat", "NMinimize::nosat"},
 CellID->307104504]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7543, 258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

