(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6545,        232]
NotebookOptionsPosition[      3629,        143]
NotebookOutlinePosition[      5578,        199]
CellTagsIndexPosition[      5428,        192]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NMinimize::nsol
NMaximize::nsol\
\>", "ObjectName",
 CellID->720],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"nsol\"\>"}], ":", 
  " ", "\<\"There are no points that satisfy the constraints `1`.\"\>"}]], \
"Message", "MSG",
 CellID->337360826],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " determines that the constraints are inconsistent."
}], "Notes",
 CellID->17467]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->650382516],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->638414678],

Cell["\<\
An error occurs in this example because the constraints are inconsistent.\
\>", "ExampleText",
 CellID->109293084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", " ", 
     RowBox[{
      RowBox[{"0", "\[GreaterEqual]", "x"}], " ", "&&", " ", 
      RowBox[{"x", "\[GreaterEqual]", "1"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
 CellLabel->"In[1]:=",
 CellID->7699],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"nsol\"\>"}], ":", 
  " ", "\<\"There are no points that satisfy the constraints \\!\\({\\(\\(x \
\[LessEqual] 0\\)\\), \\(\\(\\(\\(1 - x\\)\\) \[LessEqual] \
0\\)\\)}\\).\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
 CellID->17193210],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "Indeterminate"}], "}"}]}], "}"}]], "Output",
 CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
 CellLabel->"Out[1]=",
 CellID->296894443]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NMinimize::nsol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 34.7060388}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NMinimize::nsol NMaximize::nsol", "synonyms" -> {}, "title" -> 
    "NMinimize::nsol", "type" -> "Message", "uri" -> "ref/message/nsol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1900, 78, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->650382516]},
 "NMinimize::nsol"->{
  Cell[2585, 106, 403, 12, 70, "Input",
   CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
   CellID->7699],
  Cell[2991, 120, 325, 7, 70, "Message",
   CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
   CellID->17193210],
  Cell[3319, 129, 244, 7, 70, "Output",
   CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
   CellID->296894443]},
 "NMaximize::nsol"->{
  Cell[2585, 106, 403, 12, 70, "Input",
   CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
   CellID->7699],
  Cell[2991, 120, 325, 7, 70, "Message",
   CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
   CellID->17193210],
  Cell[3319, 129, 244, 7, 70, "Output",
   CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
   CellID->296894443]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4554, 165},
 {"NMinimize::nsol", 4695, 169},
 {"NMaximize::nsol", 5061, 179}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 75, 4, 70, "ObjectName",
 CellID->720],
Cell[CellGroupData[{
Cell[803, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1281, 52, 210, 6, 70, "Message",
 CellID->337360826],
Cell[1494, 60, 369, 13, 70, "Notes",
 CellID->17467]
}, Closed]],
Cell[CellGroupData[{
Cell[1900, 78, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->650382516],
Cell[CellGroupData[{
Cell[2285, 92, 148, 5, 70, "ExampleSection",
 CellID->638414678],
Cell[2436, 99, 124, 3, 70, "ExampleText",
 CellID->109293084],
Cell[CellGroupData[{
Cell[2585, 106, 403, 12, 70, "Input",
 CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
 CellID->7699],
Cell[2991, 120, 325, 7, 70, "Message",
 CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
 CellID->17193210],
Cell[3319, 129, 244, 7, 70, "Output",
 CellTags->{"NMinimize::nsol", "NMaximize::nsol"},
 CellID->296894443]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3602, 141, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

