(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6283,        245]
NotebookOptionsPosition[      4062,        171]
NotebookOutlinePosition[      5213,        205]
CellTagsIndexPosition[      5129,        200]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NMinimize::ubnd
NMaximize::ubnd\
\>", "ObjectName",
 CellID->28114],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"ubnd\"\>"}], ":", 
  " ", "\<\"The problem is unbounded.\"\>"}]], "Message", "MSG",
 CellID->134381828],

Cell["\<\
Generated when the function is able to determine that the problem does not \
have a finite solution.\
\>", "Notes",
 CellID->14378],

Cell["\<\
This is generally only applied for linear programming problems.\
\>", "Notes",
 CellID->4276]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121466908],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->696928304],

Cell["This is unbounded from above and below.", "ExampleText",
 CellID->30120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], ",", 
     RowBox[{"x", ">", 
      RowBox[{"y", "+", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31931],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"ubnd\"\>"}], ":", 
  " ", "\<\"The problem is unbounded.\"\>"}]], "Message", "MSG",
 CellID->194546315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[Infinity]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->235012820]
}, Open  ]],

Cell["\<\
If we restrict the variables to be positive, we have a finite solution.\
\>", "ExampleText",
 CellID->25789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], ",", 
     RowBox[{"x", ">", 
      RowBox[{"y", "+", "1"}]}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->186946659]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NMinimize::ubnd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 34.9872960}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NMinimize::ubnd NMaximize::ubnd", "synonyms" -> {}, "title" -> 
    "NMinimize::ubnd", "type" -> "Message", "uri" -> "ref/message/ubnd"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1750, 73, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->121466908]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4987, 193}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 77, 4, 70, "ObjectName",
 CellID->28114],
Cell[CellGroupData[{
Cell[805, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1283, 52, 180, 5, 70, "Message",
 CellID->134381828],
Cell[1466, 59, 141, 4, 70, "Notes",
 CellID->14378],
Cell[1610, 65, 103, 3, 70, "Notes",
 CellID->4276]
}, Closed]],
Cell[CellGroupData[{
Cell[1750, 73, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121466908],
Cell[CellGroupData[{
Cell[2135, 87, 148, 5, 70, "ExampleSection",
 CellID->696928304],
Cell[2286, 94, 78, 1, 70, "ExampleText",
 CellID->30120],
Cell[CellGroupData[{
Cell[2389, 99, 345, 13, 70, "Input",
 CellID->31931],
Cell[2737, 114, 161, 4, 70, "Message",
 CellID->194546315],
Cell[2901, 120, 282, 9, 70, "Output",
 CellID->235012820]
}, Open  ]],
Cell[3198, 132, 118, 3, 70, "ExampleText",
 CellID->25789],
Cell[CellGroupData[{
Cell[3341, 139, 417, 15, 70, "Input",
 CellID->31148],
Cell[3761, 156, 235, 8, 70, "Output",
 CellID->186946659]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4035, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

