(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8450,        312]
NotebookOptionsPosition[      4763,        199]
NotebookOutlinePosition[      7129,        267]
CellTagsIndexPosition[      6983,        260]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NProduct::istep
NSum::istep\
\>", "ObjectName",
 CellID->19661],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"istep\"\>"}], ":", 
  " ", "\<\"Cannot get from `1` to `2` in steps of `3`.\"\>"}]], "Message", \
"MSG",
 CellID->262104003],

Cell[TextData[{
 "Generated when the step size specified in ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " is incompatible with the limits."
}], "Notes",
 CellID->8824],

Cell[TextData[{
 "The step size is  the fourth element in a range specification of the form \
",
 StyleBox["{", "MR"],
 StyleBox["k", "TI"],
 StyleBox[",", "MR"],
 StyleBox["min", "TI"],
 StyleBox[",", "MR"],
 StyleBox["max", "TI"],
 StyleBox[",", "MR"],
 StyleBox["step", "TI"],
 StyleBox["}", "MR"],
 "."
}], "Notes",
 CellID->1888]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->925145036],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->649896901],

Cell[TextData[{
 "An error occurs in this example because it is not possible to go from ",
 StyleBox["1", "MR"],
 " to ",
 StyleBox["10", "MR"],
 " in steps of ",
 StyleBox["\[ImaginaryI]", "MR"],
 "."
}], "ExampleText",
 CellID->71417904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"k", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "10", ",", "\[ImaginaryI]"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellLabel->"In[1]:=",
 CellID->740518796],

Cell[BoxData[
 RowBox[{
  RowBox[{"NSum", "::", "\<\"istep\"\>"}], ":", 
  " ", "\<\"Cannot get from \\!\\(1\\) to \\!\\(10\\) in steps of \\!\\(\
\[ImaginaryI]\\).\"\>"}]], "Message", "MSG",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellID->74975328],

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["k", "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "10", ",", "\[ImaginaryI]"}], "}"}]}], 
  "]"}]], "Output",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellLabel->"Out[1]=",
 CellID->705013297]
}, Open  ]],

Cell[TextData[{
 "This shows a correct use of ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " with a step size of ",
 StyleBox["\[ImaginaryI]", "MR"],
 "."
}], "ExampleText",
 CellID->30609023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"k", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "\[ImaginaryI]", ",", 
     RowBox[{"10", "\[ImaginaryI]"}], ",", "\[ImaginaryI]"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellLabel->"In[2]:=",
 CellID->10245],

Cell[BoxData[
 RowBox[{"-", "1.5497677311665408`"}]], "Output",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellLabel->"Out[2]=",
 CellID->451259323]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NProduct::istep - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 50.6283214}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NProduct::istep NSum::istep", "synonyms" -> {}, "title" -> 
    "NProduct::istep", "type" -> "Message", "uri" -> "ref/message/istep"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2223, 94, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->925145036]},
 "NProduct::istep"->{
  Cell[3023, 128, 304, 10, 70, "Input",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->740518796],
  Cell[3330, 140, 257, 6, 70, "Message",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->74975328],
  Cell[3590, 148, 304, 10, 70, "Output",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->705013297],
  Cell[4196, 175, 345, 11, 70, "Input",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->10245],
  Cell[4544, 188, 153, 4, 70, "Output",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->451259323]},
 "NSum::istep"->{
  Cell[3023, 128, 304, 10, 70, "Input",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->740518796],
  Cell[3330, 140, 257, 6, 70, "Message",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->74975328],
  Cell[3590, 148, 304, 10, 70, "Output",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->705013297],
  Cell[4196, 175, 345, 11, 70, "Input",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->10245],
  Cell[4544, 188, 153, 4, 70, "Output",
   CellTags->{"NProduct::istep", "NSum::istep"},
   CellID->451259323]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5685, 221},
 {"NProduct::istep", 5826, 225},
 {"NSum::istep", 6402, 241}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 73, 4, 70, "ObjectName",
 CellID->19661],
Cell[CellGroupData[{
Cell[801, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1279, 52, 201, 6, 70, "Message",
 CellID->262104003],
Cell[1483, 60, 366, 13, 70, "Notes",
 CellID->8824],
Cell[1852, 75, 334, 14, 70, "Notes",
 CellID->1888]
}, Closed]],
Cell[CellGroupData[{
Cell[2223, 94, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->925145036],
Cell[CellGroupData[{
Cell[2608, 108, 148, 5, 70, "ExampleSection",
 CellID->649896901],
Cell[2759, 115, 239, 9, 70, "ExampleText",
 CellID->71417904],
Cell[CellGroupData[{
Cell[3023, 128, 304, 10, 70, "Input",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellID->740518796],
Cell[3330, 140, 257, 6, 70, "Message",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellID->74975328],
Cell[3590, 148, 304, 10, 70, "Output",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellID->705013297]
}, Open  ]],
Cell[3909, 161, 262, 10, 70, "ExampleText",
 CellID->30609023],
Cell[CellGroupData[{
Cell[4196, 175, 345, 11, 70, "Input",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellID->10245],
Cell[4544, 188, 153, 4, 70, "Output",
 CellTags->{"NProduct::istep", "NSum::istep"},
 CellID->451259323]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4736, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

