(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7355,        289]
NotebookOptionsPosition[      4430,        191]
NotebookOutlinePosition[      6077,        242]
CellTagsIndexPosition[      5961,        236]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NProduct::itfn", "ObjectName",
 CellID->1154],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "::", "\<\"itfn\"\>"}], ":", 
  " ", "\<\"`1` does not have the correct form for an iterator.\"\>"}]], \
"Message", "MSG",
 CellID->35168962],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " does not have the expected form."
}], "Notes",
 CellID->11636],

Cell[TextData[{
 "The second argument  in ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " is the iterator specification."
}], "Notes",
 CellID->13577],

Cell[TextData[{
 "An iterator  specification can be given in the form ",
 StyleBox["{", "MR"],
 StyleBox["i", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imax", "TI"],
 StyleBox["}", "MR"],
 ", ",
 StyleBox["{", "MR"],
 StyleBox["i", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imax", "TI"],
 StyleBox["}", "MR"],
 ", or ",
 StyleBox["{", "MR"],
 StyleBox["i", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imax", "TI"],
 StyleBox[",", "MR"],
 StyleBox["step", "TI"],
 StyleBox["}", "MR"],
 "."
}], "Notes",
 CellID->24395]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->357923431],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->197213624],

Cell["\<\
An error occurs in this example because a number is not a valid iteration \
specification.\
\>", "ExampleText",
 CellID->223522787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{"k", ",", "5"}], "]"}]], "Input",
 CellTags->"NProduct::itfn",
 CellLabel->"In[1]:=",
 CellID->2676],

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "::", "\<\"itfn\"\>"}], ":", 
  " ", "\<\"\\!\\(5\\) does not have the correct form for an \
iterator.\"\>"}]], "Message", "MSG",
 CellTags->"NProduct::itfn",
 CellID->112152671],

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{"k", ",", "5"}], "]"}]], "Output",
 CellTags->"NProduct::itfn",
 CellLabel->"Out[1]=",
 CellID->145749609]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->352381875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"NProduct::itfn",
 CellLabel->"In[2]:=",
 CellID->14755],

Cell[BoxData["120.`"], "Output",
 CellTags->"NProduct::itfn",
 CellLabel->"Out[2]=",
 CellID->186920801]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NProduct::itfn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 50.7689500}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NProduct::itfn", "synonyms" -> {}, "title" -> 
    "NProduct::itfn", "type" -> "Message", "uri" -> "ref/message/itfn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2563, 108, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->357923431]},
 "NProduct::itfn"->{
  Cell[3265, 137, 151, 5, 70, "Input",
   CellTags->"NProduct::itfn",
   CellID->2676],
  Cell[3419, 144, 224, 6, 70, "Message",
   CellTags->"NProduct::itfn",
   CellID->112152671],
  Cell[3646, 152, 157, 5, 70, "Output",
   CellTags->"NProduct::itfn",
   CellID->145749609],
  Cell[4056, 172, 201, 7, 70, "Input",
   CellTags->"NProduct::itfn",
   CellID->14755],
  Cell[4260, 181, 104, 3, 70, "Output",
   CellTags->"NProduct::itfn",
   CellID->186920801]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5336, 213},
 {"NProduct::itfn", 5477, 217}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->1154],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 187, 5, 70, "Message",
 CellID->35168962],
Cell[1447, 56, 243, 8, 70, "Notes",
 CellID->11636],
Cell[1693, 66, 227, 8, 70, "Notes",
 CellID->13577],
Cell[1923, 76, 603, 27, 70, "Notes",
 CellID->24395]
}, Closed]],
Cell[CellGroupData[{
Cell[2563, 108, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->357923431],
Cell[CellGroupData[{
Cell[2948, 122, 148, 5, 70, "ExampleSection",
 CellID->197213624],
Cell[3099, 129, 141, 4, 70, "ExampleText",
 CellID->223522787],
Cell[CellGroupData[{
Cell[3265, 137, 151, 5, 70, "Input",
 CellTags->"NProduct::itfn",
 CellID->2676],
Cell[3419, 144, 224, 6, 70, "Message",
 CellTags->"NProduct::itfn",
 CellID->112152671],
Cell[3646, 152, 157, 5, 70, "Output",
 CellTags->"NProduct::itfn",
 CellID->145749609]
}, Open  ]],
Cell[3818, 160, 213, 8, 70, "ExampleText",
 CellID->352381875],
Cell[CellGroupData[{
Cell[4056, 172, 201, 7, 70, "Input",
 CellTags->"NProduct::itfn",
 CellID->14755],
Cell[4260, 181, 104, 3, 70, "Output",
 CellTags->"NProduct::itfn",
 CellID->186920801]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4403, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

