(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7064,        266]
NotebookOptionsPosition[      4234,        172]
NotebookOutlinePosition[      5891,        223]
CellTagsIndexPosition[      5774,        217]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NProduct::npnum", "ObjectName",
 CellID->15437],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "::", "\<\"npnum\"\>"}], ":", 
  " ", "\<\"Multiplicand `1` is not numerical at point `2` = `3`.\"\>"}]], \
"Message", "MSG",
 CellID->415825126],

Cell[TextData[{
 "Generated when the first argument in ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " does not evaluate to a number at the indicated point."
}], "Notes",
 CellID->13625]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->183441148],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->648980989],

Cell[TextData[{
 "An error occurs in this example because the symbolic parameter in the first \
 argument of ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " does not have a numerical value."
}], "ExampleText",
 CellID->759861444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"k", "^", 
    RowBox[{"-", "s"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"NProduct::npnum",
 CellLabel->"In[1]:=",
 CellID->5257],

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "::", "\<\"npnum\"\>"}], ":", 
  " ", "\<\"Multiplicand \\!\\(k\\^\\(-s\\)\\) is not numerical at point \
\\!\\(k\\) = \\!\\(15\\).\"\>"}]], "Message", "MSG",
 CellTags->"NProduct::npnum",
 CellID->157206821],

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   SuperscriptBox["k", 
    RowBox[{"-", "s"}]], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Output",
 CellTags->"NProduct::npnum",
 CellLabel->"Out[1]=",
 CellID->243682297]
}, Open  ]],

Cell[TextData[{
 "This shows a valid iteration specification in ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->3539182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", "2.3"}], "}"}], ",", 
   RowBox[{"NProduct", "[", 
    RowBox[{
     RowBox[{"k", "^", 
      RowBox[{"-", "s"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"NProduct::npnum",
 CellLabel->"In[2]:=",
 CellID->31959],

Cell[BoxData["0.`"], "Output",
 CellTags->"NProduct::npnum",
 CellLabel->"Out[2]=",
 CellID->14309641]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NProduct::npnum - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 58.4253960}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NProduct::npnum", "synonyms" -> {}, "title" -> 
    "NProduct::npnum", "type" -> "Message", "uri" -> "ref/message/npnum"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1753, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->183441148]},
 "NProduct::npnum"->{
  Cell[2620, 103, 262, 9, 70, "Input",
   CellTags->"NProduct::npnum",
   CellID->5257],
  Cell[2885, 114, 254, 6, 70, "Message",
   CellTags->"NProduct::npnum",
   CellID->157206821],
  Cell[3142, 122, 272, 9, 70, "Output",
   CellTags->"NProduct::npnum",
   CellID->243682297],
  Cell[3681, 146, 382, 14, 70, "Input",
   CellTags->"NProduct::npnum",
   CellID->31959],
  Cell[4066, 162, 102, 3, 70, "Output",
   CellTags->"NProduct::npnum",
   CellID->14309641]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5144, 194},
 {"NProduct::npnum", 5285, 198}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->15437],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 191, 5, 70, "Message",
 CellID->415825126],
Cell[1453, 56, 263, 8, 70, "Notes",
 CellID->13625]
}, Closed]],
Cell[CellGroupData[{
Cell[1753, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->183441148],
Cell[CellGroupData[{
Cell[2138, 83, 148, 5, 70, "ExampleSection",
 CellID->648980989],
Cell[2289, 90, 306, 9, 70, "ExampleText",
 CellID->759861444],
Cell[CellGroupData[{
Cell[2620, 103, 262, 9, 70, "Input",
 CellTags->"NProduct::npnum",
 CellID->5257],
Cell[2885, 114, 254, 6, 70, "Message",
 CellTags->"NProduct::npnum",
 CellID->157206821],
Cell[3142, 122, 272, 9, 70, "Output",
 CellTags->"NProduct::npnum",
 CellID->243682297]
}, Open  ]],
Cell[3429, 134, 227, 8, 70, "ExampleText",
 CellID->3539182],
Cell[CellGroupData[{
Cell[3681, 146, 382, 14, 70, "Input",
 CellTags->"NProduct::npnum",
 CellID->31959],
Cell[4066, 162, 102, 3, 70, "Output",
 CellTags->"NProduct::npnum",
 CellID->14309641]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4207, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

