(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7327,        272]
NotebookOptionsPosition[      4506,        178]
NotebookOutlinePosition[      6156,        229]
CellTagsIndexPosition[      6040,        223]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NRoots::nnumeq", "ObjectName",
 CellID->23994],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NRoots", "::", "\<\"nnumeq\"\>"}], ":", 
  " ", "\<\"`1` is expected to be a polynomial equation in the variable `2` \
with numeric coefficients.\"\>"}]], "Message", "MSG",
 CellID->74598677],

Cell[TextData[{
 "Generated when the first argument in ",
 Cell[BoxData[
  ButtonBox["NRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NRoots"]], "InlineFormula"],
 " does not have a head of ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " or does not have two elements."
}], "Notes",
 CellID->1708]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->650257242],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->482767043],

Cell[TextData[{
 "An error occurs in this example because the first argument in ",
 Cell[BoxData[
  ButtonBox["NRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NRoots"]], "InlineFormula"],
 " is not an equation."
}], "ExampleText",
 CellID->618643829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"3", "x"}], "+", "7"}], ",", "x"}], "]"}]], "Input",
 CellTags->"NRoots::nnumeq",
 CellLabel->"In[1]:=",
 CellID->2484],

Cell[BoxData[
 RowBox[{
  RowBox[{"NRoots", "::", "\<\"nnumeq\"\>"}], ":", 
  " ", "\<\"\\!\\(\\(\\(7.` \[InvisibleSpace]\\)\\) - \\(\\(3.`\\\\ x\\)\\) + \
x\\^2\\) is expected to be a polynomial equation in the variable \\!\\(x\\) \
with numeric coefficients.\"\>"}]], "Message", "MSG",
 CellTags->"NRoots::nnumeq",
 CellID->572765099],

Cell[BoxData[
 RowBox[{"NRoots", "[", 
  RowBox[{
   RowBox[{"7", "-", 
    RowBox[{"3", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", "x"}], "]"}]], "Output",
 CellTags->"NRoots::nnumeq",
 CellLabel->"Out[1]=",
 CellID->142335139]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["NRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NRoots"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->358175508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"3", "x"}], "+", "7"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellTags->"NRoots::nnumeq",
 CellLabel->"In[2]:=",
 CellID->16522],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "-", 
    RowBox[{"2.1794494717703365`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "+", 
    RowBox[{"2.1794494717703365`", " ", "\[ImaginaryI]"}]}]}]}]], "Output",
 CellTags->"NRoots::nnumeq",
 CellLabel->"Out[2]=",
 CellID->255039440]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NRoots::nnumeq - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 58.8941580}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NRoots::nnumeq", "synonyms" -> {}, "title" -> 
    "NRoots::nnumeq", "type" -> "Message", "uri" -> "ref/message/nnumeq"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1902, 74, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->650257242]},
 "NRoots::nnumeq"->{
  Cell[2723, 107, 228, 8, 70, "Input",
   CellTags->"NRoots::nnumeq",
   CellID->2484],
  Cell[2954, 117, 336, 7, 70, "Message",
   CellTags->"NRoots::nnumeq",
   CellID->572765099],
  Cell[3293, 126, 240, 8, 70, "Output",
   CellTags->"NRoots::nnumeq",
   CellID->142335139],
  Cell[3782, 149, 266, 10, 70, "Input",
   CellTags->"NRoots::nnumeq",
   CellID->16522],
  Cell[4051, 161, 389, 10, 70, "Output",
   CellTags->"NRoots::nnumeq",
   CellID->255039440]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5414, 200},
 {"NRoots::nnumeq", 5554, 204}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->23994],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 226, 5, 70, "Message",
 CellID->74598677],
Cell[1487, 56, 378, 13, 70, "Notes",
 CellID->1708]
}, Closed]],
Cell[CellGroupData[{
Cell[1902, 74, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->650257242],
Cell[CellGroupData[{
Cell[2287, 88, 148, 5, 70, "ExampleSection",
 CellID->482767043],
Cell[2438, 95, 260, 8, 70, "ExampleText",
 CellID->618643829],
Cell[CellGroupData[{
Cell[2723, 107, 228, 8, 70, "Input",
 CellTags->"NRoots::nnumeq",
 CellID->2484],
Cell[2954, 117, 336, 7, 70, "Message",
 CellTags->"NRoots::nnumeq",
 CellID->572765099],
Cell[3293, 126, 240, 8, 70, "Output",
 CellTags->"NRoots::nnumeq",
 CellID->142335139]
}, Open  ]],
Cell[3548, 137, 209, 8, 70, "ExampleText",
 CellID->358175508],
Cell[CellGroupData[{
Cell[3782, 149, 266, 10, 70, "Input",
 CellTags->"NRoots::nnumeq",
 CellID->16522],
Cell[4051, 161, 389, 10, 70, "Output",
 CellTags->"NRoots::nnumeq",
 CellID->255039440]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4479, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

