(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7256,        289]
NotebookOptionsPosition[      4394,        191]
NotebookOutlinePosition[      5999,        242]
CellTagsIndexPosition[      5887,        236]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NSum::itfn", "ObjectName",
 CellID->28419],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NSum", "::", "\<\"itfn\"\>"}], ":", 
  " ", "\<\"`1` does not have the correct form for an iterator.\"\>"}]], \
"Message", "MSG",
 CellID->835698055],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " does not have the expected form."
}], "Notes",
 CellID->1900],

Cell[TextData[{
 "The second argument  in ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " is the iterator specification."
}], "Notes",
 CellID->31262],

Cell[TextData[{
 "An iterator  specification can be given in the form ",
 StyleBox["{", "MR"],
 StyleBox["i", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imax", "TI"],
 StyleBox["}", "MR"],
 ", ",
 StyleBox["{", "MR"],
 StyleBox["i", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imax", "TI"],
 StyleBox["}", "MR"],
 ", or ",
 StyleBox["{", "MR"],
 StyleBox["i", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["imax", "TI"],
 StyleBox[",", "MR"],
 StyleBox["step", "TI"],
 StyleBox["}", "MR"],
 "."
}], "Notes",
 CellID->7874]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->73128779],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->789007470],

Cell["\<\
An error occurs in this example because a number is not a valid iteration \
specification.\
\>", "ExampleText",
 CellID->406498065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{"k", ",", "25"}], "]"}]], "Input",
 CellTags->"NSum::itfn",
 CellLabel->"In[1]:=",
 CellID->21532],

Cell[BoxData[
 RowBox[{
  RowBox[{"NSum", "::", "\<\"itfn\"\>"}], ":", 
  " ", "\<\"\\!\\(25\\) does not have the correct form for an \
iterator.\"\>"}]], "Message", "MSG",
 CellTags->"NSum::itfn",
 CellID->137245201],

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{"k", ",", "25"}], "]"}]], "Output",
 CellTags->"NSum::itfn",
 CellLabel->"Out[1]=",
 CellID->359706706]
}, Open  ]],

Cell[TextData[{
 "This shows a valid iteration specification in ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->302558295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellTags->"NSum::itfn",
 CellLabel->"In[2]:=",
 CellID->4527],

Cell[BoxData["325.0000000000002`"], "Output",
 CellTags->"NSum::itfn",
 CellLabel->"Out[2]=",
 CellID->578161579]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NSum::itfn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 15, 6.3162230}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NSum::itfn", "synonyms" -> {}, "title" -> "NSum::itfn", 
    "type" -> "Message", "uri" -> "ref/message/itfn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2539, 108, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->73128779]},
 "NSum::itfn"->{
  Cell[3240, 137, 145, 5, 70, "Input",
   CellTags->"NSum::itfn",
   CellID->21532],
  Cell[3388, 144, 217, 6, 70, "Message",
   CellTags->"NSum::itfn",
   CellID->137245201],
  Cell[3608, 152, 150, 5, 70, "Output",
   CellTags->"NSum::itfn",
   CellID->359706706],
  Cell[4019, 172, 193, 7, 70, "Input",
   CellTags->"NSum::itfn",
   CellID->4527],
  Cell[4215, 181, 113, 3, 70, "Output",
   CellTags->"NSum::itfn",
   CellID->578161579]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5287, 213},
 {"NSum::itfn", 5423, 217}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 48, 1, 70, "ObjectName",
 CellID->28419],
Cell[CellGroupData[{
Cell[776, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1254, 49, 184, 5, 70, "Message",
 CellID->835698055],
Cell[1441, 56, 234, 8, 70, "Notes",
 CellID->1900],
Cell[1678, 66, 219, 8, 70, "Notes",
 CellID->31262],
Cell[1900, 76, 602, 27, 70, "Notes",
 CellID->7874]
}, Closed]],
Cell[CellGroupData[{
Cell[2539, 108, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->73128779],
Cell[CellGroupData[{
Cell[2923, 122, 148, 5, 70, "ExampleSection",
 CellID->789007470],
Cell[3074, 129, 141, 4, 70, "ExampleText",
 CellID->406498065],
Cell[CellGroupData[{
Cell[3240, 137, 145, 5, 70, "Input",
 CellTags->"NSum::itfn",
 CellID->21532],
Cell[3388, 144, 217, 6, 70, "Message",
 CellTags->"NSum::itfn",
 CellID->137245201],
Cell[3608, 152, 150, 5, 70, "Output",
 CellTags->"NSum::itfn",
 CellID->359706706]
}, Open  ]],
Cell[3773, 160, 221, 8, 70, "ExampleText",
 CellID->302558295],
Cell[CellGroupData[{
Cell[4019, 172, 193, 7, 70, "Input",
 CellTags->"NSum::itfn",
 CellID->4527],
Cell[4215, 181, 113, 3, 70, "Output",
 CellTags->"NSum::itfn",
 CellID->578161579]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4367, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

