(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9407,        366]
NotebookOptionsPosition[      5353,        226]
NotebookOutlinePosition[      7520,        295]
CellTagsIndexPosition[      7405,        289]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NumericQ::set", "ObjectName",
 CellID->21644],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumericQ", "::", "\<\"set\"\>"}], ":", 
  " ", "\<\"Cannot set `1` to `2`; the lhs argument must be a symbol and the \
rhs must be True or False.\"\>"}]], "Message", "MSG",
 CellID->698564182],

Cell[TextData[{
 "Generated when the argument in ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " on the left side of an assignment is not a symbol, or the expression on  \
the right side is not ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9426]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80409642],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->946248083],

Cell[TextData[{
 "An error occurs in this example because the right side of this assignment  \
is not ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->334759836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NumericQ", "[", "test", "]"}], "=", 
  RowBox[{"Sqrt", "[", "2", "]"}]}]], "Input",
 CellTags->"NumericQ::set",
 CellLabel->"In[1]:=",
 CellID->16413],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumericQ", "::", "\<\"set\"\>"}], ":", 
  " ", "\<\"Cannot set \\!\\(NumericQ[test]\\) to \\!\\(\\@2\\); the lhs \
argument must be a symbol and the rhs must be True or False.\"\>"}]], \
"Message", "MSG",
 CellTags->"NumericQ::set",
 CellID->3792504]
}, Open  ]],

Cell["\<\
These inputs set a numerical value for the test symbol and specify that the \
test symbol is a numeric quantity.\
\>", "ExampleText",
 CellID->501588805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", "test", "]"}], "=", 
  RowBox[{"Sqrt", "[", "2", "]"}]}]], "Input",
 CellTags->"NumericQ::set",
 CellLabel->"In[2]:=",
 CellID->14752],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 CellTags->"NumericQ::set",
 CellLabel->"Out[2]=",
 CellID->556324927]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NumericQ", "[", "test", "]"}], "=", "True"}]], "Input",
 CellTags->"NumericQ::set",
 CellLabel->"In[3]:=",
 CellID->23479],

Cell[BoxData["True"], "Output",
 CellTags->"NumericQ::set",
 CellLabel->"Out[3]=",
 CellID->7751935]
}, Open  ]],

Cell["\<\
The test symbol now has a numerical value and will be treated as a numeric \
quantity.\
\>", "ExampleText",
 CellID->1132202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "test", "]"}]], "Input",
 CellTags->"NumericQ::set",
 CellLabel->"In[4]:=",
 CellID->27356],

Cell[BoxData["1.4142135623730951`"], "Output",
 CellTags->"NumericQ::set",
 CellLabel->"Out[4]=",
 CellID->27200448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Cos", "[", "test", "]"}], "]"}]], "Input",
 CellTags->"NumericQ::set",
 CellLabel->"In[5]:=",
 CellID->23633],

Cell[BoxData["True"], "Output",
 CellTags->"NumericQ::set",
 CellLabel->"Out[5]=",
 CellID->115379660]
}, Open  ]],

Cell["Remove the changes to the test symbol.", "ExampleText",
 CellID->917536729],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "test", "]"}], ";", 
  RowBox[{
   RowBox[{"NumericQ", "[", "test", "]"}], "=."}]}]], "Input",
 CellTags->"NumericQ::set",
 CellLabel->"In[6]:=",
 CellID->2046]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumericQ::set - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 15, 14.4101802}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NumericQ::set", "synonyms" -> {}, "title" -> 
    "NumericQ::set", "type" -> "Message", "uri" -> "ref/message/set"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2063, 80, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->80409642]},
 "NumericQ::set"->{
  Cell[3004, 119, 185, 6, 70, "Input",
   CellTags->"NumericQ::set",
   CellID->16413],
  Cell[3192, 127, 285, 7, 70, "Message",
   CellTags->"NumericQ::set",
   CellID->3792504],
  Cell[3680, 145, 178, 6, 70, "Input",
   CellTags->"NumericQ::set",
   CellID->14752],
  Cell[3861, 153, 110, 4, 70, "Output",
   CellTags->"NumericQ::set",
   CellID->556324927],
  Cell[4008, 162, 157, 5, 70, "Input",
   CellTags->"NumericQ::set",
   CellID->23479],
  Cell[4168, 169, 100, 3, 70, "Output",
   CellTags->"NumericQ::set",
   CellID->7751935],
  Cell[4443, 183, 124, 4, 70, "Input",
   CellTags->"NumericQ::set",
   CellID->27356],
  Cell[4570, 189, 116, 3, 70, "Output",
   CellTags->"NumericQ::set",
   CellID->27200448],
  Cell[4723, 197, 161, 5, 70, "Input",
   CellTags->"NumericQ::set",
   CellID->23633],
  Cell[4887, 204, 102, 3, 70, "Output",
   CellTags->"NumericQ::set",
   CellID->115379660],
  Cell[5088, 213, 211, 7, 70, "Input",
   CellTags->"NumericQ::set",
   CellID->2046]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6255, 248},
 {"NumericQ::set", 6393, 252}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->21644],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 227, 5, 70, "Message",
 CellID->698564182],
Cell[1487, 56, 539, 19, 70, "Notes",
 CellID->9426]
}, Closed]],
Cell[CellGroupData[{
Cell[2063, 80, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80409642],
Cell[CellGroupData[{
Cell[2447, 94, 148, 5, 70, "ExampleSection",
 CellID->946248083],
Cell[2598, 101, 381, 14, 70, "ExampleText",
 CellID->334759836],
Cell[CellGroupData[{
Cell[3004, 119, 185, 6, 70, "Input",
 CellTags->"NumericQ::set",
 CellID->16413],
Cell[3192, 127, 285, 7, 70, "Message",
 CellTags->"NumericQ::set",
 CellID->3792504]
}, Open  ]],
Cell[3492, 137, 163, 4, 70, "ExampleText",
 CellID->501588805],
Cell[CellGroupData[{
Cell[3680, 145, 178, 6, 70, "Input",
 CellTags->"NumericQ::set",
 CellID->14752],
Cell[3861, 153, 110, 4, 70, "Output",
 CellTags->"NumericQ::set",
 CellID->556324927]
}, Open  ]],
Cell[CellGroupData[{
Cell[4008, 162, 157, 5, 70, "Input",
 CellTags->"NumericQ::set",
 CellID->23479],
Cell[4168, 169, 100, 3, 70, "Output",
 CellTags->"NumericQ::set",
 CellID->7751935]
}, Open  ]],
Cell[4283, 175, 135, 4, 70, "ExampleText",
 CellID->1132202],
Cell[CellGroupData[{
Cell[4443, 183, 124, 4, 70, "Input",
 CellTags->"NumericQ::set",
 CellID->27356],
Cell[4570, 189, 116, 3, 70, "Output",
 CellTags->"NumericQ::set",
 CellID->27200448]
}, Open  ]],
Cell[CellGroupData[{
Cell[4723, 197, 161, 5, 70, "Input",
 CellTags->"NumericQ::set",
 CellID->23633],
Cell[4887, 204, 102, 3, 70, "Output",
 CellTags->"NumericQ::set",
 CellID->115379660]
}, Open  ]],
Cell[5004, 210, 81, 1, 70, "ExampleText",
 CellID->917536729],
Cell[5088, 213, 211, 7, 70, "Input",
 CellTags->"NumericQ::set",
 CellID->2046]
}, Open  ]]
}, Open  ]],
Cell[5326, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

