(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10674,        372]
NotebookOptionsPosition[      6090,        241]
NotebookOutlinePosition[      9281,        327]
CellTagsIndexPosition[      9106,        319]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Read::readf
ReadList::readf
Skip::readf\
\>", "ObjectName",
 CellID->25403],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"readf\"\>"}], ":", 
  " ", "\<\"`1` is not a valid format specification.\"\>"}]], "Message", \
"MSG",
 CellID->51129249],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Skip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skip"]], "InlineFormula"],
 " is not a valid format specification."
}], "Notes",
 CellID->18099],

Cell[TextData[{
 "Valid format  specifications include ",
 Cell[BoxData[
  ButtonBox["Expression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expression"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Number",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Number"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Word",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Word"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Record",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Record"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Byte",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Byte"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Character",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Character"]], "InlineFormula"],
 ", or a list of these specifications."
}], "Notes",
 CellID->1957]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->713558681],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->525758021],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 " is not a valid format specification."
}], "ExampleText",
 CellID->824747087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", 
      RowBox[{"StringToStream", "[", "\"\<18 19 25\>\"", "]"}]}], ",", 
     "result"}], "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"result", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"s", ",", "Integer"}], "]"}]}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "s", "]"}], ";", "\n", "\t", "result"}]}], "\n", 
  "\t", "]"}]], "Input",
 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellLabel->"In[1]:=",
 CellID->27093],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadList", "::", "\<\"readf\"\>"}], ":", 
  " ", "\<\"\\!\\(Integer\\) is not a valid format specification.\"\>"}]], \
"Message", "MSG",
 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellID->92623406],

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{
   RowBox[{"InputStream", "[", 
    RowBox[{"String", ",", "298"}], "]"}], ",", "Integer"}], "]"}]], "Output",\

 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellLabel->"Out[1]=",
 CellID->170587055]
}, Open  ]],

Cell[TextData[{
 "This shows a valid format specification in ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->89043057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", 
      RowBox[{"StringToStream", "[", "\"\<18 19 25\>\"", "]"}]}], ",", 
     "result"}], "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"result", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"s", ",", "Number"}], "]"}]}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "s", "]"}], ";", "\n", "\t", "result"}]}], "\n", 
  "\t", "]"}]], "Input",
 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellLabel->"In[2]:=",
 CellID->19997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18", ",", "19", ",", "25"}], "}"}]], "Output",
 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellLabel->"Out[2]=",
 CellID->171495070]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Read::readf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 16, 58.4128426}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Read::readf ReadList::readf Skip::readf", "synonyms" -> {}, 
    "title" -> "Read::readf", "type" -> "Message", "uri" -> 
    "ref/message/readf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3113, 129, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->713558681]},
 "Read::readf"->{
  Cell[3931, 162, 554, 16, 70, "Input",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->27093],
  Cell[4488, 180, 252, 6, 70, "Message",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->92623406],
  Cell[4743, 188, 269, 8, 70, "Output",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->170587055],
  Cell[5277, 211, 553, 16, 70, "Input",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->19997],
  Cell[5833, 229, 191, 5, 70, "Output",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->171495070]},
 "ReadList::readf"->{
  Cell[3931, 162, 554, 16, 70, "Input",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->27093],
  Cell[4488, 180, 252, 6, 70, "Message",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->92623406],
  Cell[4743, 188, 269, 8, 70, "Output",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->170587055],
  Cell[5277, 211, 553, 16, 70, "Input",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->19997],
  Cell[5833, 229, 191, 5, 70, "Output",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->171495070]},
 "Skip::readf"->{
  Cell[3931, 162, 554, 16, 70, "Input",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->27093],
  Cell[4488, 180, 252, 6, 70, "Message",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->92623406],
  Cell[4743, 188, 269, 8, 70, "Output",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->170587055],
  Cell[5277, 211, 553, 16, 70, "Input",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->19997],
  Cell[5833, 229, 191, 5, 70, "Output",
   CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
   CellID->171495070]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7021, 264},
 {"Read::readf", 7159, 268},
 {"ReadList::readf", 7809, 284},
 {"Skip::readf", 8455, 300}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 85, 5, 70, "ObjectName",
 CellID->25403],
Cell[CellGroupData[{
Cell[813, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1291, 53, 197, 6, 70, "Message",
 CellID->51129249],
Cell[1491, 61, 486, 18, 70, "Notes",
 CellID->18099],
Cell[1980, 81, 1096, 43, 70, "Notes",
 CellID->1957]
}, Closed]],
Cell[CellGroupData[{
Cell[3113, 129, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->713558681],
Cell[CellGroupData[{
Cell[3498, 143, 148, 5, 70, "ExampleSection",
 CellID->525758021],
Cell[3649, 150, 257, 8, 70, "ExampleText",
 CellID->824747087],
Cell[CellGroupData[{
Cell[3931, 162, 554, 16, 70, "Input",
 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellID->27093],
Cell[4488, 180, 252, 6, 70, "Message",
 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellID->92623406],
Cell[4743, 188, 269, 8, 70, "Output",
 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellID->170587055]
}, Open  ]],
Cell[5027, 199, 225, 8, 70, "ExampleText",
 CellID->89043057],
Cell[CellGroupData[{
Cell[5277, 211, 553, 16, 70, "Input",
 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellID->19997],
Cell[5833, 229, 191, 5, 70, "Output",
 CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"},
 CellID->171495070]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6063, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

