(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14674,        477]
NotebookOptionsPosition[      7486,        280]
NotebookOutlinePosition[     12552,        411]
CellTagsIndexPosition[     12376,        403]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Read::readn
ReadList::readn
Skip::readn\
\>", "ObjectName",
 CellID->3984],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"readn\"\>"}], ":", 
  " ", "\<\"Invalid real number found when reading from `1`.\"\>"}]], \
"Message", "MSG",
 CellID->84496115],

Cell[TextData[{
 "Generated when syntax that does not correspond to a  number is encountered \
while reading ",
 Cell[BoxData[
  ButtonBox["Number",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Number"]], "InlineFormula"],
 " format from the indicated stream."
}], "Notes",
 CellID->26383]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331325430],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->42425295],

Cell[TextData[{
 "An error occurs in this example because the characters read from the stream \
 are not valid in ",
 Cell[BoxData[
  ButtonBox["Number",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Number"]], "InlineFormula"],
 " format."
}], "ExampleText",
 CellID->33637590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", 
      RowBox[{"StringToStream", "[", "\"\<{1.7, 3.5, 2.2}\>\"", "]"}]}], ",", 
     "result"}], "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"result", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"s", ",", "Number"}], "]"}]}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "s", "]"}], ";", "\n", "\t", "result"}]}], "\n", 
  "\t", "]"}]], "Input",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellLabel->"In[1]:=",
 CellID->1236],

Cell[BoxData[
 RowBox[{
  RowBox[{"Read", "::", "\<\"readn\"\>"}], ":", 
  " ", "\<\"Invalid real number found when reading from \
\\!\\(System`Private`StringTurnedIntoStream[\\\"{1.7, 3.5, \
2.2}\\\"]\\).\"\>"}]], "Message", "MSG",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->95177909],

Cell[BoxData[
 RowBox[{"{", "$Failed", "}"}]], "Output",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellLabel->"Out[1]=",
 CellID->692988907]
}, Open  ]],

Cell[TextData[{
 "This stream can be read in ",
 Cell[BoxData[
  ButtonBox["Expression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expression"]], "InlineFormula"],
 " format."
}], "ExampleText",
 CellID->40205117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", 
      RowBox[{"StringToStream", "[", "\"\<{1.7, 3.5, 2.2}\>\"", "]"}]}], ",", 
     "result"}], "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"result", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"s", ",", "Expression"}], "]"}]}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "s", "]"}], ";", "\n", "\t", "result"}]}], "\n", 
  "\t", "]"}]], "Input",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellLabel->"In[2]:=",
 CellID->7551],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1.7`", ",", "3.5`", ",", "2.2`"}], "}"}], "}"}]], "Output",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellLabel->"Out[2]=",
 CellID->463281624]
}, Open  ]],

Cell[TextData[{
 "An error occurs in this example because the commas in the input stream are  \
not valid in ",
 Cell[BoxData[
  ButtonBox["Number",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Number"]], "InlineFormula"],
 " format."
}], "ExampleText",
 CellID->177306465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", 
      RowBox[{"StringToStream", "[", "\"\<1.7, 2.4, 3.5\>\"", "]"}]}], ",", 
     "result"}], "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"result", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"s", ",", "Number"}], "]"}]}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "s", "]"}], ";", "\n", "\t", "result"}]}], "\n", 
  "\t", "]"}]], "Input",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellLabel->"In[3]:=",
 CellID->17138],

Cell[BoxData[
 RowBox[{
  RowBox[{"Read", "::", "\<\"readn\"\>"}], ":", 
  " ", "\<\"Invalid real number found when reading from \
\\!\\(System`Private`StringTurnedIntoStream[\\\"1.7, 2.4, \
3.5\\\"]\\).\"\>"}]], "Message", "MSG",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->289519788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.7`", ",", "$Failed"}], "}"}]], "Output",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellLabel->"Out[3]=",
 CellID->223167383]
}, Open  ]],

Cell[TextData[{
 "The numbers in this example can be read in ",
 Cell[BoxData[
  ButtonBox["Word",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Word"]], "InlineFormula"],
 " format and converted to numbers using ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->446893242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", 
      RowBox[{"StringToStream", "[", "\"\<1.7, 2.4, 3.5\>\"", "]"}]}], ",", 
     "result"}], "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"result", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"s", ",", "Word", ",", 
       RowBox[{"WordSeparators", "->", "\"\<,\>\""}]}], "]"}]}], ";", "\n", 
    "\t", 
    RowBox[{"Close", "[", "s", "]"}], ";", "\n", "\t", 
    RowBox[{"ToExpression", "/@", "result"}]}]}], "\n", "\t", "]"}]], "Input",\

 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellLabel->"In[4]:=",
 CellID->8302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.7`", ",", "2.4`", ",", "3.5`"}], "}"}]], "Output",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellLabel->"Out[4]=",
 CellID->592870867]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Read::readn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 16, 58.5847220}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Read::readn ReadList::readn Skip::readn", "synonyms" -> {}, 
    "title" -> "Read::readn", "type" -> "Message", "uri" -> 
    "ref/message/readn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1828, 75, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->331325430]},
 "Read::readn"->{
  Cell[2669, 109, 559, 16, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->1236],
  Cell[3231, 127, 313, 7, 70, "Message",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->95177909],
  Cell[3547, 136, 161, 4, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->692988907],
  Cell[3968, 155, 563, 16, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->7551],
  Cell[4534, 173, 221, 6, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->463281624],
  Cell[5072, 195, 558, 16, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->17138],
  Cell[5633, 213, 312, 7, 70, "Message",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->289519788],
  Cell[5948, 222, 187, 5, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->223167383],
  Cell[6564, 247, 656, 19, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->8302],
  Cell[7223, 268, 197, 5, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->592870867]},
 "ReadList::readn"->{
  Cell[2669, 109, 559, 16, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->1236],
  Cell[3231, 127, 313, 7, 70, "Message",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->95177909],
  Cell[3547, 136, 161, 4, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->692988907],
  Cell[3968, 155, 563, 16, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->7551],
  Cell[4534, 173, 221, 6, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->463281624],
  Cell[5072, 195, 558, 16, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->17138],
  Cell[5633, 213, 312, 7, 70, "Message",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->289519788],
  Cell[5948, 222, 187, 5, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->223167383],
  Cell[6564, 247, 656, 19, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->8302],
  Cell[7223, 268, 197, 5, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->592870867]},
 "Skip::readn"->{
  Cell[2669, 109, 559, 16, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->1236],
  Cell[3231, 127, 313, 7, 70, "Message",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->95177909],
  Cell[3547, 136, 161, 4, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->692988907],
  Cell[3968, 155, 563, 16, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->7551],
  Cell[4534, 173, 221, 6, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->463281624],
  Cell[5072, 195, 558, 16, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->17138],
  Cell[5633, 213, 312, 7, 70, "Message",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->289519788],
  Cell[5948, 222, 187, 5, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->223167383],
  Cell[6564, 247, 656, 19, 70, "Input",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->8302],
  Cell[7223, 268, 197, 5, 70, "Output",
   CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
   CellID->592870867]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8417, 303},
 {"Read::readn", 8554, 307},
 {"ReadList::readn", 9829, 338},
 {"Skip::readn", 11100, 369}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 84, 5, 70, "ObjectName",
 CellID->3984],
Cell[CellGroupData[{
Cell[812, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1290, 53, 205, 6, 70, "Message",
 CellID->84496115],
Cell[1498, 61, 293, 9, 70, "Notes",
 CellID->26383]
}, Closed]],
Cell[CellGroupData[{
Cell[1828, 75, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331325430],
Cell[CellGroupData[{
Cell[2213, 89, 147, 5, 70, "ExampleSection",
 CellID->42425295],
Cell[2363, 96, 281, 9, 70, "ExampleText",
 CellID->33637590],
Cell[CellGroupData[{
Cell[2669, 109, 559, 16, 70, "Input",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->1236],
Cell[3231, 127, 313, 7, 70, "Message",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->95177909],
Cell[3547, 136, 161, 4, 70, "Output",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->692988907]
}, Open  ]],
Cell[3723, 143, 220, 8, 70, "ExampleText",
 CellID->40205117],
Cell[CellGroupData[{
Cell[3968, 155, 563, 16, 70, "Input",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->7551],
Cell[4534, 173, 221, 6, 70, "Output",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->463281624]
}, Open  ]],
Cell[4770, 182, 277, 9, 70, "ExampleText",
 CellID->177306465],
Cell[CellGroupData[{
Cell[5072, 195, 558, 16, 70, "Input",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->17138],
Cell[5633, 213, 312, 7, 70, "Message",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->289519788],
Cell[5948, 222, 187, 5, 70, "Output",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->223167383]
}, Open  ]],
Cell[6150, 230, 389, 13, 70, "ExampleText",
 CellID->446893242],
Cell[CellGroupData[{
Cell[6564, 247, 656, 19, 70, "Input",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->8302],
Cell[7223, 268, 197, 5, 70, "Output",
 CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"},
 CellID->592870867]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7459, 278, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

