(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7554,        281]
NotebookOptionsPosition[      4749,        187]
NotebookOutlinePosition[      6388,        238]
CellTagsIndexPosition[      6273,        232]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Reduce::ratnz", "ObjectName",
 CellID->26578],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"ratnz\"\>"}], ":", 
  " ", "\<\"Reduce was unable to solve the system with inexact coefficients. \
The answer was obtained by solving a corresponding exact system and \
numericizing the result.\"\>"}]], "Message", "MSG",
 CellID->228149951],

Cell[TextData[{
 "This message is often generated when the first  argument in ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " includes inexact numbers."
}], "Notes",
 CellID->22247]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1008996586],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->42541813],

Cell[TextData[{
 "A warning message is generated in this example as a result of the inexact  \
number ",
 StyleBox["6.0", "MR"],
 " in the input."
}], "ExampleText",
 CellID->88275562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "6.0"}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellTags->"Reduce::ratnz",
 CellLabel->"In[1]:=",
 CellID->6570],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"ratnz\"\>"}], ":", 
  " ", "\<\"Reduce was unable to solve the system with inexact coefficients. \
The answer was obtained by solving a corresponding exact system and \
numericizing the result.\"\>"}]], "Message", "MSG",
 CellTags->"Reduce::ratnz",
 CellID->463694415],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", "2.449489742783178`"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   SqrtBox[
    RowBox[{"6.`", "\[InvisibleSpace]", "-", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["x", "2"]}]}]]}]}]], "Output",
 CellTags->"Reduce::ratnz",
 CellLabel->"Out[1]=",
 CellID->2848432]
}, Open  ]],

Cell[TextData[{
 "The warning message can be avoided by using only exact numbers in the input \
 to ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->782687172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "6"}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellTags->"Reduce::ratnz",
 CellLabel->"In[2]:=",
 CellID->11998],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", 
   SqrtBox["6"]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   SqrtBox[
    RowBox[{"6", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 CellTags->"Reduce::ratnz",
 CellLabel->"Out[2]=",
 CellID->141642107]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Reduce::ratnz - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 17, 6.8193078}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Reduce::ratnz", "synonyms" -> {}, "title" -> 
    "Reduce::ratnz", "type" -> "Message", "uri" -> "ref/message/ratnz"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1846, 70, 361, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1008996586]},
 "Reduce::ratnz"->{
  Cell[2591, 101, 440, 15, 70, "Input",
   CellTags->"Reduce::ratnz",
   CellID->6570],
  Cell[3034, 118, 323, 7, 70, "Message",
   CellTags->"Reduce::ratnz",
   CellID->463694415],
  Cell[3360, 127, 317, 10, 70, "Output",
   CellTags->"Reduce::ratnz",
   CellID->2848432],
  Cell[3978, 153, 439, 15, 70, "Input",
   CellTags->"Reduce::ratnz",
   CellID->11998],
  Cell[4420, 170, 263, 10, 70, "Output",
   CellTags->"Reduce::ratnz",
   CellID->141642107]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5652, 209},
 {"Reduce::ratnz", 5792, 213}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->26578],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 295, 6, 70, "Message",
 CellID->228149951],
Cell[1555, 57, 254, 8, 70, "Notes",
 CellID->22247]
}, Closed]],
Cell[CellGroupData[{
Cell[1846, 70, 361, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1008996586],
Cell[CellGroupData[{
Cell[2232, 84, 147, 5, 70, "ExampleSection",
 CellID->42541813],
Cell[2382, 91, 184, 6, 70, "ExampleText",
 CellID->88275562],
Cell[CellGroupData[{
Cell[2591, 101, 440, 15, 70, "Input",
 CellTags->"Reduce::ratnz",
 CellID->6570],
Cell[3034, 118, 323, 7, 70, "Message",
 CellTags->"Reduce::ratnz",
 CellID->463694415],
Cell[3360, 127, 317, 10, 70, "Output",
 CellTags->"Reduce::ratnz",
 CellID->2848432]
}, Open  ]],
Cell[3692, 140, 261, 9, 70, "ExampleText",
 CellID->782687172],
Cell[CellGroupData[{
Cell[3978, 153, 439, 15, 70, "Input",
 CellTags->"Reduce::ratnz",
 CellID->11998],
Cell[4420, 170, 263, 10, 70, "Output",
 CellTags->"Reduce::ratnz",
 CellID->141642107]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4722, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

