(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17612,        607]
NotebookOptionsPosition[      7534,        298]
NotebookOutlinePosition[     15115,        522]
CellTagsIndexPosition[     14889,        513]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Replace::reps
ReplaceAll::reps
ReplaceRepeated::reps
ReplaceList::reps
ReplacePart::reps\
\>", "ObjectName",
 CellID->10405],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"reps\"\>"}], ":", 
  " ", "\<\"`1` is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing.\"\>"}]], "Message", "MSG",
 CellID->504741445],

Cell["\<\
Generated when the indicated expression does not have  the expected form of a \
rule, a list of rules, or a dispatch table. \
\>", "Notes",
 CellID->7416],

Cell[TextData[{
 StyleBox["ReplaceAll[", "MR"],
 StyleBox["expr", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["rules", "TI"],
 StyleBox["]", "MR"],
 " is usually entered as ",
 StyleBox["expr", "TI"],
 StyleBox["/.", "MR"],
 StyleBox["rules", "TI"],
 "."
}], "Notes",
 CellID->23504],

Cell[TextData[{
 StyleBox["ReplaceRepeated[", "MR"],
 StyleBox["expr", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["rules", "TI"],
 StyleBox["]", "MR"],
 " is usually entered as ",
 StyleBox["expr", "TI"],
 StyleBox["//.", "MR"],
 StyleBox["rules", "TI"],
 "."
}], "Notes",
 CellID->8559],

Cell[TextData[{
 "A rule is an expression of the form ",
 StyleBox["lhs", "TI"],
 StyleBox["->", "MR"],
 StyleBox["rhs", "TI"],
 " or ",
 StyleBox["lhs", "TI"],
 StyleBox[":>", "MR"],
 StyleBox["rhs", "TI"],
 " (",
 StyleBox["Rule[", "MR"],
 StyleBox["lhs", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["rhs", "TI"],
 StyleBox["]", "MR"],
 " or ",
 StyleBox["RuleDelayed[", "MR"],
 StyleBox["lhs", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["rhs", "TI"],
 StyleBox["]", "MR"],
 ")."
}], "Notes",
 CellID->31821],

Cell[TextData[{
 "Dispatch tables are constructed using the ",
 Cell[BoxData[
  ButtonBox["Dispatch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"],
 " function."
}], "Notes",
 CellID->4592]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112209586],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->130458094],

Cell[TextData[{
 "This input generates an error because the expression on the right-hand side \
 of ",
 StyleBox["/.", "MR"],
 " (",
 Cell[BoxData[
  ButtonBox["ReplaceRepeated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFormula"],
 ") is not a rule (or a list of rules or a dispatch table)."
}], "ExampleText",
 CellID->191570602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", "y"}]], "Input",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellLabel->"In[1]:=",
 CellID->22901],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceAll", "::", "\<\"reps\"\>"}], ":", 
  " ", "\<\"\\!\\({y}\\) is neither a list of replacement rules nor a valid \
dispatch table, and so cannot be used for replacing.\"\>"}]], "Message", \
"MSG",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->140296105],

Cell[BoxData[
 RowBox[{"x", "/.", "\[InvisibleSpace]", "y"}]], "Output",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellLabel->"Out[1]=",
 CellID->387673899]
}, Open  ]],

Cell[TextData[{
 "This type of error frequently occurs following the failure of some other  \
calculation.  For example, the invalid ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " input here gives a result that is not a list of rules."
}], "ExampleText",
 CellID->357603871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellLabel->"In[2]:=",
 CellID->23453],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"fdss\"\>"}], ":", 
  " ", "\<\"Search specification \\!\\(x\\) should be a list with 1 to 5 \
elements.\"\>"}]], "Message", "MSG",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->29462692],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceAll", "::", "\<\"reps\"\>"}], ":", 
  " ", "\<\"\\!\\({\\(FindRoot[\\(\\(\\(\\(Sin[x]\\)\\), x\\)\\)]\\)}\\) is \
neither a list of replacement rules nor a valid dispatch table, and so cannot \
be used for replacing.\"\>"}]], "Message", "MSG",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->36998116],

Cell[BoxData[
 RowBox[{"x", "/.", "\[InvisibleSpace]", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Output",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellLabel->"Out[2]=",
 CellID->945881613]
}, Open  ]],

Cell[TextData[{
 "With correct input to ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ", the result will have the correct form for use in ",
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->17904189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellLabel->"In[3]:=",
 CellID->23779],

Cell[BoxData["3.141592653589793`"], "Output",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellLabel->"Out[3]=",
 CellID->594603]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Replace::reps - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 17, 54.6642826}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Replace::reps ReplaceAll::reps ReplaceRepeated::reps ReplaceList::reps \
ReplacePart::reps", "synonyms" -> {}, "title" -> "Replace::reps", "type" -> 
    "Message", "uri" -> "ref/message/reps"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3109, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->112209586]},
 "Replace::reps"->{
  Cell[4035, 171, 192, 6, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->22901],
  Cell[4230, 179, 360, 9, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->140296105],
  Cell[4593, 190, 218, 6, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->387673899],
  Cell[5203, 212, 283, 9, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->23453],
  Cell[5489, 223, 309, 8, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->29462692],
  Cell[5801, 233, 407, 9, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->36998116],
  Cell[6211, 244, 309, 9, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->945881613],
  Cell[6943, 273, 334, 11, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->23779],
  Cell[7280, 286, 188, 5, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->594603]},
 "ReplaceAll::reps"->{
  Cell[4035, 171, 192, 6, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->22901],
  Cell[4230, 179, 360, 9, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->140296105],
  Cell[4593, 190, 218, 6, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->387673899],
  Cell[5203, 212, 283, 9, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->23453],
  Cell[5489, 223, 309, 8, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->29462692],
  Cell[5801, 233, 407, 9, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->36998116],
  Cell[6211, 244, 309, 9, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->945881613],
  Cell[6943, 273, 334, 11, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->23779],
  Cell[7280, 286, 188, 5, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->594603]},
 "ReplaceRepeated::reps"->{
  Cell[4035, 171, 192, 6, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->22901],
  Cell[4230, 179, 360, 9, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->140296105],
  Cell[4593, 190, 218, 6, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->387673899],
  Cell[5203, 212, 283, 9, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->23453],
  Cell[5489, 223, 309, 8, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->29462692],
  Cell[5801, 233, 407, 9, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->36998116],
  Cell[6211, 244, 309, 9, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->945881613],
  Cell[6943, 273, 334, 11, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->23779],
  Cell[7280, 286, 188, 5, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->594603]},
 "ReplaceList::reps"->{
  Cell[4035, 171, 192, 6, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->22901],
  Cell[4230, 179, 360, 9, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->140296105],
  Cell[4593, 190, 218, 6, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->387673899],
  Cell[5203, 212, 283, 9, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->23453],
  Cell[5489, 223, 309, 8, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->29462692],
  Cell[5801, 233, 407, 9, 70, "Message",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->36998116],
  Cell[6211, 244, 309, 9, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->945881613],
  Cell[6943, 273, 334, 11, 70, "Input",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->23779],
  Cell[7280, 286, 188, 5, 70, "Output",
   CellTags->{
    "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
     "ReplaceList::reps"},
   CellID->594603]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8519, 322},
 {"Replace::reps", 8659, 326},
 {"ReplaceAll::reps", 10215, 372},
 {"ReplaceRepeated::reps", 11776, 418},
 {"ReplaceList::reps", 13333, 464}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 134, 7, 70, "ObjectName",
 CellID->10405],
Cell[CellGroupData[{
Cell[862, 38, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1340, 55, 264, 6, 70, "Message",
 CellID->504741445],
Cell[1607, 63, 164, 4, 70, "Notes",
 CellID->7416],
Cell[1774, 69, 279, 12, 70, "Notes",
 CellID->23504],
Cell[2056, 83, 284, 12, 70, "Notes",
 CellID->8559],
Cell[2343, 97, 503, 23, 70, "Notes",
 CellID->31821],
Cell[2849, 122, 223, 8, 70, "Notes",
 CellID->4592]
}, Closed]],
Cell[CellGroupData[{
Cell[3109, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112209586],
Cell[CellGroupData[{
Cell[3494, 149, 148, 5, 70, "ExampleSection",
 CellID->130458094],
Cell[3645, 156, 365, 11, 70, "ExampleText",
 CellID->191570602],
Cell[CellGroupData[{
Cell[4035, 171, 192, 6, 70, "Input",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->22901],
Cell[4230, 179, 360, 9, 70, "Message",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->140296105],
Cell[4593, 190, 218, 6, 70, "Output",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->387673899]
}, Open  ]],
Cell[4826, 199, 352, 9, 70, "ExampleText",
 CellID->357603871],
Cell[CellGroupData[{
Cell[5203, 212, 283, 9, 70, "Input",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->23453],
Cell[5489, 223, 309, 8, 70, "Message",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->29462692],
Cell[5801, 233, 407, 9, 70, "Message",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->36998116],
Cell[6211, 244, 309, 9, 70, "Output",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->945881613]
}, Open  ]],
Cell[6535, 256, 383, 13, 70, "ExampleText",
 CellID->17904189],
Cell[CellGroupData[{
Cell[6943, 273, 334, 11, 70, "Input",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->23779],
Cell[7280, 286, 188, 5, 70, "Output",
 CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
   "ReplaceList::reps"},
 CellID->594603]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7507, 296, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

