(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9131,        320]
NotebookOptionsPosition[      5340,        206]
NotebookOutlinePosition[      7784,        275]
CellTagsIndexPosition[      7631,        268]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Resolve::bddom
FindInstance::bddom\
\>", "ObjectName",
 CellID->27535],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"bddom\"\>"}], ":", 
  " ", "\<\"Value `1` of the domain argument should be Complexes, Reals, \
Algebraics, Rationals, Integers, Primes, Booleans, or Automatic.\"\>"}]], \
"Message", "MSG",
 CellID->298452972],

Cell["\<\
Generated when the domain specification in the  indicated function does not \
have one of the expected values. \
\>", "Notes",
 CellID->318],

Cell[TextData[{
 "The domain specification is the second argument in ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " and the third argument in ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11695]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->857343217],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->374238438],

Cell[TextData[{
 "An error message is generated in this example because ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 " is not a valid domain specification."
}], "ExampleText",
 CellID->474105545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "5"}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integer"}], "]"}]], "Input",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellLabel->"In[1]:=",
 CellID->4122],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "::", "\<\"bddom\"\>"}], ":", 
  " ", "\<\"Value \\!\\(Integer\\) of the domain argument should be \
Complexes, Reals, Algebraics, Rationals, Integers, Primes, Booleans, or \
Automatic.\"\>"}]], "Message", "MSG",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellID->60047032],

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "5"}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integer"}], "]"}]], "Output",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellLabel->"Out[1]=",
 CellID->6080291]
}, Open  ]],

Cell[TextData[{
 "This shows a valid domain specification in ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->311843944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "5"}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellLabel->"In[2]:=",
 CellID->4578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "2"}]}], "}"}], "}"}]], "Output",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellLabel->"Out[2]=",
 CellID->334084212]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Resolve::bddom - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 17, 55.1799208}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Resolve::bddom FindInstance::bddom", "synonyms" -> {}, 
    "title" -> "Resolve::bddom", "type" -> "Message", "uri" -> 
    "ref/message/bddom"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2145, 85, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->857343217]},
 "FindInstance::bddom"->{
  Cell[2977, 118, 472, 15, 70, "Input",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->4122],
  Cell[3452, 135, 335, 7, 70, "Message",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->60047032],
  Cell[3790, 144, 478, 15, 70, "Output",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->6080291],
  Cell[4542, 174, 473, 15, 70, "Input",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->4578],
  Cell[5018, 191, 256, 8, 70, "Output",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->334084212]},
 "Resolve::bddom"->{
  Cell[2977, 118, 472, 15, 70, "Input",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->4122],
  Cell[3452, 135, 335, 7, 70, "Message",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->60047032],
  Cell[3790, 144, 478, 15, 70, "Output",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->6080291],
  Cell[4542, 174, 473, 15, 70, "Input",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->4578],
  Cell[5018, 191, 256, 8, 70, "Output",
   CellTags->{"FindInstance::bddom", "Resolve::bddom"},
   CellID->334084212]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6272, 229},
 {"FindInstance::bddom", 6417, 233},
 {"Resolve::bddom", 7023, 249}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 80, 4, 70, "ObjectName",
 CellID->27535],
Cell[CellGroupData[{
Cell[808, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1286, 52, 285, 7, 70, "Message",
 CellID->298452972],
Cell[1574, 61, 150, 4, 70, "Notes",
 CellID->318],
Cell[1727, 67, 381, 13, 70, "Notes",
 CellID->11695]
}, Closed]],
Cell[CellGroupData[{
Cell[2145, 85, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->857343217],
Cell[CellGroupData[{
Cell[2530, 99, 148, 5, 70, "ExampleSection",
 CellID->374238438],
Cell[2681, 106, 271, 8, 70, "ExampleText",
 CellID->474105545],
Cell[CellGroupData[{
Cell[2977, 118, 472, 15, 70, "Input",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellID->4122],
Cell[3452, 135, 335, 7, 70, "Message",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellID->60047032],
Cell[3790, 144, 478, 15, 70, "Output",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellID->6080291]
}, Open  ]],
Cell[4283, 162, 234, 8, 70, "ExampleText",
 CellID->311843944],
Cell[CellGroupData[{
Cell[4542, 174, 473, 15, 70, "Input",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellID->4578],
Cell[5018, 191, 256, 8, 70, "Output",
 CellTags->{"FindInstance::bddom", "Resolve::bddom"},
 CellID->334084212]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5313, 204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

