(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6210,        231]
NotebookOptionsPosition[      3837,        151]
NotebookOutlinePosition[      5268,        196]
CellTagsIndexPosition[      5156,        190]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Root::mdeg", "ObjectName",
 CellID->18683],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"mdeg\"\>"}], ":", 
  " ", "\<\"The degree `1` of the input polynomial `2` is not an integer \
between 1 and $MaxRootDegree.\"\>"}]], "Message", "MSG",
 CellID->162177949],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " is used with a polynomial for which the polynomial degree does not have  \
the indicated form."
}], "Notes",
 CellID->19310],

Cell[TextData[{
 "The limit ",
 Cell[BoxData[
  ButtonBox["$MaxRootDegree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxRootDegree"]], "InlineFormula"],
 " on the degree of a polynomial in ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " is included to prevent calculations that would otherwise be prohibitively  \
time-consuming."
}], "Notes",
 CellID->11359]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->408713821],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->726188],

Cell[TextData[{
 "With the default value of ",
 Cell[BoxData[
  ButtonBox["$MaxRootDegree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxRootDegree"]], "InlineFormula"],
 ", this input will generate an error and the root will not be computed."
}], "ExampleText",
 CellID->68296527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"x", "^", "1000000"}]}], ",", "1"}], "]"}]], "Input",
 CellTags->"Root::mdeg",
 CellLabel->"In[1]:=",
 CellID->31012],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"mdeg\"\>"}], ":", 
  " ", "\<\"The degree \\!\\(1000000\\) of the input polynomial \\!\\(2 + \
x\\^1000000\\) is not an integer between 1 and $MaxRootDegree.\"\>"}]], \
"Message", "MSG",
 CellTags->"Root::mdeg",
 CellID->193825110],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"2", "+", 
    SuperscriptBox["x", "1000000"]}], ",", "1"}], "]"}]], "Output",
 CellTags->"Root::mdeg",
 CellLabel->"Out[1]=",
 CellID->18081533]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Root::mdeg - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 10.3053080}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Root::mdeg", "synonyms" -> {}, "title" -> "Root::mdeg", 
    "type" -> "Message", "uri" -> "ref/message/mdeg"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2231, 86, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->408713821]},
 "Root::mdeg"->{
  Cell[3078, 119, 199, 7, 70, "Input",
   CellTags->"Root::mdeg",
   CellID->31012],
  Cell[3280, 128, 284, 7, 70, "Message",
   CellTags->"Root::mdeg",
   CellID->193825110],
  Cell[3567, 137, 204, 7, 70, "Output",
   CellTags->"Root::mdeg",
   CellID->18081533]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4731, 173},
 {"Root::mdeg", 4867, 177}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 48, 1, 70, "ObjectName",
 CellID->18683],
Cell[CellGroupData[{
Cell[776, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1254, 49, 223, 5, 70, "Message",
 CellID->162177949],
Cell[1480, 56, 274, 9, 70, "Notes",
 CellID->19310],
Cell[1757, 67, 437, 14, 70, "Notes",
 CellID->11359]
}, Closed]],
Cell[CellGroupData[{
Cell[2231, 86, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->408713821],
Cell[CellGroupData[{
Cell[2616, 100, 145, 5, 70, "ExampleSection",
 CellID->726188],
Cell[2764, 107, 289, 8, 70, "ExampleText",
 CellID->68296527],
Cell[CellGroupData[{
Cell[3078, 119, 199, 7, 70, "Input",
 CellTags->"Root::mdeg",
 CellID->31012],
Cell[3280, 128, 284, 7, 70, "Message",
 CellTags->"Root::mdeg",
 CellID->193825110],
Cell[3567, 137, 204, 7, 70, "Output",
 CellTags->"Root::mdeg",
 CellID->18081533]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3810, 149, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

