(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6707,        260]
NotebookOptionsPosition[      3938,        166]
NotebookOutlinePosition[      5555,        217]
CellTagsIndexPosition[      5442,        211]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Root::npoly", "ObjectName",
 CellID->24010],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"npoly\"\>"}], ":", 
  " ", "\<\"`1` is not a polynomial with rational number \
coefficients.\"\>"}]], "Message", "MSG",
 CellID->37683663],

Cell[TextData[{
 "Generated when the argument in ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " is not a polynomial in the indicated variable."
}], "Notes",
 CellID->2947]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117796800],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->457207268],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " function is intended only for use with univariate polynomials (expressions \
 with a single variable and integer exponents)."
}], "ExampleText",
 CellID->310995280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], ",", "1"}], "]"}]], "Input",
 CellTags->"Root::npoly",
 CellLabel->"In[1]:=",
 CellID->28045],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"npoly\"\>"}], ":", 
  " ", "\<\"\\!\\(2 - \\@x\\) is not a polynomial in \\!\\(x\\).\"\>"}]], \
"Message", "MSG",
 CellTags->"Root::npoly",
 CellID->210753961],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    SqrtBox["x"]}], ",", "1"}], "]"}]], "Output",
 CellTags->"Root::npoly",
 CellLabel->"Out[1]=",
 CellID->272339574]
}, Open  ]],

Cell[TextData[{
 "The root of this expression can be computed using ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->11077382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "-", 
     RowBox[{"Sqrt", "[", "x", "]"}]}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellTags->"Root::npoly",
 CellLabel->"In[2]:=",
 CellID->26889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "4"}], "}"}], "}"}]], "Output",
 CellTags->"Root::npoly",
 CellLabel->"Out[2]=",
 CellID->83063830]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Root::npoly - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 10.4771874}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Root::npoly", "synonyms" -> {}, "title" -> "Root::npoly", 
    "type" -> "Message", "uri" -> "ref/message/npoly"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1727, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->117796800]},
 "Root::npoly"->{
  Cell[2591, 103, 202, 7, 70, "Input",
   CellTags->"Root::npoly",
   CellID->28045],
  Cell[2796, 112, 212, 6, 70, "Message",
   CellTags->"Root::npoly",
   CellID->210753961],
  Cell[3011, 120, 188, 7, 70, "Output",
   CellTags->"Root::npoly",
   CellID->272339574],
  Cell[3465, 142, 233, 9, 70, "Input",
   CellTags->"Root::npoly",
   CellID->26889],
  Cell[3701, 153, 171, 6, 70, "Output",
   CellTags->"Root::npoly",
   CellID->83063830]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4836, 188},
 {"Root::npoly", 4973, 192}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->24010],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 191, 5, 70, "Message",
 CellID->37683663],
Cell[1449, 56, 241, 8, 70, "Notes",
 CellID->2947]
}, Closed]],
Cell[CellGroupData[{
Cell[1727, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117796800],
Cell[CellGroupData[{
Cell[2112, 83, 148, 5, 70, "ExampleSection",
 CellID->457207268],
Cell[2263, 90, 303, 9, 70, "ExampleText",
 CellID->310995280],
Cell[CellGroupData[{
Cell[2591, 103, 202, 7, 70, "Input",
 CellTags->"Root::npoly",
 CellID->28045],
Cell[2796, 112, 212, 6, 70, "Message",
 CellTags->"Root::npoly",
 CellID->210753961],
Cell[3011, 120, 188, 7, 70, "Output",
 CellTags->"Root::npoly",
 CellID->272339574]
}, Open  ]],
Cell[3214, 130, 226, 8, 70, "ExampleText",
 CellID->11077382],
Cell[CellGroupData[{
Cell[3465, 142, 233, 9, 70, "Input",
 CellTags->"Root::npoly",
 CellID->26889],
Cell[3701, 153, 171, 6, 70, "Output",
 CellTags->"Root::npoly",
 CellID->83063830]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3911, 164, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

