(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6741,        265]
NotebookOptionsPosition[      3947,        169]
NotebookOutlinePosition[      5544,        220]
CellTagsIndexPosition[      5433,        214]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Root::nup", "ObjectName",
 CellID->29176],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"nup\"\>"}], ":", 
  " ", "\<\"`1` is not a univariate polynomial.\"\>"}]], "Message", "MSG",
 CellID->66091055],

Cell["\<\
Generated when the indicated expression involves more  than one variable.\
\>", "Notes",
 CellID->2889],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " function is only intended for use with univariate polynomials."
}], "Notes",
 CellID->6718]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128867266],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->466376500],

Cell[TextData[{
 "The expression ",
 StyleBox["c+x+x^5", "MR"],
 " is treated as a polynomial in the two variables ",
 StyleBox["c", "MR"],
 " and ",
 StyleBox["x", "MR"],
 "."
}], "ExampleText",
 CellID->290410507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"c", "+", "x", "+", 
    RowBox[{"x", "^", "5"}]}], ",", "1"}], "]"}]], "Input",
 CellTags->"Root::nup",
 CellLabel->"In[1]:=",
 CellID->23612],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"nup\"\>"}], ":", 
  " ", "\<\"\\!\\(c + x + x\\^5\\) is not a univariate polynomial.\"\>"}]], \
"Message", "MSG",
 CellTags->"Root::nup",
 CellID->236767998],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"c", "+", "x", "+", 
    SuperscriptBox["x", "5"]}], ",", "1"}], "]"}]], "Output",
 CellTags->"Root::nup",
 CellLabel->"Out[1]=",
 CellID->298846356]
}, Open  ]],

Cell["\<\
You can use a pure function to indicate a univariate polynomial with symbolic \
coefficients.\
\>", "ExampleText",
 CellID->288628085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c", "+", "#", "+", 
      RowBox[{"#", "^", "5"}]}], ")"}], " ", "&"}], ",", "1"}], 
  "]"}]], "Input",
 CellTags->"Root::nup",
 CellLabel->"In[2]:=",
 CellID->11914],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "+", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]], "Output",
 CellTags->"Root::nup",
 CellLabel->"Out[2]=",
 CellID->216957362]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Root::nup - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 10.6490668}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Root::nup", "synonyms" -> {}, "title" -> "Root::nup", 
    "type" -> "Message", "uri" -> "ref/message/nup"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1803, 73, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->128867266]},
 "Root::nup"->{
  Cell[2579, 107, 202, 7, 70, "Input",
   CellTags->"Root::nup",
   CellID->23612],
  Cell[2784, 116, 210, 6, 70, "Message",
   CellTags->"Root::nup",
   CellID->236767998],
  Cell[2997, 124, 208, 7, 70, "Output",
   CellTags->"Root::nup",
   CellID->298846356],
  Cell[3389, 142, 258, 10, 70, "Input",
   CellTags->"Root::nup",
   CellID->11914],
  Cell[3650, 154, 231, 8, 70, "Output",
   CellTags->"Root::nup",
   CellID->216957362]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4837, 191},
 {"Root::nup", 4972, 195}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 47, 1, 70, "ObjectName",
 CellID->29176],
Cell[CellGroupData[{
Cell[775, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1253, 49, 164, 4, 70, "Message",
 CellID->66091055],
Cell[1420, 55, 113, 3, 70, "Notes",
 CellID->2889],
Cell[1536, 60, 230, 8, 70, "Notes",
 CellID->6718]
}, Closed]],
Cell[CellGroupData[{
Cell[1803, 73, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128867266],
Cell[CellGroupData[{
Cell[2188, 87, 148, 5, 70, "ExampleSection",
 CellID->466376500],
Cell[2339, 94, 215, 9, 70, "ExampleText",
 CellID->290410507],
Cell[CellGroupData[{
Cell[2579, 107, 202, 7, 70, "Input",
 CellTags->"Root::nup",
 CellID->23612],
Cell[2784, 116, 210, 6, 70, "Message",
 CellTags->"Root::nup",
 CellID->236767998],
Cell[2997, 124, 208, 7, 70, "Output",
 CellTags->"Root::nup",
 CellID->298846356]
}, Open  ]],
Cell[3220, 134, 144, 4, 70, "ExampleText",
 CellID->288628085],
Cell[CellGroupData[{
Cell[3389, 142, 258, 10, 70, "Input",
 CellTags->"Root::nup",
 CellID->11914],
Cell[3650, 154, 231, 8, 70, "Output",
 CellTags->"Root::nup",
 CellID->216957362]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3920, 167, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

