(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7551,        282]
NotebookOptionsPosition[      3977,        169]
NotebookOutlinePosition[      6260,        237]
CellTagsIndexPosition[      6119,        230]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Roots::eqn
NRoots::eqn\
\>", "ObjectName",
 CellID->648],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"eqn\"\>"}], ":", 
  " ", "\<\"`1` is not an equation.\"\>"}]], "Message", "MSG",
 CellID->287992259],

Cell["\<\
Generated when the indicated expression is expected to  be an equation.\
\>", "Notes",
 CellID->15267],

Cell[TextData[{
 "An equation is an expression of the  form ",
 StyleBox["lhs", "TI"],
 StyleBox["==", "MR"],
 StyleBox["rhs", "TI"],
 ", or ",
 StyleBox["Equal[", "MR"],
 StyleBox["lhs", "TI"],
 StyleBox[",", "MR"],
 StyleBox["rhs", "TI"],
 StyleBox["]", "MR"],
 "."
}], "Notes",
 CellID->27722]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->446498366],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->232812343],

Cell["A polynomial is not by itself an equation.", "ExampleText",
 CellID->215314357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"5", "x"}], "+", "6"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellLabel->"In[1]:=",
 CellID->18877],

Cell[BoxData[
 RowBox[{
  RowBox[{"Roots", "::", "\<\"eqn\"\>"}], ":", 
  " ", "\<\"\\!\\(6 - \\(\\(5\\\\ x\\)\\) + x\\^2\\) is not an \
equation.\"\>"}]], "Message", "MSG",
 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellID->34190970],

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{"6", "-", 
    RowBox[{"5", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", "x"}], "]"}]], "Output",
 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellLabel->"Out[1]=",
 CellID->452110296]
}, Open  ]],

Cell["\<\
An equation can be entered by setting this polynomial equal to zero.\
\>", "ExampleText",
 CellID->189228739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"5", "x"}], "+", "6"}], "==", "0"}], ",", "x"}], "]"}]], "Input",\

 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellLabel->"In[2]:=",
 CellID->61173470],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "2"}], "||", 
  RowBox[{"x", "\[Equal]", "3"}]}]], "Output",
 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellLabel->"Out[2]=",
 CellID->708454277]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Roots::eqn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 11.1490796}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Roots::eqn NRoots::eqn", "synonyms" -> {}, "title" -> 
    "Roots::eqn", "type" -> "Message", "uri" -> "ref/message/eqn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1900, 82, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->446498366]},
 "Roots::eqn"->{
  Cell[2546, 108, 241, 8, 70, "Input",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->18877],
  Cell[2790, 118, 234, 6, 70, "Message",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->34190970],
  Cell[3027, 126, 252, 8, 70, "Output",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->452110296],
  Cell[3438, 144, 274, 10, 70, "Input",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->61173470],
  Cell[3715, 156, 196, 6, 70, "Output",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->708454277]},
 "NRoots::eqn"->{
  Cell[2546, 108, 241, 8, 70, "Input",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->18877],
  Cell[2790, 118, 234, 6, 70, "Message",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->34190970],
  Cell[3027, 126, 252, 8, 70, "Output",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->452110296],
  Cell[3438, 144, 274, 10, 70, "Input",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->61173470],
  Cell[3715, 156, 196, 6, 70, "Output",
   CellTags->{"Roots::eqn", "NRoots::eqn"},
   CellID->708454277]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4882, 191},
 {"Roots::eqn", 5018, 195},
 {"NRoots::eqn", 5566, 211}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 66, 4, 70, "ObjectName",
 CellID->648],
Cell[CellGroupData[{
Cell[794, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1272, 52, 177, 5, 70, "Message",
 CellID->287992259],
Cell[1452, 59, 112, 3, 70, "Notes",
 CellID->15267],
Cell[1567, 64, 296, 13, 70, "Notes",
 CellID->27722]
}, Closed]],
Cell[CellGroupData[{
Cell[1900, 82, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->446498366],
Cell[CellGroupData[{
Cell[2285, 96, 148, 5, 70, "ExampleSection",
 CellID->232812343],
Cell[2436, 103, 85, 1, 70, "ExampleText",
 CellID->215314357],
Cell[CellGroupData[{
Cell[2546, 108, 241, 8, 70, "Input",
 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellID->18877],
Cell[2790, 118, 234, 6, 70, "Message",
 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellID->34190970],
Cell[3027, 126, 252, 8, 70, "Output",
 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellID->452110296]
}, Open  ]],
Cell[3294, 137, 119, 3, 70, "ExampleText",
 CellID->189228739],
Cell[CellGroupData[{
Cell[3438, 144, 274, 10, 70, "Input",
 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellID->61173470],
Cell[3715, 156, 196, 6, 70, "Output",
 CellTags->{"Roots::eqn", "NRoots::eqn"},
 CellID->708454277]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3950, 167, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

