(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8953,        303]
NotebookOptionsPosition[      4698,        181]
NotebookOutlinePosition[      7535,        260]
CellTagsIndexPosition[      7358,        253]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
SchurDecomposition::schurf
HessenbergDecomposition::schurf\
\>", "ObjectName",
 CellID->18136],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"schurf\"\>"}], ":", 
  " ", "\<\"`1` has received a matrix with infinite precision.\"\>"}]], \
"Message", "MSG",
 CellID->192544107],

Cell[TextData[{
 "Generated when the first argument in ",
 Cell[BoxData[
  ButtonBox["SchurDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SchurDecomposition"]], "InlineFormula"],
 " is a matrix in which the elements are integers, rational numbers, or exact \
 complex numbers. "
}], "Notes",
 CellID->24925]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160914780],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->860332677],

Cell["\<\
An error occurs in this example because all of the matrix elements are \
integers.\
\>", "ExampleText",
 CellID->500694133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellLabel->"In[1]:=",
 CellID->17754],

Cell[BoxData[
 RowBox[{
  RowBox[{"SchurDecomposition", "::", "\<\"schurf\"\>"}], ":", 
  " ", "\<\"\\!\\(SchurDecomposition\\) has received a matrix with infinite \
precision.\"\>"}]], "Message", "MSG",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellID->639010767],

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]], "Output",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellLabel->"Out[1]=",
 CellID->531301506]
}, Open  ]],

Cell["\<\
This computation can be done by converting the matrix elements into inexact \
numbers.\
\>", "ExampleText",
 CellID->113660040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellLabel->"In[2]:=",
 CellID->16627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellLabel->"Out[2]=",
 CellID->670965]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SchurDecomposition::schurf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 26.4150954}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SchurDecomposition::schurf HessenbergDecomposition::schurf",
     "synonyms" -> {}, "title" -> "SchurDecomposition::schurf", "type" -> 
    "Message", "uri" -> "ref/message/schurf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1884, 74, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->160914780]},
 "SchurDecomposition::schurf"->{
  Cell[2578, 103, 337, 10, 70, "Input",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->17754],
  Cell[2918, 115, 301, 6, 70, "Message",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->639010767],
  Cell[3222, 123, 342, 10, 70, "Output",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->531301506],
  Cell[3741, 144, 371, 11, 70, "Input",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->16627],
  Cell[4115, 157, 517, 17, 70, "Output",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->670965]},
 "HessenbergDecomposition::schurf"->{
  Cell[2578, 103, 337, 10, 70, "Input",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->17754],
  Cell[2918, 115, 301, 6, 70, "Message",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->639010767],
  Cell[3222, 123, 342, 10, 70, "Output",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->531301506],
  Cell[3741, 144, 371, 11, 70, "Input",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->16627],
  Cell[4115, 157, 517, 17, 70, "Output",
   CellTags->{
    "SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
   CellID->670965]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5679, 204},
 {"SchurDecomposition::schurf", 5831, 208},
 {"HessenbergDecomposition::schurf", 6602, 229}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 104, 4, 70, "ObjectName",
 CellID->18136],
Cell[CellGroupData[{
Cell[832, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1310, 52, 209, 6, 70, "Message",
 CellID->192544107],
Cell[1522, 60, 325, 9, 70, "Notes",
 CellID->24925]
}, Closed]],
Cell[CellGroupData[{
Cell[1884, 74, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160914780],
Cell[CellGroupData[{
Cell[2269, 88, 148, 5, 70, "ExampleSection",
 CellID->860332677],
Cell[2420, 95, 133, 4, 70, "ExampleText",
 CellID->500694133],
Cell[CellGroupData[{
Cell[2578, 103, 337, 10, 70, "Input",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellID->17754],
Cell[2918, 115, 301, 6, 70, "Message",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellID->639010767],
Cell[3222, 123, 342, 10, 70, "Output",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellID->531301506]
}, Open  ]],
Cell[3579, 136, 137, 4, 70, "ExampleText",
 CellID->113660040],
Cell[CellGroupData[{
Cell[3741, 144, 371, 11, 70, "Input",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellID->16627],
Cell[4115, 157, 517, 17, 70, "Output",
 CellTags->{"SchurDecomposition::schurf", "HessenbergDecomposition::schurf"},
 CellID->670965]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4671, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

