(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10310,        341]
NotebookOptionsPosition[      6528,        220]
NotebookOutlinePosition[      8664,        284]
CellTagsIndexPosition[      8541,        278]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SequenceLimit::seqlim", "ObjectName",
 CellID->32035],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SequenceLimit", "::", "\<\"seqlim\"\>"}], ":", 
  " ", "\<\"The general form of the sequence could not be determined, and the \
result may be incorrect.\"\>"}]], "Message", "MSG",
 CellID->340832035],

Cell[TextData[{
 "Generated when the list of numbers in the first  argument of ",
 Cell[BoxData["SequenceLimit"], "InlineFormula"],
 " does not correspond to a sequence that the algorithm used by ",
 Cell[BoxData["SequenceLimit"], "InlineFormula"],
 " is designed to handle."
}], "Notes",
 CellID->21189],

Cell[TextData[{
 "Since ",
 Cell[BoxData["SequenceLimit"], "InlineFormula"],
 " is used internally by other functions, this message can be generated even \
if ",
 Cell[BoxData["SequenceLimit"], "InlineFormula"],
 " is not called directly."
}], "Notes",
 CellID->8953]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64098282],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->432499478],

Cell["\<\
A warning message is generated in this example because this sequence does not \
appear to converge to a well-defined limit.\
\>", "ExampleText",
 CellID->4942067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SequenceLimit", "[", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "1", ",", "2", ",", "5", ",", "0", ",", "1", ",", "2", ",", 
    "5"}], "}"}], "]"}]], "Input",
 CellTags->"SequenceLimit::seqlim",
 CellLabel->"In[1]:=",
 CellID->347116727],

Cell[BoxData[
 RowBox[{
  RowBox[{"SequenceLimit", "::", "\<\"seqlim\"\>"}], ":", 
  " ", "\<\"The general form of the sequence could not be determined, and the \
result may be incorrect.\"\>"}]], "Message", "MSG",
 CellTags->"SequenceLimit::seqlim",
 CellID->106508595],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 CellTags->"SequenceLimit::seqlim",
 CellLabel->"Out[1]=",
 CellID->704501078]
}, Open  ]],

Cell[TextData[{
 "This warning message can also be by generated by ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " when the value of the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option is ",
 Cell[BoxData["\"\<Oscillatory\>\""], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->1028104557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Oscillatory\>\""}]}], "]"}]], "Input",
 CellTags->"SequenceLimit::seqlim",
 CellLabel->"In[2]:=",
 CellID->28406],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deorela\"\>"}], ":", 
  " ", "\<\"The relative error \\!\\(8.501720343483132`\\) is larger than \
expected for the integrand \\!\\(\\(Sin[x]\\)\\/\\(2 + \
\\(\\(Sin[x]\\)\\)\\)\\) over \\!\\({0, \[Infinity]}\\) with \
DoubleExponentialOscillatory method and automatic tuning parameters, \
TuningParameters -> \\!\\({10, 5}\\). The integration will proceed with \
TuningParameters -> \\!\\({1, 5}\\).\"\>"}]], "Message", "MSG",
 CellTags->"SequenceLimit::seqlim",
 CellID->786816565],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deoncon\"\>"}], ":", 
  " ", "\<\"DoubleExponentialOscillatory has failed to converge for the \
integrand \\!\\(\\(Sin[x]\\)\\/\\(2 + \\(\\(Sin[x]\\)\\)\\)\\) over \\!\\({0, \
\[Infinity]}\\). DoubleExponentialOscillatory obtained \
\\!\\(-16108.167721601683`\\) and \\!\\(0.4354503969122706`\\) for the \
integral and error estimates.\"\>"}]], "Message", "MSG",
 CellTags->"SequenceLimit::seqlim",
 CellID->791277284],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"mtdfb\"\>"}], ":", 
  " ", "\<\"Numerical integration with \\!\\(\\\"DoubleExponentialOscillatory\
\\\"\\) failed. The integration continues with Method -> \
\\!\\({\\\"ExtrapolatingOscillatory\\\", \\(\\(Method \[Rule] \
\\\"GlobalAdaptive\\\"\\)\\)}\\).\"\>"}]], "Message", "MSG",
 CellTags->"SequenceLimit::seqlim",
 CellID->632677581],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({6.3886967935314255`*^56}\\). NIntegrate obtained \
\\!\\(1.0993960749383244`*^243\\) and \\!\\(1.0836513078518371`*^243\\) for \
the integral and error estimates.\"\>"}]], "Message", "MSG",
 CellTags->"SequenceLimit::seqlim",
 CellID->445786586],

Cell[BoxData["1.0993960749383244`*^243"], "Output",
 CellTags->"SequenceLimit::seqlim",
 CellLabel->"Out[2]=",
 CellID->44893938]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SequenceLimit::seqlim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 34.4465510}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SequenceLimit::seqlim", "synonyms" -> {}, "title" -> 
    "SequenceLimit::seqlim", "type" -> "Message", "uri" -> 
    "ref/message/seqlim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2113, 78, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->64098282]},
 "SequenceLimit::seqlim"->{
  Cell[2845, 107, 261, 8, 70, "Input",
   CellTags->"SequenceLimit::seqlim",
   CellID->347116727],
  Cell[3109, 117, 270, 6, 70, "Message",
   CellTags->"SequenceLimit::seqlim",
   CellID->106508595],
  Cell[3382, 125, 127, 4, 70, "Output",
   CellTags->"SequenceLimit::seqlim",
   CellID->704501078],
  Cell[4001, 151, 431, 13, 70, "Input",
   CellTags->"SequenceLimit::seqlim",
   CellID->28406],
  Cell[4435, 166, 541, 10, 70, "Message",
   CellTags->"SequenceLimit::seqlim",
   CellID->786816565],
  Cell[4979, 178, 477, 9, 70, "Message",
   CellTags->"SequenceLimit::seqlim",
   CellID->791277284],
  Cell[5459, 189, 397, 8, 70, "Message",
   CellTags->"SequenceLimit::seqlim",
   CellID->632677581],
  Cell[5859, 199, 471, 9, 70, "Message",
   CellTags->"SequenceLimit::seqlim",
   CellID->445786586],
  Cell[6333, 210, 129, 3, 70, "Output",
   CellTags->"SequenceLimit::seqlim",
   CellID->44893938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7462, 243},
 {"SequenceLimit::seqlim", 7608, 247}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 59, 1, 70, "ObjectName",
 CellID->32035],
Cell[CellGroupData[{
Cell[787, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1265, 49, 234, 5, 70, "Message",
 CellID->340832035],
Cell[1502, 56, 304, 7, 70, "Notes",
 CellID->21189],
Cell[1809, 65, 267, 8, 70, "Notes",
 CellID->8953]
}, Closed]],
Cell[CellGroupData[{
Cell[2113, 78, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64098282],
Cell[CellGroupData[{
Cell[2497, 92, 148, 5, 70, "ExampleSection",
 CellID->432499478],
Cell[2648, 99, 172, 4, 70, "ExampleText",
 CellID->4942067],
Cell[CellGroupData[{
Cell[2845, 107, 261, 8, 70, "Input",
 CellTags->"SequenceLimit::seqlim",
 CellID->347116727],
Cell[3109, 117, 270, 6, 70, "Message",
 CellTags->"SequenceLimit::seqlim",
 CellID->106508595],
Cell[3382, 125, 127, 4, 70, "Output",
 CellTags->"SequenceLimit::seqlim",
 CellID->704501078]
}, Open  ]],
Cell[3524, 132, 452, 15, 70, "ExampleText",
 CellID->1028104557],
Cell[CellGroupData[{
Cell[4001, 151, 431, 13, 70, "Input",
 CellTags->"SequenceLimit::seqlim",
 CellID->28406],
Cell[4435, 166, 541, 10, 70, "Message",
 CellTags->"SequenceLimit::seqlim",
 CellID->786816565],
Cell[4979, 178, 477, 9, 70, "Message",
 CellTags->"SequenceLimit::seqlim",
 CellID->791277284],
Cell[5459, 189, 397, 8, 70, "Message",
 CellTags->"SequenceLimit::seqlim",
 CellID->632677581],
Cell[5859, 199, 471, 9, 70, "Message",
 CellTags->"SequenceLimit::seqlim",
 CellID->445786586],
Cell[6333, 210, 129, 3, 70, "Output",
 CellTags->"SequenceLimit::seqlim",
 CellID->44893938]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6501, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

