(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7327,        279]
NotebookOptionsPosition[      4422,        182]
NotebookOutlinePosition[      6108,        234]
CellTagsIndexPosition[      5993,        228]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
PadeApproximant::sspec
Series::sspec\
\>", "ObjectName",
 CellID->26595],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"sspec\"\>"}], ":", 
  " ", "\<\"Series specification `1` is not a list with three \
elements.\"\>"}]], "Message", "MSG",
 CellID->695938838],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " does not have the expected form."
}], "Notes",
 CellID->3310],

Cell[TextData[{
 "The second argument  in ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " is expected to be a list giving the expansion variable, the expansion  \
point, and the number of terms to compute."
}], "Notes",
 CellID->30130]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->802386513],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->33042372],

Cell["\<\
An error occurs in this example because the second argument is a symbol \
rather than a list with three elements.\
\>", "ExampleText",
 CellID->37097807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellTags->"Series::sspec",
 CellLabel->"In[1]:=",
 CellID->165630062],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"sspec\"\>"}], ":", 
  " ", "\<\"Series specification \\!\\(x\\) is not a list with three \
elements.\"\>"}]], "Message", "MSG",
 CellTags->"Series::sspec",
 CellID->384230800],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", "x"}], "]"}]], "Output",
 CellTags->"Series::sspec",
 CellLabel->"Out[1]=",
 CellID->4283571]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->367190877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Series::sspec",
 CellLabel->"In[2]:=",
 CellID->31603],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2]}, 0, 4, 1],
  Editable->False]], "Output",
 CellTags->"Series::sspec",
 CellLabel->"Out[2]=",
 CellID->93478346]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PadeApproximant::sspec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 43.4780322}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "PadeApproximant::sspec Series::sspec", "synonyms" -> {}, 
    "title" -> "PadeApproximant::sspec", "type" -> "Message", "uri" -> 
    "ref/message/sspec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2094, 84, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->802386513]},
 "Series::sspec"->{
  Cell[2817, 113, 189, 6, 70, "Input",
   CellTags->"Series::sspec",
   CellID->165630062],
  Cell[3009, 121, 230, 6, 70, "Message",
   CellTags->"Series::sspec",
   CellID->384230800],
  Cell[3242, 129, 183, 6, 70, "Output",
   CellTags->"Series::sspec",
   CellID->4283571],
  Cell[3674, 150, 239, 8, 70, "Input",
   CellTags->"Series::sspec",
   CellID->31603],
  Cell[3916, 160, 440, 15, 70, "Output",
   CellTags->"Series::sspec",
   CellID->93478346]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5372, 205},
 {"Series::sspec", 5511, 209}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 82, 4, 70, "ObjectName",
 CellID->26595],
Cell[CellGroupData[{
Cell[810, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1288, 52, 217, 6, 70, "Message",
 CellID->695938838],
Cell[1508, 60, 238, 8, 70, "Notes",
 CellID->3310],
Cell[1749, 70, 308, 9, 70, "Notes",
 CellID->30130]
}, Closed]],
Cell[CellGroupData[{
Cell[2094, 84, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->802386513],
Cell[CellGroupData[{
Cell[2479, 98, 147, 5, 70, "ExampleSection",
 CellID->33042372],
Cell[2629, 105, 163, 4, 70, "ExampleText",
 CellID->37097807],
Cell[CellGroupData[{
Cell[2817, 113, 189, 6, 70, "Input",
 CellTags->"Series::sspec",
 CellID->165630062],
Cell[3009, 121, 230, 6, 70, "Message",
 CellTags->"Series::sspec",
 CellID->384230800],
Cell[3242, 129, 183, 6, 70, "Output",
 CellTags->"Series::sspec",
 CellID->4283571]
}, Open  ]],
Cell[3440, 138, 209, 8, 70, "ExampleText",
 CellID->367190877],
Cell[CellGroupData[{
Cell[3674, 150, 239, 8, 70, "Input",
 CellTags->"Series::sspec",
 CellID->31603],
Cell[3916, 160, 440, 15, 70, "Output",
 CellTags->"Series::sspec",
 CellID->93478346]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4395, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

